/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.DataStore;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTest
extends JbpmBpmn2TestCase {
    @Test
    public void testImport() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-Import.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Import");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataObject() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataObject.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataStore() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataStore.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        Definitions def = (Definitions)processInstance.getProcess().getMetaData().get("Definitions");
        Assertions.assertNotNull((Object)def.getDataStores());
        Assertions.assertTrue((def.getDataStores().size() == 1 ? 1 : 0) != 0);
        DataStore dataStore = (DataStore)def.getDataStores().get(0);
        Assertions.assertEquals((Object)"employee", (Object)dataStore.getId());
        Assertions.assertEquals((Object)"employeeStore", (Object)dataStore.getName());
        Assertions.assertEquals((Object)String.class.getCanonicalName(), (Object)((ObjectDataType)dataStore.getType()).getClassName());
    }

    @Test
    public void testAssociation() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-Association.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation");
        List associations = (List)processInstance.getProcess().getMetaData().get("BPMN.Associations");
        Assertions.assertNotNull((Object)associations);
        Assertions.assertTrue((associations.size() == 1 ? 1 : 0) != 0);
        Association assoc = (Association)associations.get(0);
        Assertions.assertEquals((Object)"_1234", (Object)assoc.getId());
        Assertions.assertEquals((Object)"_1", (Object)assoc.getSourceRef());
        Assertions.assertEquals((Object)"_2", (Object)assoc.getTargetRef());
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess2.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EvaluationProcess3.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new SystemOutWorkItemHandler());
        this.ksession.getWorkItemManager().registerWorkItemHandler("RegisterRequest", (WorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        ProcessInstance processInstance = this.ksession.startProcess("Evaluation", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testXpathExpression() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-XpathExpression.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Document> params = new HashMap<String, Document>();
        params.put("instanceMetadata", document);
        ProcessInstance processInstance = this.ksession.startProcess("XPathProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testDataInputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"hello world", (Object)workItem.getParameter("coId"));
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithStringObject() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-string-object.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("instanceMetadata", "hello");
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    @Disabled
    public void testDataInputAssociationsWithLazyLoading() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-lazy-creating.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Object coIdParamObj = workItem.getParameter("coId");
                Assertions.assertEquals((Object)"mydoc", (Object)((Element)coIdParamObj).getNodeName());
                Assertions.assertEquals((Object)"mynode", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getNodeName());
                Assertions.assertEquals((Object)"user", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getNodeName());
                Assertions.assertEquals((Object)"hello world", (Object)((Element)workItem.getParameter("coId")).getFirstChild().getFirstChild().getAttributes().getNamedItem("hello").getNodeValue());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataInputAssociationsWithString() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataInputAssociationsWithStringWithoutQuotes() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-string-no-quotes.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"hello", (Object)workItem.getParameter("coId"));
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataInputAssociationsWithXMLLiteral() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataInputAssociations-xml-literal.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"id", (Object)((Node)workItem.getParameter("coId")).getNodeName());
                Assertions.assertEquals((Object)"some text", (Object)((Node)workItem.getParameter("coId")).getFirstChild().getTextContent());
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    @Disabled
    public void testDataInputAssociationsWithTwoAssigns() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-DataInputAssociations-two-assigns.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                Assertions.assertEquals((Object)"foo", (Object)((Element)workItem.getParameter("Comment")).getNodeName());
            }
        });
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document.getFirstChild());
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociationsforHumanTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-HumanTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                DocumentBuilder builder;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    builder = factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                HashMap<String, Element> results = new HashMap<String, Element>();
                Document processMetadaDoc = builder.newDocument();
                Element processMetadata = processMetadaDoc.createElement("previoustasksowner");
                processMetadaDoc.appendChild(processMetadata);
                processMetadata.setAttribute("primaryname", "my_result");
                results.put("output", processMetadata);
                mgr.completeWorkItem(workItem.getId(), results, new Policy[0]);
            }
        });
        HashMap params = new HashMap();
        ProcessInstance processInstance = this.ksession.startProcess("process", params);
    }

    @Test
    public void testDataOutputAssociations() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params, new Policy[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }

    @Test
    public void testDataOutputAssociationsXmlNode() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-DataOutputAssociations-xml-node.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", new WorkItemHandler(){

            public void abortWorkItem(WorkItem manager, WorkItemManager mgr) {
            }

            public void executeWorkItem(WorkItem workItem, WorkItemManager mgr) {
                try {
                    Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<user hello='hello world' />".getBytes()));
                    HashMap<String, Node> params = new HashMap<String, Node>();
                    params.put("output", document.getFirstChild());
                    mgr.completeWorkItem(workItem.getId(), params, new Policy[0]);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("process");
    }
}

