/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.StandaloneBPMNProcessTest;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.bpmn2.objects.ExceptionOnPurposeHandler;
import org.jbpm.bpmn2.objects.MyError;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventListener;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.WorkItemExecutionError;

public class ErrorEventTest
extends JbpmBpmn2TestCase {
    private ProcessEventListener LOGGING_EVENT_LISTENER = new DefaultProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            ErrorEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            ErrorEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            ErrorEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            ErrorEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @Test
    public void testEventSubprocessError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceActive(processInstance);
        this.ksession = this.restoreSession(this.ksession, true);
        this.ksession.addEventListener((ProcessEventListener)listener);
        WorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessErrorThrowOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                throw new MyError();
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId(), new Policy[0]);
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessErrorWithErrorCode() throws Exception {
        KieBase kbase = this.createKnowledgeBase("subprocess/EventSubprocessErrorHandlingWithErrorCode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script2")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = this.ksession.startProcess("order-fulfillment-bpm.ccc");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "Script1", "starterror", "Script2", "end2", "eventsubprocess");
        this.assertProcessVarValue(processInstance, "CapturedException", "java.lang.RuntimeException: XXX");
        Assertions.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEventSubprocessErrorWithOutErrorCode() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("subprocess/EventSubprocessErrorHandlingWithOutErrorCode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script2")) {
                    executednodes.add(event.getNodeInstance().getId());
                }
            }
        };
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = this.ksession.startProcess("order-fulfillment-bpm.ccc");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "Script1", "starterror", "Script2", "end2", "eventsubprocess");
        this.assertProcessVarValue(processInstance, "CapturedException", "java.lang.RuntimeException: XXX");
        Assertions.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("MyTask", (WorkItemHandler)new DoNothingWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
    }

    @Test
    public void testErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        List<WorkItem> workItems = handler.getWorkItems();
        Assertions.assertEquals((int)2, (int)workItems.size());
        WorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "error end event");
        this.assertNotNodeTriggered(processInstance.getId(), "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorBoundaryEventOnServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnServiceTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Service Task", (WorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "test");
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnServiceTask", params);
        List<WorkItem> workItems = handler.getWorkItems();
        Assertions.assertEquals((int)1, (int)workItems.size());
        this.ksession.getWorkItemManager().completeWorkItem(workItems.get(0).getId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "Service task error attached", "end0", "Script Task", "error2");
        this.assertNotNodeTriggered(processInstance.getId(), "end");
    }

    @Test
    public void testErrorBoundaryEventOnBusinessRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-ErrorBoundaryEventOnBusinessRuleTask.bpmn2", "BPMN2-ErrorBoundaryEventOnBusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnBusinessRuleTask");
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "business rule task error attached", "error1");
    }

    @Test
    public void testMultiErrorBoundaryEventsOnBusinessRuleTask() throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper("BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.bpmn2", "BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.drl");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-MultiErrorBoundaryEventeOnBusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.ksession);
        this.assertNodeTriggered(processInstance.getId(), "start", "business rule task error attached", "NPE Script Task", "error1");
        this.ksession.dispose();
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        params = new HashMap();
        params.put("person", new Person("unsupported"));
        ProcessInstance processInstance2 = this.ksession.startProcess("BPMN2-MultiErrorBoundaryEventeOnBusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance2, this.ksession);
        this.assertNodeTriggered(processInstance2.getId(), "start", "business rule task error attached", "UOE Script Task", "error2");
    }

    @Test
    public void testCatchErrorBoundaryEventOnTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                if (workItem.getParameter("ActorId").equals("mary")) {
                    throw new MyError();
                }
            }

            @Override
            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
                manager.abortWorkItem(workItem.getId(), new Policy[0]);
            }
        });
        ProcessInstance processInstance = this.ksession.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeTriggered(processInstance.getId(), "start", "split", "User Task", "User task error attached", "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask(this.ksession);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.ksession);
    }

    @Test
    public void testEventSubProcessErrorWithScript() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-EventSubProcessErrorWithScript.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        this.ksession.getWorkItemManager().registerWorkItemHandler("Request Handler", (WorkItemHandler)new SignallingTaskHandlerDecorator(ExceptionOnPurposeHandler.class, "Error-90277"));
        this.ksession.getWorkItemManager().registerWorkItemHandler("Error Handler", (WorkItemHandler)new SystemOutWorkItemHandler());
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.process");
        this.assertProcessInstanceAborted(processInstance);
        Assertions.assertEquals((Object)"90277", (Object)((WorkflowProcessInstance)processInstance).getOutcome());
    }

    @Test
    public void testErrorBoundaryEventOnEntry() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventCatchingOnEntryException.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryErrorEventOnEntry");
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        Assertions.assertEquals((int)1, (int)handler.getWorkItems().size());
    }

    @Test
    public void testErrorBoundaryEventOnExit() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventCatchingOnExitException.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("BoundaryErrorEventOnExit");
        this.assertProcessInstanceActive(processInstance.getId(), this.ksession);
        WorkItem workItem = handler.getWorkItem();
        this.ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null, new Policy[0]);
        Assertions.assertEquals((int)1, (int)handler.getWorkItems().size());
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventDefaultHandlerWithErrorCodeWithStructureRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithWorkItemExecutionError() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventDefaultHandlerByErrorCode.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        WorkItemExecutionErrorWorkItemHandler handler = new WorkItemExecutionErrorWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithoutStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventDefaultHandlerWithErrorCodeWithoutStructureRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventDefaultHandlerWithoutErrorCodeWithStructureRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithoutStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventDefaultHandlerWithoutErrorCodeWithoutStructureRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    @Test
    public void testBoundaryErrorEventSubProcessExceptionMapping() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventSubProcessExceptionMapping.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        Assertions.assertEquals((Object)"java.lang.RuntimeException", (Object)this.getProcessVarValue(processInstance, "var1"));
    }

    @Test
    public void testBoundaryErrorEventStructureRef() throws Exception {
        KieBase kbase = this.createKnowledgeBase("BPMN2-BoundaryErrorEventStructureRef.bpmn2");
        this.ksession = this.createKnowledgeSession(kbase);
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)handler);
        ProcessInstance processInstance = this.ksession.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    class WorkItemExecutionErrorWorkItemHandler
    implements WorkItemHandler {
        WorkItemExecutionErrorWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new WorkItemExecutionError("500");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }

    class ExceptionWorkItemHandler
    implements WorkItemHandler {
        ExceptionWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            throw new RuntimeException();
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
        }
    }
}

