/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.KieBase;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.process.workitem.Policy;

public class ProcessFactoryTest
extends JbpmBpmn2TestCase {
    @Test
    public void testProcessFactory() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().actionNode(2L).name("Action").action("java", "System.out.println(\"Action\");").done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ksession.startProcess("org.jbpm.process");
        ksession.dispose();
    }

    @Test
    public void testCompositeNode() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().compositeContextNode(2L).name("SubProcess").startNode(1L).name("SubProcess Start").done().actionNode(2L).name("SubProcess Action").action("java", "System.out.println(\"SubProcess Action\");").done().endNode(3L).name("SubProcess End").terminate(true).done().connection(1L, 2L).connection(2L, 3L).done().endNode(3L).name("End").done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assertions.assertEquals((Object)"SubProcess", (Object)process.getNode(2L).getName());
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assertions.assertEquals((int)2, (int)pi.getState());
        ksession.dispose();
    }

    @Test
    @Timeout(value=10L)
    public void testBoundaryTimerTimeCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        String timeCycle = "1s###5s";
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).metaData("TimeCycle", (Object)timeCycle).metaData("CancelActivity", (Object)false).eventType("Timer", timeCycle).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }

    @Test
    @Timeout(value=10L)
    public void testBoundaryTimerTimeDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        String timeDuration = "1s";
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start").done().humanTaskNode(2L).name("Task").actorId("john").taskName("MyTask").done().endNode(3L).name("End1").terminate(false).done().boundaryEventNode(4L).name("BoundaryTimerEvent").attachedTo(2L).metaData("TimeDuration", (Object)timeDuration).metaData("CancelActivity", (Object)false).eventType("Timer", timeDuration).done().endNode(5L).name("End2").terminate(false).done().connection(1L, 2L).connection(2L, 3L).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)testHandler);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getId(), "End2");
        this.assertProcessInstanceActive(pi);
        ksession.getWorkItemManager().completeWorkItem(testHandler.getWorkItem().getId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(pi);
        ksession.dispose();
    }

    @Test
    @Timeout(value=10L)
    public void testAdHocSimple() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.dynamic(true).name("Event Process").version("1").packageName("org.jbpm");
        RuleFlowProcess process = factory.validate().getProcess();
        Assertions.assertNotNull((Object)process);
        Assertions.assertTrue((boolean)process.isDynamic());
    }

    @Test
    @Timeout(value=10L)
    public void testSignalEvent() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("Event Process").version("1").packageName("org.jbpm").variable("eventData", (DataType)new StringDataType()).startNode(1L).name("Start").done().eventNode(2L).name("Event1").eventType("testEvent").variableName("eventData").done().actionNode(3L).name("simpleActionNode").action("java", "System.out.println(\"test event action\");").done().endNode(4L).name("End").done().connection(1L, 2L).connection(2L, 3L).connection(3L, 4L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assertions.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assertions.assertNotNull((Object)pi);
        Assertions.assertEquals((int)1, (int)pi.getState());
        pi.signalEvent("testEvent", null);
        Assertions.assertEquals((int)2, (int)pi.getState());
        ksession.dispose();
    }

    @Test
    @Timeout(value=10L)
    public void testActionNodeIsDroolsAction() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.name("ActionNodeActionProcess").version("1").startNode(1L).name("Start").done().endNode(3L).name("End").done().actionNode(2L).name("printTextActionNode").action("java", "System.out.println(\"test print\");", true).done().connection(1L, 2L).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Assertions.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        KieBase kbase = this.createKnowledgeBaseFromResources(res);
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        ProcessInstance pi = ksession.startProcess("org.jbpm.process");
        Assertions.assertNotNull((Object)pi);
        Assertions.assertEquals((int)2, (int)pi.getState());
        ksession.dispose();
    }
}

