/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.drools.core.io.impl.ClassPathResource;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.kie.api.KieBase;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;

public class VariableTagsTest
extends JbpmBpmn2TestCase {
    private KieSession ksession2;

    @Override
    @AfterEach
    public void disposeSession() {
        super.disposeSession();
        if (this.ksession2 != null) {
            this.ksession2.dispose();
            this.ksession2 = null;
        }
    }

    @Test
    public void testProcessWithMissingRequiredVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBase("variable-tags/approval-with-required-variable-tags.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> VariableTagsTest.lambda$testProcessWithMissingRequiredVariable$0((KieSession)ksession));
        ksession.dispose();
    }

    @Test
    public void testProcessWithRequiredVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBase("variable-tags/approval-with-required-variable-tags.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        org.kie.api.runtime.process.ProcessInstance processInstance = ksession.startProcess("approvals", parameters);
        org.junit.jupiter.api.Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        ksession = this.restoreSession((KieSession)ksession, true);
        WorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null, new Policy[0]);
        workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testProcessWithReadonlyVariable() throws Exception {
        KieBase kbase = this.createKnowledgeBase("variable-tags/approval-with-readonly-variable-tags.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        org.kie.api.runtime.process.ProcessInstance processInstance = ksession.startProcess("approvals", parameters);
        org.junit.jupiter.api.Assertions.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        WorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> VariableTagsTest.lambda$testProcessWithReadonlyVariable$1((KieSession)ksession, workItem));
        ksession.abortProcessInstance(processInstance.getId());
        this.assertProcessInstanceFinished(processInstance, (KieSession)ksession);
        ksession.dispose();
    }

    @Test
    public void testProcessWithCustomVariableTag() throws Exception {
        KieBase kbase = this.createKnowledgeBase("variable-tags/approval-with-custom-variable-tags.bpmn2");
        StatefulKnowledgeSession ksession = this.createKnowledgeSession(kbase);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)workItemHandler);
        ksession.addEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                if (event.hasTag("onlyAdmin")) {
                    throw new VariableViolationException(event.getProcessInstance().getId(), event.getVariableId(), "Variable can only be set by admins");
                }
            }
        });
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        org.junit.jupiter.api.Assertions.assertThrows(VariableViolationException.class, () -> VariableTagsTest.lambda$testProcessWithCustomVariableTag$2((KieSession)ksession, parameters));
        ksession.dispose();
    }

    @Test
    public void testRequiredVariableFiltering() {
        List processes = BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("variable-tags/approval-with-custom-variable-tags.bpmn2")});
        BpmnProcess process = (BpmnProcess)processes.get(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approver", "john");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(params));
        instance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)instance.status());
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap()).hasSize(1);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.OUTPUTS_ONLY)).hasSize(0);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INPUTS_ONLY)).hasSize(0);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INTERNAL_ONLY)).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(v -> v.hasTag("onlyAdmin"))).hasSize(1)).containsEntry((Object)"approver", (Object)"john");
        instance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)instance.status());
    }

    private static /* synthetic */ void lambda$testProcessWithCustomVariableTag$2(KieSession ksession, Map parameters) throws Throwable {
        ksession.startProcess("approvals", parameters);
    }

    private static /* synthetic */ void lambda$testProcessWithReadonlyVariable$1(KieSession ksession, WorkItem workItem) throws Throwable {
        ksession.getWorkItemManager().completeWorkItem(workItem.getId(), Collections.singletonMap("ActorId", "john"), new Policy[0]);
    }

    private static /* synthetic */ void lambda$testProcessWithMissingRequiredVariable$0(KieSession ksession) throws Throwable {
        ksession.startProcess("approvals");
    }
}

