/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;

public class EndEventTest
extends JbpmBpmn2TestCase {
    @Test
    public void testImplicitEndParallel() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ParallelSplit.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorEndEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance);
        Assertions.assertEquals((Object)"error", (Object)((ProcessInstance)processInstance).getOutcome());
    }

    @Test
    public void testEscalationEndEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationEndEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    public void testSignalEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalEndEvent.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        this.kruntime.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MessageEndEvent.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMessageEndVerifyDeploymentId() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MessageEndEvent.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        InternalKogitoWorkItem workItem = (InternalKogitoWorkItem)handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        String nodeInstanceId = workItem.getNodeInstanceStringId();
        long nodeId = workItem.getNodeId();
        String deploymentId = workItem.getDeploymentId();
        Assertions.assertNotNull((Object)nodeId);
        Assertions.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)nodeInstanceId);
        Assertions.assertNull((Object)deploymentId);
        this.kruntime.getKieRuntime().getEnvironment().set("deploymentId", (Object)"testDeploymentId");
        processInstance = this.kruntime.startProcess("MessageEndEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        workItem = (InternalKogitoWorkItem)handler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        nodeInstanceId = workItem.getNodeInstanceStringId();
        nodeId = workItem.getNodeId();
        Assertions.assertNotNull((Object)nodeId);
        Assertions.assertTrue((nodeId > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)nodeInstanceId);
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testOnEntryExitScript() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-OnEntryExitScriptProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testOnEntryExitNamespacedScript() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-OnEntryExitNamespacedScriptProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testOnEntryExitMixedNamespacedScript() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-OnEntryExitMixedNamespacedScriptProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testOnEntryExitScriptDesigner() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-OnEntryExitDesignerScriptProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ArrayList myList = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("OnEntryExitScriptProcess");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)4, (int)myList.size());
    }

    @Test
    public void testTerminateWithinSubprocessEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-SubprocessWithParallelSpitTerminate.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-SubprocessWithParallelSpitTerminate");
        this.kruntime.signalEvent("signal1", null, processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testTerminateEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ParallelSpitTerminate.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ParallelSpitTerminate");
        this.kruntime.signalEvent("Signal 1", null, processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testSignalEndWithData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EndEventSignalWithData.bpmn2");
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("src.simpleEndSignal", params);
        this.assertProcessInstanceCompleted(processInstance);
    }
}

