/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Definitions;
import org.jbpm.bpmn2.core.Interface;
import org.jbpm.bpmn2.core.ItemDefinition;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.DataTypeResolver;
import org.jbpm.process.core.datatype.impl.type.UndefinedDataType;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.ForEachNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DefinitionsHandler
extends BaseAbstractHandler
implements Handler {
    public DefinitionsHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(null);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        return new Definitions();
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Definitions definitions = (Definitions)parser.getCurrent();
        String namespace = element.getAttribute("targetNamespace");
        List processes = ((ProcessBuildData)parser.getData()).getProcesses();
        Map itemDefinitions = (Map)((ProcessBuildData)parser.getData()).getMetaData("ItemDefinitions");
        List interfaces = (List)((ProcessBuildData)parser.getData()).getMetaData("Interfaces");
        for (Process process : processes) {
            RuleFlowProcess ruleFlowProcess = (RuleFlowProcess)process;
            ruleFlowProcess.setMetaData("TargetNamespace", (Object)namespace);
            this.postProcessItemDefinitions((NodeContainer)ruleFlowProcess, itemDefinitions, parser.getClassLoader());
            this.postProcessInterfaces((NodeContainer)ruleFlowProcess, interfaces);
        }
        definitions.setTargetNamespace(namespace);
        return definitions;
    }

    public Class<?> generateNodeFor() {
        return Definitions.class;
    }

    private void postProcessInterfaces(NodeContainer nodeContainer, List<Interface> interfaces) {
        for (Node node : nodeContainer.getNodes()) {
            Interface i;
            if (node instanceof NodeContainer) {
                this.postProcessInterfaces((NodeContainer)node, interfaces);
            }
            if (!(node instanceof WorkItemNode) || !"Service Task".equals(((WorkItemNode)node).getMetaData("Type"))) continue;
            WorkItemNode workItemNode = (WorkItemNode)node;
            if (interfaces == null) {
                throw new ProcessParsingValidationException("No interfaces found");
            }
            String operationRef = (String)workItemNode.getMetaData("OperationRef");
            String implementation = (String)workItemNode.getMetaData("Implementation");
            Interface.Operation operation = null;
            Iterator<Interface> iterator = interfaces.iterator();
            while (iterator.hasNext() && (operation = (i = iterator.next()).getOperation(operationRef)) == null) {
            }
            if (operation == null) {
                throw new ProcessParsingValidationException("Could not find operation " + operationRef);
            }
            if (workItemNode.getWork().getParameter("Interface") == null) {
                workItemNode.getWork().setParameter("Interface", (Object)operation.getInterface().getName());
            }
            if (workItemNode.getWork().getParameter("Operation") == null) {
                workItemNode.getWork().setParameter("Operation", (Object)operation.getName());
            }
            if (workItemNode.getWork().getParameter("ParameterType") == null && operation.getMessage() != null) {
                workItemNode.getWork().setParameter("ParameterType", (Object)operation.getMessage().getType());
            }
            if (implementation == null) continue;
            workItemNode.getWork().setParameter("interfaceImplementationRef", (Object)operation.getInterface().getImplementationRef());
            workItemNode.getWork().setParameter("operationImplementationRef", (Object)operation.getImplementationRef());
            workItemNode.getWork().setParameter("implementation", (Object)implementation);
        }
    }

    private void postProcessItemDefinitions(NodeContainer nodeContainer, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        if (nodeContainer instanceof ContextContainer) {
            this.setVariablesDataType((ContextContainer)nodeContainer, itemDefinitions, cl);
        }
        if (nodeContainer instanceof ForEachNode) {
            this.setVariablesDataType((ContextContainer)((ForEachNode)nodeContainer).getCompositeNode(), itemDefinitions, cl);
        }
        for (Node node : nodeContainer.getNodes()) {
            if (node instanceof NodeContainer) {
                this.postProcessItemDefinitions((NodeContainer)node, itemDefinitions, cl);
            }
            if (!(node instanceof ContextContainer)) continue;
            this.setVariablesDataType((ContextContainer)node, itemDefinitions, cl);
        }
    }

    private void setVariablesDataType(ContextContainer container, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        VariableScope variableScope = (VariableScope)container.getDefaultContext("VariableScope");
        if (variableScope != null) {
            for (Variable variable : variableScope.getVariables()) {
                this.setVariableDataType(variable, itemDefinitions, cl);
            }
        }
    }

    private void setVariableDataType(Variable variable, Map<String, ItemDefinition> itemDefinitions, ClassLoader cl) {
        String itemSubjectRef = (String)variable.getMetaData("ItemSubjectRef");
        if (UndefinedDataType.getInstance().equals(variable.getType()) && itemDefinitions != null && itemSubjectRef != null) {
            DataType dataType = DataTypeResolver.defaultDataType;
            ItemDefinition itemDefinition = itemDefinitions.get(itemSubjectRef);
            if (itemDefinition != null) {
                dataType = DataTypeResolver.fromType((String)itemDefinition.getStructureRef(), (ClassLoader)cl);
            }
            variable.setType(dataType);
        }
    }
}

