/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import org.drools.compiler.compiler.xml.XmlDumper;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.EventNode;
import org.xml.sax.Attributes;

public class EventNodeHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        throw new IllegalArgumentException("Reading in should be handled by intermediate catch event handler");
    }

    public Class generateNodeFor() {
        return EventNode.class;
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        EventNode eventNode = (EventNode)node;
        String attachedTo = (String)eventNode.getMetaData("AttachedTo");
        if (attachedTo == null) {
            this.writeNode("intermediateCatchEvent", (Node)eventNode, xmlDump, metaDataType);
            xmlDump.append(">" + EOL);
            this.writeExtensionElements((Node)eventNode, xmlDump);
            this.writeVariableName(eventNode, xmlDump);
            if (eventNode.getEventFilters().size() > 0) {
                String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
                if (type.startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\"/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\"/>" + EOL);
                }
            }
            this.endNode("intermediateCatchEvent", xmlDump);
        } else {
            String type = ((EventTypeFilter)eventNode.getEventFilters().get(0)).getType();
            if (type.startsWith("Escalation-")) {
                type = type.substring(attachedTo.length() + 12);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                xmlDump.append("      <escalationEventDefinition escalationRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(type) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Error-")) {
                type = type.substring(attachedTo.length() + 7);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                String errorId = this.getErrorIdForErrorCode(type, (Node)eventNode);
                xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorId) + "\" />" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Timer-")) {
                type = type.substring(attachedTo.length() + 7);
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                String duration = (String)eventNode.getMetaData("TimeDuration");
                String cycle = (String)eventNode.getMetaData("TimeCycle");
                if (duration != null && cycle != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                } else if (duration != null) {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)duration) + "</timeDuration>" + EOL + "      </timerEventDefinition>" + EOL);
                } else {
                    xmlDump.append("      <timerEventDefinition>" + EOL + "        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)cycle) + "</timeCycle>" + EOL + "      </timerEventDefinition>" + EOL);
                }
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("SignalName") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (node.getMetaData().get("Condition") != null) {
                boolean cancelActivity = (Boolean)eventNode.getMetaData("CancelActivity");
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                if (!cancelActivity) {
                    xmlDump.append("cancelActivity=\"false\" ");
                }
                xmlDump.append(">" + EOL);
                xmlDump.append("      <conditionalEventDefinition>" + EOL);
                xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + eventNode.getMetaData("Condition") + "</condition>" + EOL);
                xmlDump.append("      </conditionalEventDefinition>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else if (type.startsWith("Message-")) {
                type = type.substring(8);
                this.writeNode("boundaryEvent", (Node)eventNode, xmlDump, metaDataType);
                xmlDump.append("attachedToRef=\"" + attachedTo + "\" ");
                xmlDump.append(">" + EOL);
                xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                this.endNode("boundaryEvent", xmlDump);
            } else {
                throw new ProcessParsingValidationException("Unknown boundary event type: \"" + type + "\"");
            }
        }
    }
}

