/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml.di;

import java.util.HashSet;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.bpmn2.xml.di.BPMNPlaneHandler;
import org.jbpm.bpmn2.xml.di.BPMNShapeHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class BPMNEdgeHandler
extends BaseAbstractHandler
implements Handler {
    public BPMNEdgeHandler() {
        this.initValidParents();
        this.initValidPeers();
        this.allowNesting = false;
    }

    protected void initValidParents() {
        this.validParents = new HashSet();
        this.validParents.add(BPMNPlaneHandler.ProcessInfo.class);
    }

    protected void initValidPeers() {
        this.validPeers = new HashSet();
        this.validPeers.add(null);
        this.validPeers.add(BPMNShapeHandler.NodeInfo.class);
        this.validPeers.add(ConnectionInfo.class);
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        parser.startElementBuilder(localName, attrs);
        String elementRef = attrs.getValue("bpmnElement");
        ConnectionInfo info = new ConnectionInfo(elementRef);
        BPMNPlaneHandler.ProcessInfo processInfo = (BPMNPlaneHandler.ProcessInfo)parser.getParent();
        processInfo.addConnectionInfo(info);
        return info;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        Element element = parser.endElementBuilder();
        Object bendpoints = null;
        Node xmlNode = element.getFirstChild();
        while (xmlNode instanceof Element) {
            String nodeName = xmlNode.getNodeName();
            if ("waypoint".equals(nodeName)) {
                String x = ((Element)xmlNode).getAttribute("x");
                String y = ((Element)xmlNode).getAttribute("y");
                try {
                    int xValue = new Float(x).intValue();
                    int yValue = new Float(y).intValue();
                    if (bendpoints == null) {
                        bendpoints = "[";
                    } else if (xmlNode.getNextSibling() != null) {
                        bendpoints = (String)bendpoints + xValue + "," + yValue;
                        bendpoints = (String)bendpoints + ";";
                    }
                }
                catch (NumberFormatException e) {
                    throw new ProcessParsingValidationException("Invalid bendpoint value");
                }
            }
            xmlNode = xmlNode.getNextSibling();
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)parser.getCurrent();
        if (bendpoints != null && ((String)bendpoints).length() > 1) {
            connectionInfo.setBendpoints((String)bendpoints + "]");
        }
        return connectionInfo;
    }

    public Class<?> generateNodeFor() {
        return ConnectionInfo.class;
    }

    public static class ConnectionInfo {
        private String elementRef;
        private String bendpoints;

        public ConnectionInfo(String elementRef) {
            this.elementRef = elementRef;
        }

        public String getElementRef() {
            return this.elementRef;
        }

        public String getBendpoints() {
            return this.bendpoints;
        }

        public void setBendpoints(String bendpoints) {
            this.bendpoints = bendpoints;
        }
    }
}

