/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class EscalationEventTest
extends JbpmBpmn2TestCase {
    private KogitoProcessEventListener LOGGING_EVENT_LISTENER = new DefaultKogitoProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            EscalationEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            EscalationEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            EscalationEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            EscalationEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @Test
    public void testEventSubprocessEscalation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EventSubprocessEscalation.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessEscalation");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertEquals((int)1, (int)executednodes.size());
    }

    @Test
    public void testEscalationBoundaryEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationBoundaryEventInterrupting() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @Disabled(value="Escalation does not cancel work items yet.")
    public void testEscalationBoundaryEventInterruptsTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEventInterrupting.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertEquals((int)3, (int)handler.getWorkItem().getState(), (String)"WorkItem was not cancelled!");
    }

    @Test
    public void testEscalationIntermediateThrowEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-IntermediateThrowEventEscalation.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationIntermediateThrowEvent");
        this.assertProcessInstanceAborted(processInstance);
    }

    @Test
    @Disabled(value="General escalation is not yet supported.")
    public void testGeneralEscalationBoundaryEventWithTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEventWithTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("non-interrupting-escalation", params);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void testInterruptingEscalationBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEventOnTaskInterrupting.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EscalationBoundaryEventOnTask");
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertEquals((int)2, (int)workItems.size());
        KogitoWorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Disabled(value="Non interrupting escalation has not yet been implemented.")
    public void testNonInterruptingEscalationBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationBoundaryEventOnTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("non-interrupting-escalation");
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertEquals((int)2, (int)workItems.size());
        KogitoWorkItem johnsWork = workItems.get(0);
        KogitoWorkItem marysWork = workItems.get(1);
        if (!"john".equalsIgnoreCase((String)johnsWork.getParameter("ActorId"))) {
            marysWork = johnsWork;
            johnsWork = workItems.get(1);
        }
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(johnsWork.getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(marysWork.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testEscalationEndEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationEndEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EscalationEndEvent");
        this.assertProcessInstanceAborted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testEscalationBoundaryEventAndIntermediate() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationWithDataMapping.bpmn2");
        HashMap<String, RuntimeException> sessionArgs = new HashMap<String, RuntimeException>();
        sessionArgs.put("Property_2", new RuntimeException());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2BoundaryEscalationEventOnTask", sessionArgs);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessVarValue(processInstance, "Property_3", "java.lang.RuntimeException");
    }

    @Test
    public void testHandledEscalationEndEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("escalation/BPMN2-EscalationEndEventHandling.bpmn2");
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("hello", 70);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("helloWorld.Escalation", parameters);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }
}

