/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.ExceptionOnPurposeHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.instance.LightProcessRuntime;
import org.jbpm.process.instance.LightProcessRuntimeServiceProvider;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.ruleflow.core.RuleFlowProcessFactory;
import org.jbpm.ruleflow.core.factory.BoundaryEventNodeFactory;
import org.jbpm.ruleflow.core.factory.CompositeContextNodeFactory;
import org.jbpm.ruleflow.core.factory.EndNodeFactory;
import org.jbpm.ruleflow.core.factory.EventNodeFactory;
import org.jbpm.ruleflow.core.factory.HumanTaskNodeFactory;
import org.jbpm.ruleflow.core.factory.StartNodeFactory;
import org.jbpm.ruleflow.core.factory.WorkItemNodeFactory;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class ProcessFactoryTest
extends JbpmBpmn2TestCase {
    @Test
    public void testProcessFactory() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start")).done()).actionNode(2L).name("Action").action("java", "System.out.println(\"Action\");").done()).endNode(3L).name("End")).done()).connection(1L, 2L)).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        this.kruntime.startProcess("org.jbpm.process");
    }

    @Test
    public void testCompositeNode() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)((EndNodeFactory)((CompositeContextNodeFactory)((CompositeContextNodeFactory)((StartNodeFactory)((CompositeContextNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start")).done()).compositeContextNode(2L).name("SubProcess")).startNode(1L).name("SubProcess Start")).done()).actionNode(2L).name("SubProcess Action").action("java", "System.out.println(\"SubProcess Action\");").done()).endNode(3L).name("SubProcess End")).terminate(true).done()).connection(1L, 2L)).connection(2L, 3L)).done()).endNode(3L).name("End")).done()).connection(1L, 2L)).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"SubProcess", (Object)process.getNode(2L).getName());
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        KogitoProcessInstance pi = this.kruntime.startProcess("org.jbpm.process");
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)pi.getState());
    }

    @Test
    @Timeout(value=10L)
    public void testBoundaryTimerTimeCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        String timeCycle = "1s###5s";
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((HumanTaskNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start")).done()).humanTaskNode(2L).name("Task")).actorId("john").taskName("MyTask").done()).endNode(3L).name("End1")).terminate(false).done()).boundaryEventNode(4L).name("BoundaryTimerEvent")).attachedTo(2L).metaData("TimeCycle", (Object)timeCycle)).metaData("CancelActivity", (Object)false)).eventType("Timer", timeCycle).done()).endNode(5L).name("End2")).terminate(false).done()).connection(1L, 2L)).connection(2L, 3L)).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)testHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance pi = this.kruntime.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getStringId(), "End2");
        this.assertProcessInstanceActive(pi);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(testHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(pi);
    }

    @Test
    @Timeout(value=10L)
    public void testBoundaryTimerTimeDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("BoundaryTimerEvent", 1);
        String timeDuration = "1s";
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((HumanTaskNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("My process").packageName("org.jbpm").startNode(1L).name("Start")).done()).humanTaskNode(2L).name("Task")).actorId("john").taskName("MyTask").done()).endNode(3L).name("End1")).terminate(false).done()).boundaryEventNode(4L).name("BoundaryTimerEvent")).attachedTo(2L).metaData("TimeDuration", (Object)timeDuration)).metaData("CancelActivity", (Object)false)).eventType("Timer", timeDuration).done()).endNode(5L).name("End2")).terminate(false).done()).connection(1L, 2L)).connection(2L, 3L)).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)testHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance pi = this.kruntime.startProcess("org.jbpm.process");
        this.assertProcessInstanceActive(pi);
        countDownListener.waitTillCompleted();
        this.assertNodeTriggered(pi.getStringId(), "End2");
        this.assertProcessInstanceActive(pi);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(testHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(pi);
    }

    @Test
    @Timeout(value=10L)
    public void testAdHocSimple() {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        factory.dynamic(true).name("Event Process").version("1").packageName("org.jbpm");
        RuleFlowProcess process = factory.validate().getProcess();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)process);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)process.isDynamic());
    }

    @Test
    @Timeout(value=10L)
    public void testSignalEvent() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EventNodeFactory)((EventNodeFactory)((EventNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("Event Process").version("1").packageName("org.jbpm").variable("eventData", (DataType)new StringDataType()).startNode(1L).name("Start")).done()).eventNode(2L).name("Event1")).eventType("testEvent")).variableName("eventData")).done()).actionNode(3L).name("simpleActionNode").action("java", "System.out.println(\"test event action\");").done()).endNode(4L).name("End")).done()).connection(1L, 2L)).connection(2L, 3L)).connection(3L, 4L);
        RuleFlowProcess process = factory.validate().getProcess();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        KogitoProcessInstance pi = this.kruntime.startProcess("org.jbpm.process");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pi);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)pi.getState());
        pi.signalEvent("testEvent", null);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)pi.getState());
    }

    @Test
    @Timeout(value=10L)
    public void testActionNodeIsDroolsAction() throws Exception {
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"org.jbpm.process");
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)factory.name("ActionNodeActionProcess").version("1").startNode(1L).name("Start")).done()).endNode(3L).name("End")).done()).actionNode(2L).name("printTextActionNode").action("java", "System.out.println(\"test print\");", true).done()).connection(1L, 2L)).connection(2L, 3L);
        RuleFlowProcess process = factory.validate().getProcess();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)process);
        Resource res = ResourceFactory.newByteArrayResource((byte[])XmlBPMNProcessDumper.INSTANCE.dump((WorkflowProcess)process).getBytes());
        res.setSourcePath("/tmp/processFactory.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(res);
        KogitoProcessInstance pi = this.kruntime.startProcess("org.jbpm.process");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pi);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)pi.getState());
    }

    @Test
    public void testBoundaryErrorEvent() throws Exception {
        String boundaryErrorEvent = "BoundaryErrorEvent";
        String errorCode = "java.lang.RuntimeException";
        String processId = "myProcess";
        RuleFlowProcessFactory factory = RuleFlowProcessFactory.createProcess((String)"myProcess");
        String startNode = "Start";
        String task = "Task";
        String endOnError = "EndOnError";
        ((RuleFlowProcessFactory)((RuleFlowProcessFactory)((RuleFlowProcessFactory)((EndNodeFactory)((EndNodeFactory)((RuleFlowProcessFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((BoundaryEventNodeFactory)((RuleFlowProcessFactory)((EndNodeFactory)((RuleFlowProcessFactory)((WorkItemNodeFactory)((WorkItemNodeFactory)((RuleFlowProcessFactory)((StartNodeFactory)((StartNodeFactory)factory.name("My process").packageName("org.kie.kogito").startNode(1L).name("Start")).metaData("UniqueId", (Object)"Start")).done()).workItemNode(2L).name("Task")).workName("Task")).done()).endNode(3L).name("EndOnSuccess")).done()).boundaryEventNode(4L).name("BoundaryErrorEvent")).attachedTo(2L).metaData("ErrorEvent", (Object)"java.lang.RuntimeException")).metaData("HasErrorEvent", (Object)true)).metaData("ErrorStructureRef", null)).metaData("EventTpe", (Object)"error")).metaData("UniqueId", (Object)"BoundaryErrorEvent")).eventType("Error", "java.lang.RuntimeException").done()).endNode(5L).name("EndOnError")).metaData("UniqueId", (Object)"EndOnError")).terminate(true).done()).connection(1L, 2L)).connection(2L, 3L)).connection(4L, 5L);
        RuleFlowProcess process = factory.validate().getProcess();
        LightProcessRuntime processRuntime = LightProcessRuntime.of(null, Collections.singletonList(process), (ProcessRuntimeServiceProvider)new LightProcessRuntimeServiceProvider());
        processRuntime.getKogitoWorkItemManager().registerWorkItemHandler("Task", (KogitoWorkItemHandler)new ExceptionOnPurposeHandler());
        final ArrayList completedNodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                completedNodes.add(event.getNodeInstance().getNodeName());
                super.afterNodeLeft(event);
            }
        };
        processRuntime.addEventListener((ProcessEventListener)listener);
        ProcessInstance processInstance = processRuntime.startProcess("myProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
        Assertions.assertThat(completedNodes).contains((Object[])new String[]{"Start", "Task", "BoundaryErrorEvent", "EndOnError"});
    }
}

