/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.drools.compiler.rule.builder.PackageBuildContext;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.objects.Account;
import org.jbpm.bpmn2.objects.Address;
import org.jbpm.bpmn2.objects.HelloService;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.test.RequirePersistence;
import org.jbpm.process.builder.ActionBuilder;
import org.jbpm.process.builder.AssignmentBuilder;
import org.jbpm.process.builder.ProcessBuildContext;
import org.jbpm.process.builder.ProcessClassBuilder;
import org.jbpm.process.builder.ReturnValueEvaluatorBuilder;
import org.jbpm.process.builder.dialect.ProcessDialect;
import org.jbpm.process.builder.dialect.ProcessDialectRegistry;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.impl.DataTransformerRegistry;
import org.jbpm.process.core.impl.ProcessImpl;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventListener;
import org.jbpm.process.instance.event.listeners.TriggerRulesEventListener;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.ProcessCompletedCountDownProcessEventListener;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.DataDefinition;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.Assignment;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.jbpm.workflow.instance.node.WorkItemNodeInstance;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.DataTransformer;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;

public class ActivityTest
extends JbpmBpmn2TestCase {
    @Test
    public void testMinimalProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessImplicit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessImplicit.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessWithGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMinimalProcessMetaData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessMetaData.bpmn2");
        final ArrayList list1 = new ArrayList();
        final ArrayList list2 = new ArrayList();
        final ArrayList list3 = new ArrayList();
        final ArrayList list4 = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                String customTag2;
                ActivityTest.this.logger.debug("before node");
                Map metaData = event.getNodeInstance().getNode().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTag");
                if (customTag != null) {
                    list1.add(customTag);
                }
                if ((customTag2 = (String)metaData.get("customTag2")) != null) {
                    list2.add(customTag2);
                }
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug("after variable");
                VariableScope variableScope = (VariableScope)((ProcessImpl)event.getProcessInstance().getProcess()).resolveContext("VariableScope", (Object)event.getVariableId());
                if (variableScope == null) {
                    return;
                }
                Map metaData = variableScope.findVariable(event.getVariableId()).getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTagVar");
                if (customTag != null) {
                    list3.add(customTag);
                }
            }

            public void afterProcessStarted(ProcessStartedEvent event) {
                ActivityTest.this.logger.debug("after process");
                Map metaData = event.getProcessInstance().getProcess().getMetaData();
                for (Map.Entry entry : metaData.entrySet()) {
                    ActivityTest.this.logger.debug((String)entry.getKey() + " " + entry.getValue());
                }
                String customTag = (String)metaData.get("customTagProcess");
                if (customTag != null) {
                    list4.add(customTag);
                }
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "krisv");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)list1.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)list2.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list3.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list4.size());
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testScriptTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ScriptTask.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ScriptTask");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testScriptTaskWithIO() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ScriptTaskWithIO.bpmn2");
        Process scriptProcess = this.kruntime.getKieBase().getProcess("ScriptTask");
        Assertions.assertThat((Object)scriptProcess).isNotNull();
        Object[] nodes = ((NodeContainer)scriptProcess).getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(3);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])nodes).filteredOn(n -> n instanceof ActionNode)).allMatch(n -> ((ActionNode)n).getInAssociations().size() == 1 && ((ActionNode)n).getOutAssociations().size() == 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ScriptTask", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testRuleTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        ArrayList list = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("RuleTask");
        this.kruntime.getKieSession().setGlobal("list", list);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testRuleTask2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTask2.drl");
        ArrayList list = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("RuleTask", params);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)list.isEmpty());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testRuleTaskSetVariableWithReconnect() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTask2.bpmn2", "BPMN2-RuleTaskSetVariableReconnect.drl");
        ArrayList list = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("RuleTask", params);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        this.assertProcessVarValue(processInstance, "x", "AnotherString");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @RequirePersistence(value=false)
    public void testRuleTaskWithFacts() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTaskWithFact.bpmn2", "BPMN2-RuleTask3.drl");
        this.kruntime.getKieSession().addEventListener(new AgendaEventListener(){

            public void matchCreated(MatchCreatedEvent event) {
            }

            public void matchCancelled(MatchCancelledEvent event) {
            }

            public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
            }

            public void beforeMatchFired(BeforeMatchFiredEvent event) {
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event) {
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
            }

            public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
            }

            public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
                ActivityTest.this.kruntime.getKieSession().fireAllRules();
            }

            public void afterMatchFired(AfterMatchFiredEvent event) {
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "SomeString");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        params = new HashMap();
        processInstance = this.kruntime.startProcess("RuleTask", params);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)processInstance.getState());
        params = new HashMap();
        params.put("x", "SomeString");
        processInstance = this.kruntime.startProcess("RuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testRuleTaskAcrossSessions() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        KogitoProcessRuntime kruntime2 = this.createKogitoProcessRuntime("BPMN2-RuleTask.bpmn2", "BPMN2-RuleTask.drl");
        ArrayList list1 = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", list1);
        ArrayList list2 = new ArrayList();
        kruntime2.getKieSession().setGlobal("list", list2);
        KogitoProcessInstance processInstance1 = this.kruntime.startProcess("RuleTask");
        KogitoProcessInstance processInstance2 = kruntime2.startProcess("RuleTask");
        this.assertProcessInstanceFinished(processInstance1, this.kruntime);
        this.assertProcessInstanceFinished(processInstance2, kruntime2);
        kruntime2.getKieSession().dispose();
    }

    @Test
    public void testUserTaskWithDataStoreScenario() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithDataStore.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.startProcess("UserProcess");
    }

    @Test
    public void testUserTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testUserTaskVerifyParameters() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTask.bpmn2");
        this.kruntime.getKieSession().getEnvironment().set("deploymentId", (Object)"test-deployment-id");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        String pId = processInstance.getStringId();
        this.kruntime.getKieSession().execute((Command)(ExecutableCommand & Serializable)context -> {
            KogitoProcessInstance processInstance1 = this.kruntime.getProcessInstance(pId);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)processInstance1);
            KogitoNodeInstance nodeInstance = ((KogitoNodeInstanceContainer)processInstance1).getNodeInstance(((InternalKogitoWorkItem)workItem).getNodeInstanceStringId());
            org.junit.jupiter.api.Assertions.assertNotNull((Object)nodeInstance);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(nodeInstance instanceof WorkItemNodeInstance));
            String deploymentId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getDeploymentId();
            String nodeInstanceId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getNodeInstanceStringId();
            long nodeId = ((WorkItemNodeInstance)nodeInstance).getWorkItem().getNodeId();
            org.junit.jupiter.api.Assertions.assertEquals((Object)((InternalKogitoWorkItem)workItem).getDeploymentId(), (Object)deploymentId);
            org.junit.jupiter.api.Assertions.assertEquals((long)((InternalKogitoWorkItem)workItem).getNodeId(), (long)nodeId);
            org.junit.jupiter.api.Assertions.assertEquals((Object)((InternalKogitoWorkItem)workItem).getNodeInstanceStringId(), (Object)nodeInstanceId);
            return null;
        });
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallActivityWithContantsAssignment() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/SingleTaskWithVarDef.bpmn2", "subprocess/InputMappingUsingValue.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("CustomTask", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("defaultPackage.InputMappingUsingValue", params);
        KogitoWorkItem workItem = handler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        Object value = workItem.getParameter("TaskName");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)value);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"test string", (Object)value);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testSubProcessWithEntryExitScripts() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-SubProcessWithEntryExitScripts.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getStringId(), "Task1");
        String var1 = this.getProcessVarValue(processInstance, "var1");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)var1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"10", (Object)var1.toString());
        this.assertNodeTriggered(processInstance.getStringId(), "Task2");
        String var2 = this.getProcessVarValue(processInstance, "var2");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)var2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"20", (Object)var2.toString());
        this.assertNodeTriggered(processInstance.getStringId(), "Task3");
        String var3 = this.getProcessVarValue(processInstance, "var3");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)var3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"30", (Object)var3.toString());
        this.assertNodeTriggered(processInstance.getStringId(), "SubProcess");
        String var4 = this.getProcessVarValue(processInstance, "var4");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)var4);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"40", (Object)var4.toString());
        String var5 = this.getProcessVarValue(processInstance, "var5");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)var5);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"50", (Object)var5.toString());
        KogitoWorkItem workItem = handler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCallActivity() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)((KogitoWorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    public void testCallActivityMI() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityMI.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        final ArrayList subprocessStarted = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                if (event.getProcessInstance().getProcessId().equals("SubProcess")) {
                    subprocessStarted.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
                }
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        list.add("first");
        list.add("second");
        List listOut = new ArrayList();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", "oldValue");
        params.put("list", list);
        params.put("listOut", listOut);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)subprocessStarted.size());
        listOut = (List)((KogitoWorkflowProcessInstance)processInstance).getVariable("listOut");
        org.junit.jupiter.api.Assertions.assertNotNull(listOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)listOut.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", listOut.get(0));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", listOut.get(1));
    }

    @Test
    public void testCallActivity2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivity2.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceActive(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)((KogitoWorkflowProcessInstance)processInstance).getVariable("y"));
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"krisv", (Object)workItem.getParameter("ActorId"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallActivityByName() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityByName.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2", "BPMN2-CallActivitySubProcessV2.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value V2", (Object)((KogitoWorkflowProcessInstance)processInstance).getVariable("y"));
    }

    @Test
    public void testSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcess.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }

            public void afterVariableChanged(ProcessVariableChangedEvent event) {
                ActivityTest.this.logger.debug(event.toString());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubProcess");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInvalidSubProcess() throws Exception {
        try {
            this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcessInvalid.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSubProcessWrongStartEvent() throws Exception {
        try {
            this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcessWrongStartEvent.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Embedded subprocess can only have none start event."});
        }
    }

    @Test
    public void testSubProcessWrongStartEventTimer() throws Exception {
        try {
            this.kruntime = this.createKogitoProcessRuntime("SubprocessWithTimer.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Embedded subprocess can only have none start event."});
        }
    }

    @Test
    public void testMultiinstanceSubProcessWrongStartEvent() throws Exception {
        try {
            this.kruntime = this.createKogitoProcessRuntime("MultipleSubprocessWithSignalStartEvent.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"MultiInstance subprocess can only have none start event."});
        }
    }

    @Test
    public void testSubProcessWithTerminateEndEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcessWithTerminateEndEvent.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)list.size());
    }

    @Test
    public void testSubProcessWithTerminateEndEventProcessScope() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcessWithTerminateEndEventProcessScope.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                list.add(event.getNodeInstance().getNodeName());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubProcessTerminate");
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)list.size());
    }

    @Test
    public void testAdHocProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-AdHocProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("AdHocProcess");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.kruntime.signalEvent("Task1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("User1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKieSession().insert((Object)new Person());
        this.kruntime.signalEvent("Task3", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testAdHocProcessDynamicTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-AdHocProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("AdHocProcess");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.kruntime.signalEvent("Task1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("OtherTask", (KogitoWorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicWorkItem((ProcessInstance)processInstance, (KieRuntime)this.kruntime.getKieSession(), (String)"OtherTask", new HashMap());
        KogitoWorkItem workItem = workItemHandler2.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("User1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKieSession().insert((Object)new Person());
        this.kruntime.signalEvent("Task3", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testAdHocProcessDynamicSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-AdHocProcess.bpmn2", "BPMN2-MinimalProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("AdHocProcess");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.logger.debug("Triggering node");
        this.kruntime.signalEvent("Task1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        TestWorkItemHandler workItemHandler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("OtherTask", (KogitoWorkItemHandler)workItemHandler2);
        DynamicUtils.addDynamicSubProcess((ProcessInstance)processInstance, (KieRuntime)this.kruntime.getKieSession(), (String)"Minimal", new HashMap());
        this.kruntime.signalEvent("User1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKieSession().insert((Object)new Person());
        this.kruntime.signalEvent("Task3", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithAccessToWorkItemInfo() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                Assertions.assertThat((Object)workItem.getProcessInstance()).isNotNull();
                Assertions.assertThat((Object)workItem.getNodeInstance()).isNotNull();
                super.executeWorkItem(workItem, manager);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithMvelTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcessWithMvelTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "JoHn");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"hello john!", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskWithCustomTransformation() throws Exception {
        DataTransformerRegistry.get().register("http://custom/transformer", new DataTransformer(){

            public Object transform(Object expression, Map<String, Object> parameters) {
                String value = parameters.values().iterator().next().toString();
                String result = null;
                if ("caplitalizeFirst".equals(expression)) {
                    String first = value.substring(0, 1);
                    String main = value.substring(1, value.length());
                    result = first.toUpperCase() + main;
                } else if ("caplitalizeLast".equals(expression)) {
                    String last = value.substring(value.length() - 1);
                    String main = value.substring(0, value.length() - 1);
                    result = main + last.toUpperCase();
                } else {
                    throw new IllegalArgumentException("Unknown expression " + expression);
                }
                return result;
            }

            public Object compile(String expression, Map<String, Object> parameters) {
                return expression;
            }
        });
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcessWithCustomTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john doe");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"John doE", (Object)processInstance.getVariable("s"));
    }

    @Test
    public void testServiceTaskNoInterfaceName() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceTask-web-service.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                org.junit.jupiter.api.Assertions.assertEquals((Object)"SimpleService", (Object)workItem.getParameter("Interface"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)workItem.getParameter("Operation"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"java.lang.String", (Object)workItem.getParameter("ParameterType"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"##WebService", (Object)workItem.getParameter("implementation"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"hello", (Object)workItem.getParameter("operationImplementationRef"));
                org.junit.jupiter.api.Assertions.assertEquals((Object)"SimpleService", (Object)workItem.getParameter("interfaceImplementationRef"));
                super.executeWorkItem(workItem, manager);
            }
        });
        HashMap params = new HashMap();
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("org.jboss.qa.jbpm.CallWS", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
    }

    @Test
    public void testSendTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SendTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("SendTask", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
    }

    @Test
    public void testReceiveTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ReceiveTask.bpmn2");
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ReceiveTask");
        this.assertProcessInstanceActive((KogitoProcessInstance)processInstance);
        receiveTaskHandler.setKnowledgeRuntime(this.kruntime);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
    }

    @Test
    @RequirePersistence(value=false)
    public void testBusinessRuleTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @RequirePersistence(value=true)
    public void testBusinessRuleTaskWithPersistence() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testBusinessRuleTaskDynamic() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskDynamic.bpmn2", "BPMN2-BusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dynamicrule", "MyRuleFlow");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testBusinessRuleTaskWithDataInputsWithPersistence() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskWithDataInputs.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testBusinessRuleTaskWithDataInputs2WithPersistence() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskWithDataInput.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testBusinessRuleTaskWithContionalEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ConditionalEventRuleTask.bpmn2", "BPMN2-ConditionalEventRuleTask.drl");
        ArrayList list = new ArrayList();
        this.kruntime.getKieSession().setGlobal("list", list);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TestFlow");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
    }

    @Test
    public void testScriptTaskWithVariableByName() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("myVar", "test");
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ProcessWithVariableName.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ProcessWithVariableName", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testCallActivityWithBoundaryEvent() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityWithBoundaryEvent.bpmn2", "BPMN2-CallActivitySubProcessWithBoundaryEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "CallActivity", "Boundary event", "Script Task", "end");
        this.assertNodeTriggered(processInstance.getStringId() + "1", "StartProcess2", "User Task");
    }

    @Test
    public void testCallActivityWithSubProcessWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcessWithBoundaryEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        KogitoWorkItem wi = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)wi);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "CallActivity", "EndProcess");
        this.assertNodeTriggered(processInstance.getStringId() + "1", "StartProcess2", "User Task", "EndProcess");
    }

    @Test
    public void testUserTaskWithBooleanOutput() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithBooleanOutput.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean");
        this.assertProcessInstanceActive(processInstance);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("isCheckedCheckbox", "true");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), output, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testUserTaskWithSimData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSimulationMetaData.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallActivityWithBoundaryErrorEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityProcessBoundaryError.bpmn2", "BPMN2-CallActivitySubProcessBoundaryError.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "Call Activity 1", "Boundary event", "Task Parent", "End2");
        this.assertNodeTriggered(processInstance.getStringId() + "1", "StartProcess", "Task 1", "End");
    }

    @Test
    public void testCallActivityWithBoundaryErrorEventWithWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityProcessBoundaryError.bpmn2", "BPMN2-CallActivitySubProcessBoundaryError.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task1", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess");
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "Call Activity 1", "Boundary event", "Task Parent", "End2");
        this.assertNodeTriggered(processInstance.getStringId() + "1", "StartProcess", "Task 1", "End");
    }

    @Test
    @Timeout(value=10L)
    public void testInvalidServiceTask() {
        org.junit.jupiter.api.Assertions.assertThrows(RuntimeException.class, () -> this.createKogitoProcessRuntime("BPMN2-InvalidServiceProcess.bpmn2"));
    }

    @Test
    public void testServiceTaskInterface() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("EAID_DP000000_23D3_4e7e_80FE_6D8C0AF83CAA", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testBusinessRuleTaskWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-RuleTaskWithTransformation.bpmn2", "BPMN2-RuleTaskWithTransformation.drl");
        List data = new ArrayList();
        this.kruntime.getKieSession().setGlobal("data", data);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "JoHn");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-RuleTaskWithTransformation", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        data = (List)this.kruntime.getKieSession().getGlobal("data");
        org.junit.jupiter.api.Assertions.assertNotNull(data);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)data.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"JOHN", data.get(0));
        String nameVar = this.getProcessVarValue(processInstance, "name");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)nameVar);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)nameVar);
    }

    @Test
    @Disabled(value="Transformer has been disabled")
    public void testCallActivityWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityWithTransformation.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        final ArrayList instances = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                instances.add((KogitoProcessInstance)event.getProcessInstance());
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)instances.size());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"oldValue", (Object)((KogitoWorkflowProcessInstance)instances.get(0)).getVariable("x"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"NEW VALUE", (Object)((KogitoWorkflowProcessInstance)instances.get(0)).getVariable("y"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"OLDVALUE", (Object)((KogitoWorkflowProcessInstance)instances.get(1)).getVariable("subX"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)((KogitoWorkflowProcessInstance)instances.get(1)).getVariable("subY"));
    }

    @Test
    public void testServiceTaskWithMvelCollectionTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcessWithMvelCollectionTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john,poul,mary");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
        List result = (List)processInstance.getVariable("list");
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)result.size());
    }

    @Test
    public void testServiceTaskWithMvelJaxbTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcessWithMvelJaxbTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, Person> params = new HashMap<String, Person>();
        Person person = new Person();
        person.setId(123L);
        person.setName("john");
        params.put("s", person);
        HelloService.VALIDATE_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><person><id>123</id><name>john</name></person>";
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceFinished((KogitoProcessInstance)processInstance, this.kruntime);
    }

    @Test
    public void testErrorBetweenProcessesProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/ErrorsBetweenProcess-Process.bpmn2", "subprocess/ErrorsBetweenProcess-SubProcess.bpmn2");
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("tipoEvento", "error");
        variables.put("pasoVariable", 3);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Principal", variables);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessInstanceAborted(processInstance.getStringId() + "1", this.kruntime);
        this.assertProcessVarValue(processInstance, "event", "error desde Subproceso");
    }

    @Test
    public void testProcessCustomDescriptionMetaData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ProcessCustomDescriptionMetaData.bpmn2");
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal", params);
        this.assertProcessInstanceCompleted(processInstance);
        String description = processInstance.getDescription();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"my process with description", (Object)description);
    }

    @Test
    public void testProcessVariableCustomDescriptionMetaData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ProcessVariableCustomDescriptionMetaData.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "variable name for process");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal", params);
        this.assertProcessInstanceCompleted(processInstance);
        String description = processInstance.getDescription();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)description);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"variable name for process", (Object)description);
    }

    @Test
    public void testInvalidSubProcessNoOutgoingSF() throws Exception {
        try {
            this.createKogitoProcessRuntime("subprocess/BPMN2-InvalidEmdeddedSubProcess.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testAdHocSubProcessEmptyCompleteExpression() throws Exception {
        try {
            this.createKogitoProcessRuntime("BPMN2-AdHocSubProcessEmptyCompleteExpression.bpmn2");
            Assertions.fail((String)"Process should be invalid, there should be build errors");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testSubProcessWithTypeVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-SubProcessWithTypeVariable.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Read Map")) {
                    list.add(event.getNodeInstance().getNodeName());
                }
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("sub_variable.sub_variables");
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)list.size());
    }

    @Test
    public void testUserTaskParametrizedInput() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithParametrizedInput.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("Executing task of process instance " + processInstance.getStringId() + " as work item with Hello"), (Object)workItem.getParameter("Description").toString().trim());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testMultipleBusinessRuleTaskWithDataInputsWithPersistence() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleRuleTasksWithDataInput.bpmn2", "BPMN2-MultipleRuleTasks.drl");
        this.kruntime.getKieSession().addEventListener((AgendaEventListener)new TriggerRulesEventListener(this.kruntime));
        ArrayList listPerson = new ArrayList();
        ArrayList listAddress = new ArrayList();
        this.kruntime.getKieSession().setGlobal("listPerson", listPerson);
        this.kruntime.getKieSession().setGlobal("listAddress", listAddress);
        Person person = new Person();
        person.setName("john");
        Address address = new Address();
        address.setStreet("5th avenue");
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put("person", person);
        params.put("address", address);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("multiple-rule-tasks", params);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listPerson.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)listAddress.size());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSubProcessInAdHocProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcessInAdHocProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap parameters = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubProcessInAdHocProcess", parameters);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallActivityWithDataAssignment() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/AssignmentProcess.bpmn2", "subprocess/AssignmentSubProcess.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("assignmentProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Hello Genworth welcome to jBPMS!", (Object)((KogitoWorkflowProcessInstance)processInstance).getVariable("message"));
    }

    @Test
    public void testDMNBusinessRuleTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("dmn/BPMN2-BusinessRuleTaskDMN.bpmn2", "dmn/0020-vacation-days.dmn");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        params.put("yearsOfService", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        BigDecimal vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(27L), (Object)vacationDays);
        params = new HashMap();
        params.put("age", 44);
        params.put("yearsOfService", 20);
        processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(24L), (Object)vacationDays);
        params = new HashMap();
        params.put("age", 50);
        params.put("yearsOfService", 30);
        processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(30L), (Object)vacationDays);
    }

    @Disabled
    @Test
    public void testDMNBusinessRuleTaskByDecisionName() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("dmn/BPMN2-BusinessRuleTaskDMNByDecisionName.bpmn2", "dmn/0020-vacation-days.dmn");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        params.put("yearsOfService", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        BigDecimal vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(5L), (Object)vacationDays);
    }

    @Disabled
    @Test
    public void testDMNBusinessRuleTaskMultipleDecisionsOutput() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("dmn/BPMN2-BusinessRuleTaskDMNMultipleDecisionsOutput.bpmn2", "dmn/0020-vacation-days.dmn");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        params.put("yearsOfService", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        BigDecimal vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(27L), (Object)vacationDays);
        BigDecimal extraDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("extraDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(5L), (Object)extraDays);
    }

    @Disabled
    @Test
    public void testDMNBusinessRuleTaskInvalidExecution() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("dmn/BPMN2-BusinessRuleTaskDMNByDecisionName.bpmn2", "dmn/0020-vacation-days.dmn");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        try {
            this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        }
        catch (Exception e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e instanceof WorkflowRuntimeException));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(e.getCause() instanceof RuntimeException));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getCause().getMessage().contains("DMN result errors"));
        }
    }

    @Disabled
    @Test
    public void testDMNBusinessRuleTaskModelById() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("dmn/BPMN2-BusinessRuleTaskDMNModelById.bpmn2", "dmn/0020-vacation-days.dmn");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("age", 16);
        params.put("yearsOfService", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        BigDecimal vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(27L), (Object)vacationDays);
        params = new HashMap();
        params.put("age", 44);
        params.put("yearsOfService", 20);
        processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(24L), (Object)vacationDays);
        params = new HashMap();
        params.put("age", 50);
        params.put("yearsOfService", 30);
        processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        vacationDays = (BigDecimal)((KogitoWorkflowProcessInstance)processInstance).getVariable("vacationDays");
        org.junit.jupiter.api.Assertions.assertEquals((Object)BigDecimal.valueOf(30L), (Object)vacationDays);
    }

    @Test
    public void testBusinessRuleTaskFireLimit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskLoop.bpmn2", "BPMN2-BusinessRuleTaskInfiniteLoop.drl");
        this.kruntime.getKieSession().insert((Object)new Person());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)processInstance.getState());
        Assertions.assertThat((String)((WorkflowProcessInstanceImpl)processInstance).getErrorMessage()).contains(new CharSequence[]{"Fire rule limit reached 10000"});
    }

    @Test
    public void testBusinessRuleTaskFireLimitAsParameter() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskWithDataInputLoop.bpmn2", "BPMN2-BusinessRuleTaskInfiniteLoop.drl");
        this.kruntime.getKieSession().insert((Object)new Person());
        Map<String, Integer> parameters = Collections.singletonMap("limit", 5);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", parameters);
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)processInstance.getState());
        Assertions.assertThat((String)((WorkflowProcessInstanceImpl)processInstance).getErrorMessage()).contains(new CharSequence[]{"Fire rule limit reached 5"});
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testScriptTaskFEEL() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ScriptTaskFEEL.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("name", "krisv");
        Person person = new Person();
        person.setName("krisv");
        params.put("person", person);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ScriptTask", params);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Entry", (Object)((WorkflowProcessInstance)processInstance).getVariable("x"));
        org.junit.jupiter.api.Assertions.assertNull((Object)((WorkflowProcessInstance)processInstance).getVariable("y"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Exit", (Object)this.getProcessVarValue(processInstance, "y"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"tester", (Object)((WorkflowProcessInstance)processInstance).getVariable("surname"));
        this.assertNodeTriggered(processInstance.getStringId(), "Script1");
    }

    @Test
    public void testGatewayFEEL() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-GatewayFEEL.bpmn2");
        HashMap<String, Boolean> params1 = new HashMap<String, Boolean>();
        params1.put("VA", Boolean.TRUE);
        params1.put("VB", Boolean.FALSE);
        WorkflowProcessInstance procInstance1 = (WorkflowProcessInstance)this.kruntime.startProcess("BPMN2-GatewayFEEL", params1);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ok", (Object)procInstance1.getVariable("Task1"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ok", (Object)procInstance1.getVariable("Task2"));
        org.junit.jupiter.api.Assertions.assertNull((Object)procInstance1.getVariable("Task3"));
        this.assertNodeTriggered(procInstance1.getStringId(), "Task2", "VA and not(VB)");
        HashMap<String, Boolean> params2 = new HashMap<String, Boolean>();
        params2.put("VA", Boolean.FALSE);
        params2.put("VB", Boolean.TRUE);
        WorkflowProcessInstance procInstance2 = (WorkflowProcessInstance)this.kruntime.startProcess("BPMN2-GatewayFEEL", params2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ok", (Object)procInstance2.getVariable("Task1"));
        org.junit.jupiter.api.Assertions.assertNull((Object)procInstance2.getVariable("Task2"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"ok", (Object)procInstance2.getVariable("Task3"));
        this.assertNodeTriggered(procInstance2.getStringId(), "Task3", "VB or not(VA)");
    }

    @Test
    public void testGatewayFEELWrong() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-GatewayFEEL-wrong.bpmn2");
        HashMap<String, Boolean> params1 = new HashMap<String, Boolean>();
        params1.put("VA", Boolean.TRUE);
        params1.put("VB", Boolean.FALSE);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-GatewayFEEL", params1);
        Assertions.assertThat((String)((WorkflowProcessInstanceImpl)processInstance).getErrorMessage()).contains(new CharSequence[]{"offending symbol: 'Not'"});
    }

    @Test
    public void testBusinessRuleTaskException() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTask.bpmn2", "BPMN2-BusinessRuleTaskWithException.drl");
        this.kruntime.getKieSession().insert((Object)new Person());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)processInstance.getState());
        Assertions.assertThat((String)((WorkflowProcessInstanceImpl)processInstance).getErrorMessage()).contains(new CharSequence[]{"On purpose"});
    }

    @Test
    public void testXORWithSameTargetProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("build/XORSameTarget.bpmn2");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("choice", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("XORTest.XOR2", params);
        this.assertProcessInstanceCompleted(processInstance);
        params = new HashMap();
        params.put("choice", 2);
        processInstance = this.kruntime.startProcess("XORTest.XOR2", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testUserTaskWithExpressionsForIO() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithIOexpression.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Person> parameters = new HashMap<String, Person>();
        parameters.put("person", new Person("john"));
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask", parameters);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("personName"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), Collections.singletonMap("personAge", 50), new Policy[0]);
        Person person = (Person)processInstance.getVariables().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((int)50, (Integer)person.getAge());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallActivitykWithExpressionsForIO() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivityWithIOexpression.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person("john"));
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        this.assertProcessInstanceActive(processInstance);
        Person person = (Person)processInstance.getVariables().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"new value", (Object)person.getName());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"krisv", (Object)workItem.getParameter("ActorId"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testCallSubprocessWithGroup() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-MainGroupAssignment.bpmn2", "subprocess/BPMN2-SubprocessGroupAssignment.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Main");
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = workItemHandler.getWorkItems();
        for (KogitoWorkItem item : workItems) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)item);
            org.junit.jupiter.api.Assertions.assertEquals((Object)"GRUPA TESTOWA", (Object)item.getParameter("GroupId"));
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(item.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @RequirePersistence(value=false)
    public void testBusinessRuleTaskWithExpressionsForIO() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BusinessRuleTaskWithDataInputIOExpression.bpmn2", "BPMN2-BusinessRuleTaskWithDataInput.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("person", new Person(null));
        params.put("account", new Account());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-BusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        Person person = (Person)processInstance.getVariables().get("person");
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)person.getName());
        Account account = (Account)processInstance.getVariables().get("account");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)account.getPerson());
    }

    @Test
    public void testUserTaskWithAssignment() throws Exception {
        ProcessDialectRegistry.setDialect((String)"custom", (ProcessDialect)new ProcessDialect(){

            public ReturnValueEvaluatorBuilder getReturnValueEvaluatorBuilder() {
                return null;
            }

            public ProcessClassBuilder getProcessClassBuilder() {
                return null;
            }

            public AssignmentBuilder getAssignmentBuilder() {
                return new AssignmentBuilder(){

                    public void build(PackageBuildContext context, Assignment assignment, List<DataDefinition> sourceExpr, DataDefinition targetExpr) {
                        org.junit.jupiter.api.Assertions.assertEquals((Object)"from_expression", (Object)assignment.getFrom().getExpression());
                        org.junit.jupiter.api.Assertions.assertEquals((Object)"to_expression", (Object)assignment.getTo().getExpression());
                    }
                };
            }

            public ActionBuilder getActionBuilder() {
                return null;
            }

            public void addProcess(ProcessBuildContext context) {
            }
        });
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-DataOutputAssignmentCustomExpressionLang.bpmn2");
        Process scriptProcess = this.kruntime.getKieBase().getProcess("process");
        Assertions.assertThat((Object)scriptProcess).isNotNull();
        Object[] nodes = ((NodeContainer)scriptProcess).getNodes();
        Assertions.assertThat((Object[])nodes).hasSize(3);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])nodes).filteredOn(n -> n instanceof WorkItemNode)).allMatch(this::matchExpectedAssociationSetup);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "John");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("process", params);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
        this.assertProcessInstanceAborted(processInstance);
    }

    protected boolean matchExpectedAssociationSetup(Node node) {
        List inputs = ((WorkItemNode)node).getInAssociations();
        List outputs = ((WorkItemNode)node).getOutAssociations();
        Assertions.assertThat((List)inputs).hasSize(1);
        Assertions.assertThat((List)outputs).hasSize(1);
        DataAssociation association = (DataAssociation)inputs.get(0);
        Assertions.assertThat((List)association.getAssignments()).hasSize(1);
        Assertions.assertThat((List)association.getSources()).hasSize(2);
        Assignment assignment = (Assignment)association.getAssignments().get(0);
        Assertions.assertThat((String)assignment.getDialect()).isEqualTo("custom");
        Assertions.assertThat((String)assignment.getFrom().getExpression()).isEqualTo("from_expression");
        Assertions.assertThat((String)assignment.getTo().getExpression()).isEqualTo("to_expression");
        association = (DataAssociation)outputs.get(0);
        Assertions.assertThat((List)association.getAssignments()).hasSize(1);
        Assertions.assertThat((List)association.getSources()).hasSize(2);
        assignment = (Assignment)association.getAssignments().get(0);
        Assertions.assertThat((String)assignment.getDialect()).isEqualTo("custom");
        Assertions.assertThat((String)assignment.getFrom().getExpression()).isEqualTo("from_expression");
        Assertions.assertThat((String)assignment.getTo().getExpression()).isEqualTo("to_expression");
        return true;
    }
}

