/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.KogitoSetProcessInstanceVariablesCommand;
import org.jbpm.bpmn2.StandaloneBPMNProcessTest;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.bpmn2.test.RequirePersistence;
import org.jbpm.process.core.datatype.impl.type.StringDataType;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventListener;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.ProcessCompletedCountDownProcessEventListener;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.NamedDataType;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.InternalKogitoWorkItem;

public class IntermediateEventTest
extends JbpmBpmn2TestCase {
    private KogitoProcessEventListener LOGGING_EVENT_LISTENER = new DefaultKogitoProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            IntermediateEventTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            IntermediateEventTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            IntermediateEventTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            IntermediateEventTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @Test
    public void testSignalBoundaryEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"MySignal"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"signal")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("AttachedToID") && m.containsKey("AttachedToName"));
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, this.kruntime);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalBoundaryNonEffectiveEvent() throws Exception {
        String signal = "signalTest";
        final AtomicBoolean eventAfterNodeLeftTriggered = new AtomicBoolean(false);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryEventWithNonEffectiveSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if ("signalTest".equals(event.getNodeInstance().getNodeName())) {
                    eventAfterNodeLeftTriggered.set(true);
                }
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundaryEventWithNonEffectiveSignal");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("signalTest", (Object)"signalTest");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        Assertions.assertThat((boolean)eventAfterNodeLeftTriggered.get()).isTrue();
    }

    @Test
    public void testSignalBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"MySignal", "workItemCompleted"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "workItem"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("nodeId").contains(new Object[]{"BoundaryEvent_2", "UserTask_1"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"signal")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("AttachedToID") && m.containsKey("AttachedToName"));
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"signal")).hasSize(1)).extracting("nodeInstanceId").containsOnlyNulls();
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"workItem")).hasSize(1)).extracting("nodeInstanceId").doesNotContainNull();
        this.kruntime.signalEvent("MySignal", (Object)"value");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalBoundaryEventOnTaskWithSignalName() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalWithNameEventOnTaskbpmn2.bpmn");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        this.kruntime.signalEvent("MySignal", (Object)"value");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalBoundaryEventOnTaskComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("MySignal", (Object)"value");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalBoundaryEventInterrupting() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalBoundaryEventInterrupting.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SignalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"MyMessage", "workItemCompleted"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "workItem"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"signal")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("AttachedToID") && m.containsKey("AttachedToName"));
        this.kruntime.signalEvent("MyMessage", null);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventSignal.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SignalIntermediateEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testSignalBetweenProcesses() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchSignalSingle.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-IntermediateCatchSignalSingle");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance2, this.kruntime);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"Yes", "No"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal"});
        ((AbstractListAssert)Assertions.assertThat((Collection)eventDescriptions).extracting("dataType").hasOnlyElementsOfType(NamedDataType.class)).extracting("dataType").hasOnlyElementsOfType(StringDataType.class);
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        Assertions.assertThat((Collection)eventDescriptions).extracting("nodeInstanceId").doesNotContainNull();
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
    }

    @Test
    @Timeout(value=10L)
    public void testEventBasedSplit2() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener(2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit2.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"Yes", "timerTriggered"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "timer"});
        ((AbstractListAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn(i -> i.getDataType() != null)).extracting("dataType").hasOnlyElementsOfType(NamedDataType.class)).extracting("dataType").hasOnlyElementsOfType(StringDataType.class);
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"timer")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("TimerID") && m.containsKey("Delay"));
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventBasedSplit3() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit3.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"Yes"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "conditional"});
        ((AbstractListAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn(i -> i.getDataType() != null)).extracting("dataType").hasOnlyElementsOfType(NamedDataType.class)).extracting("dataType").hasOnlyElementsOfType(StringDataType.class);
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKieSession().insert((Object)jack);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit4.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"Message-YesMessage", "Message-NoMessage"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"message", "message"});
        ((AbstractListAssert)Assertions.assertThat((Collection)eventDescriptions).extracting("dataType").hasOnlyElementsOfType(NamedDataType.class)).extracting("dataType").hasOnlyElementsOfType(StringDataType.class);
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.kruntime.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit5.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        processInstance = this.kruntime.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testEventBasedSplitWithSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveEventBasedGatewayInSubprocess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.testEBGInSubprocess");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("StopSignal", (Object)"", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.bpmn.testEBGInSubprocess");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("ContinueSignal", (Object)"", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("StopSignal", (Object)"", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventSubprocessSignal() throws Exception {
        String[] nodes = new String[]{"start", "User Task 1", "end", "Sub Process 1", "start-sub", "sub-script", "end-sub"};
        this.runTestEventSubprocessSignal("BPMN2-EventSubprocessSignal.bpmn2", nodes);
    }

    @Test
    public void testEventSubprocessSignalNested() throws Exception {
        String[] nodes = new String[]{"Start", "Sub Process", "Sub Start", "Sub Sub Process", "Sub Sub Start", "Sub Sub User Task", "Sub Sub Sub Process", "start-sub", "sub-script", "end-sub", "Sub Sub End", "Sub End", "End"};
        this.runTestEventSubprocessSignal("BPMN2-EventSubprocessSignal-Nested.bpmn2", nodes);
    }

    public void runTestEventSubprocessSignal(String processFile, String[] completedNodes) throws Exception {
        this.kruntime = this.createKogitoProcessRuntime(processFile);
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("sub-script")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"MySignal", "workItemCompleted"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "workItem"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        this.kruntime.signalEvent("MySignal", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), completedNodes);
        Assertions.assertThat((int)executednodes.size()).isEqualTo(4);
    }

    @Test
    public void testEventSubprocessSignalWithStateNode() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessSignalWithStateNode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("User Task 2")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoWorkItem workItemTopProcess = workItemHandler.getWorkItem();
        this.kruntime.signalEvent("MySignal", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("MySignal", null);
        this.assertProcessInstanceActive(processInstance);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertThat((Object)workItemTopProcess).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemTopProcess.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "User Task 2", "end-sub");
        Assertions.assertThat((int)executednodes.size()).isEqualTo(4);
    }

    @Test
    public void testEventSubprocessSignalInterrupting() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessSignalInterrupting.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.signalEvent("MySignal", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertThat((int)executednodes.size()).isEqualTo(1);
    }

    @Test
    public void testEventSubprocessMessage() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessMessage.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessMessage");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"Message-HelloMessage", "workItemCompleted"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"signal", "workItem"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.signalEvent("Message-HelloMessage", null, processInstance.getStringId());
        this.kruntime.signalEvent("Message-HelloMessage", null);
        this.kruntime.signalEvent("Message-HelloMessage", null);
        this.kruntime.signalEvent("Message-HelloMessage", null);
        this.kruntime.getProcessInstance(processInstance.getStringId());
        this.kruntime.getProcessInstance(processInstance.getStringId());
        this.kruntime.getProcessInstance(processInstance.getStringId());
        this.kruntime.getProcessInstance(processInstance.getStringId());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertThat((int)executednodes.size()).isEqualTo(4);
    }

    @Test
    @Timeout(value=10L)
    public void testEventSubprocessTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Script Task 1", 1);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessTimer.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"workItemCompleted", "timerTriggered"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem", "timer"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"timer")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("TimerID") && m.containsKey("Delay"));
        countDownListener.waitTillCompleted();
        eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(1)).extracting("event").contains(new Object[]{"workItemCompleted"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
    }

    @Test
    @Timeout(value=10L)
    @RequirePersistence
    public void testEventSubprocessTimerCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Script Task 1", 4);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessTimerCycle.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessTimer");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"workItemCompleted", "timerTriggered"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem", "timer"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"timer")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("TimerID") && m.containsKey("Period"));
        countDownListener.waitTillCompleted();
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "start-sub", "Script Task 1", "end-sub");
    }

    @Test
    public void testEventSubprocessConditional() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessConditional.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessConditional");
        this.assertProcessInstanceActive(processInstance);
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertThat((int)executednodes.size()).isEqualTo(1);
    }

    @Test
    @Timeout(value=10L)
    public void testEventSubprocessMessageWithLocalVars() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-EventSubProcessWithLocalVariables.bpmn2");
        final HashSet variablevalues = new HashSet();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                Map variable = (Map)event.getNodeInstance().getVariable("richiesta");
                if (variable != null) {
                    variablevalues.addAll(variable.keySet());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EventSPWithVars");
        this.assertProcessInstanceActive(processInstance);
        HashMap data = new HashMap();
        this.kruntime.signalEvent("Message-MAIL", data, processInstance.getStringId());
        countDownListener.waitTillCompleted();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((Object)processInstance).isNull();
        Assertions.assertThat((int)variablevalues.size()).isEqualTo(2);
        Assertions.assertThat((boolean)variablevalues.contains("SCRIPT1")).isTrue();
        Assertions.assertThat((boolean)variablevalues.contains("SCRIPT2")).isTrue();
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMessageIntermediateThrowVerifyWorkItemData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventMessage.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((boolean)(workItem instanceof KogitoWorkItem)).isTrue();
        String nodeInstanceId = ((InternalKogitoWorkItem)workItem).getNodeInstanceStringId();
        long nodeId = ((InternalKogitoWorkItem)workItem).getNodeId();
        Assertions.assertThat((long)nodeId).isNotNull();
        Assertions.assertThat((nodeId > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)nodeInstanceId).isNotNull();
    }

    @Test
    public void testMessageIntermediateThrowVerifyWorkItemDataDeploymentId() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventMessage.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((boolean)(workItem instanceof KogitoWorkItem)).isTrue();
        String nodeInstanceId = ((InternalKogitoWorkItem)workItem).getNodeInstanceStringId();
        long nodeId = ((InternalKogitoWorkItem)workItem).getNodeId();
        String deploymentId = ((InternalKogitoWorkItem)workItem).getDeploymentId();
        Assertions.assertThat((long)nodeId).isNotNull();
        Assertions.assertThat((nodeId > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)nodeInstanceId).isNotNull();
        Assertions.assertThat((String)deploymentId).isNull();
    }

    @Test
    public void testMessageBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundaryMessageOnTask");
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"message data");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testMessageBoundaryEventOnTaskComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryMessageEventOnTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundaryMessageOnTask");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"message data");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventDuration() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventDuration.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(2)).extracting("event").contains(new Object[]{"workItemCompleted", "timerTriggered"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem", "timer"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"timer")).hasSize(1)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("TimerID") && m.containsKey("Period"));
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventDurationISO() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventDurationISO.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventDateISO() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventDateISO.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        params.put("date", plusTwoSeconds.toString());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventCycle1() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventCycle1.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventCycle2() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 3);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventCycle2.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
    }

    @Test
    @Timeout(value=10L)
    @RequirePersistence(value=false)
    public void testTimerBoundaryEventCycleISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventCycleISO.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventInterrupting() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.logger.debug("Firing timer");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventInterruptingOnTask() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventInterruptingOnTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.logger.debug("Firing timer");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testTimerBoundaryEventInterruptingOnTaskCancelTimer() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventInterruptingOnTaskCancelTimer.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoWorkItem workItem = handler.getWorkItem();
        if (workItem != null) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventMessage.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventMessageWithRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventMessageWithRef.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerDuration() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerDateISO() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerDateISO.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        HashMap<String, String> params = new HashMap<String, String>();
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        params.put("date", plusTwoSeconds.toString());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerDurationISO() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerDurationISO.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerCycle1() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerCycle1.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerCycleISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 5);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerCycleISO.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimerCycle2() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerCycle2.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
    }

    @Test
    public void testIntermediateCatchEventCondition() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventCondition.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        Person person = new Person();
        person.setName("Jack");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventConditionFilterByProcessInstance() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventConditionFilterByProcessInstance.bpmn2");
        HashMap<String, Long> params1 = new HashMap<String, Long>();
        params1.put("personId", 1L);
        Person person1 = new Person();
        person1.setId(1L);
        KogitoProcessInstance pi1 = this.kruntime.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params1);
        String pi1id = pi1.getStringId();
        this.kruntime.getKieSession().insert((Object)pi1);
        FactHandle personHandle1 = this.kruntime.getKieSession().insert((Object)person1);
        this.kruntime.startProcessInstance(pi1.getStringId());
        HashMap<String, Long> params2 = new HashMap<String, Long>();
        params2.put("personId", 2L);
        Person person2 = new Person();
        person2.setId(2L);
        KogitoProcessInstance pi2 = this.kruntime.createProcessInstance("IntermediateCatchEventConditionFilterByProcessInstance", params2);
        String pi2id = pi2.getStringId();
        this.kruntime.getKieSession().insert((Object)pi2);
        FactHandle personHandle2 = this.kruntime.getKieSession().insert((Object)person2);
        this.kruntime.startProcessInstance(pi2.getStringId());
        person1.setName("John");
        this.kruntime.getKieSession().update(personHandle1, (Object)person1);
        Assertions.assertThat((Object)this.kruntime.getProcessInstance(pi1id)).isNull();
        Assertions.assertThat((Object)this.kruntime.getProcessInstance(pi2id)).isNotNull();
    }

    @Test
    @Timeout(value=10L)
    @RequirePersistence(value=false)
    public void testIntermediateCatchEventTimerCycleWithError() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent", params);
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Integer xValue = (Integer)((KogitoWorkflowProcessInstance)processInstance).getVariable("x");
        Assertions.assertThat((Integer)xValue).isEqualTo(3);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    @RequirePersistence
    public void testIntermediateCatchEventTimerCycleWithErrorWithPersistence() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerCycleWithError.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        String piId = processInstance.getStringId();
        this.kruntime.getKieSession().execute((Command)(ExecutableCommand & Serializable)context -> {
            KogitoWorkflowProcessInstance processInstance1 = (KogitoWorkflowProcessInstance)this.kruntime.getProcessInstance(piId);
            processInstance1.setVariable("x", (Object)0);
            return null;
        });
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        Integer xValue = (Integer)this.kruntime.getKieSession().execute((Command)(ExecutableCommand & Serializable)context -> {
            KogitoWorkflowProcessInstance processInstance2 = (KogitoWorkflowProcessInstance)this.kruntime.getProcessInstance(piId);
            return (Integer)processInstance2.getVariable("x");
        });
        Assertions.assertThat((Integer)xValue).isEqualTo(2);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventNone.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("NoneIntermediateEvent");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkIntermediateEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateLinkEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("linkEventProcessExample");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testLinkEventCompositeProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-LinkEventCompositeProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Composite");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testConditionalBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "User Task", "User Task2", "End1");
    }

    @Test
    public void testConditionalBoundaryEventOnTaskActiveOnStartup() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryConditionalEventOnTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "User Task", "Boundary event", "Condition met", "End2");
    }

    @Test
    public void testConditionalBoundaryEventInterrupting() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ConditionalBoundaryEventInterrupting.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ConditionalBoundaryEvent");
        this.assertProcessInstanceActive(processInstance);
        Person person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "Hello", "StartSubProcess", "Task", "BoundaryEvent", "Goodbye", "EndProcess");
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.kruntime);
    }

    @Test
    public void testSignalBoundaryEventOnSubprocessTakingDifferentPaths() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalBoundaryOnSubProcess.bpmn");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("jbpm.testing.signal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("continue", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstance = this.kruntime.startProcess("jbpm.testing.signal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("forward", null);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventSameSignalOnTwokruntimes() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        KogitoProcessRuntime kruntime2 = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignal2.bpmn2");
        kruntime2.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance2 = kruntime2.startProcess("IntermediateCatchEvent2");
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.kruntime.signalEvent("MyMessage", (Object)"SomeValue");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertProcessInstanceActive(processInstance2);
        kruntime2.signalEvent("MyMessage", (Object)"SomeValue");
        this.assertProcessInstanceFinished(processInstance2, kruntime2);
        kruntime2.getKieSession().dispose();
    }

    @Test
    public void testIntermediateCatchEventNoIncommingConnection() throws Exception {
        try {
            this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventNoIncommingConnection.bpmn2");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isNotNull();
            Assertions.assertThat((boolean)e.getMessage().contains("has no incoming connection")).isTrue();
        }
    }

    @Test
    public void testSignalBoundaryEventOnMultiInstanceSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-MultiInstanceSubprocessWithBoundarySignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).isNotNull();
        Assertions.assertThat((int)workItems.size()).isEqualTo(2);
        this.kruntime.signalEvent("Outside", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalBoundaryEventNoInteruptOnMultiInstanceSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-MultiInstanceSubprocessWithBoundarySignalNoInterupting.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).isNotNull();
        Assertions.assertThat((int)workItems.size()).isEqualTo(2);
        this.kruntime.signalEvent("Outside", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        for (KogitoWorkItem wi : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testErrorBoundaryEventOnMultiInstanceSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/BPMN2-MultiInstanceSubprocessWithBoundaryError.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> approvers = new ArrayList<String>();
        approvers.add("john");
        approvers.add("john");
        params.put("approvers", approvers);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("boundary-catch-error-event", params);
        this.assertProcessInstanceActive(processInstance);
        Set eventDescriptions = processInstance.getEventDescriptions();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).hasSize(3)).extracting("event").contains(new Object[]{"workItemCompleted", "Inside", "Error-_D83CFC28-3322-4ABC-A12D-83476B08C7E8-MyError"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("eventType").contains(new Object[]{"workItem", "signal"});
        Assertions.assertThat((Collection)eventDescriptions).extracting("processInstanceId").contains(new Object[]{processInstance.getStringId()});
        ((AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)eventDescriptions).filteredOn("eventType", (Object)"signal")).hasSize(2)).extracting("properties", Map.class).anyMatch(m -> m.containsKey("AttachedToID") && m.containsKey("AttachedToName"));
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).isNotNull();
        Assertions.assertThat((int)workItems.size()).isEqualTo(2);
        this.kruntime.signalEvent("Inside", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventSignalAndBoundarySignalEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryEventWithSignals.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("boundaryeventtest");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.signalEvent("moveon", (Object)"", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance);
        KogitoWorkItem wi = handler.getWorkItem();
        Assertions.assertThat((Object)wi).isNotNull();
        this.kruntime.signalEvent("moveon", (Object)"", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testSignalIntermediateThrowEventWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalEventOnTaskbpmn2.bpmn", "BPMN2-IntermediateThrowEventSignalWithTransformation.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "john");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("SignalIntermediateEvent", params);
        this.assertProcessInstanceFinished(processInstance2, this.kruntime);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        String var = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)var).isEqualTo("JOHN");
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testSignalBoundaryEventWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundarySignalEventOnTaskWithTransformation.bpmn", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "john");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundarySignalOnTask");
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("SignalIntermediateEvent", params);
        this.assertProcessInstanceFinished(processInstance2, this.kruntime);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        String var = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)var).isEqualTo("JOHN");
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testMessageIntermediateThrowWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventMessageWithTransformation.bpmn2");
        final StringBuffer messageContent = new StringBuffer();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                messageContent.append(workItem.getParameter("Message"));
                super.executeWorkItem(workItem, manager);
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageIntermediateEvent", params);
        this.assertProcessInstanceCompleted(processInstance);
        Assertions.assertThat((String)messageContent.toString()).isEqualTo("MYVALUE");
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testIntermediateCatchEventSignalWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "UserTask", "EndProcess", "event");
        String var = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)var).isNotNull();
        Assertions.assertThat((String)var).isEqualTo("SOMEVALUE");
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testIntermediateCatchEventMessageWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventMessageWithTransformation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        String var = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)var).isNotNull();
        Assertions.assertThat((String)var).isEqualTo("SOMEVALUE");
    }

    @Test
    @Disabled(value="Transfomer has been disabled")
    public void testEventSubprocessSignalWithTransformation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessSignalWithTransformation.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessSignal");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("MySignal", (Object)"john", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "Sub Process 1", "start-sub", "end-sub");
        String var = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)var).isNotNull();
        Assertions.assertThat((String)var).isEqualTo("JOHN");
    }

    @Test
    public void testMultipleMessageSignalSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleMessageSignalSubprocess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.Multiple_MessageSignal_Subprocess");
        this.logger.debug("Parent Process ID: " + processInstance.getStringId());
        this.kruntime.signalEvent("Message-Message 1", (Object)"Test", processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.kruntime.signalEvent("Message-Message 1", (Object)"Test", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventSignalWithRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithRef.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("Signal1", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    @Timeout(value=10L)
    public void testTimerMultipleInstances() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 3);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopBoundaryTimer.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("boundaryTimerMultipleInstances");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).isNotNull();
        Assertions.assertThat((int)workItems.size()).isEqualTo(3);
        for (KogitoWorkItem wi : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateTimerParallelGateway() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener1 = new NodeLeftCountDownProcessEventListener("Timer1", 1);
        NodeLeftCountDownProcessEventListener countDownListener2 = new NodeLeftCountDownProcessEventListener("Timer2", 1);
        NodeLeftCountDownProcessEventListener countDownListener3 = new NodeLeftCountDownProcessEventListener("Timer3", 1);
        ProcessCompletedCountDownProcessEventListener countDownProcessEventListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-IntermediateTimerParallelGateway.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener1);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener2);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener3);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownProcessEventListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Evaluation.timer-parallel");
        this.assertProcessInstanceActive(processInstance);
        countDownListener1.waitTillCompleted();
        countDownListener2.waitTillCompleted();
        countDownListener3.waitTillCompleted();
        countDownProcessEventListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateTimerEventMI() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("After timer", 3);
        this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-IntermediateTimerEventMI.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("defaultprocessid");
        this.assertProcessInstanceActive(processInstance);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.kruntime.abortProcessInstance(processInstance.getStringId());
        this.assertProcessInstanceAborted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testThrowIntermediateSignalWithScope() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2IntermediateThrowEventScope.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("intermediate-event-scope", params);
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("intermediate-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance.getStringId(), this.kruntime, "Complete work", "Wait");
        this.assertNodeActive(processInstance2.getStringId(), this.kruntime, "Complete work", "Wait");
        List<KogitoWorkItem> items = handler.getWorkItems();
        KogitoWorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), result, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance2.getStringId(), this.kruntime, "Complete work", "Wait");
        wi = items.get(1);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), result, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance2);
    }

    @Test
    public void testThrowEndSignalWithScope() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2EndThrowEventScope.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("end-event-scope", params);
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("end-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance.getStringId(), this.kruntime, "Complete work", "Wait");
        this.assertNodeActive(processInstance2.getStringId(), this.kruntime, "Complete work", "Wait");
        List<KogitoWorkItem> items = handler.getWorkItems();
        KogitoWorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), result, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        this.assertProcessInstanceActive(processInstance2);
        this.assertNodeActive(processInstance2.getStringId(), this.kruntime, "Complete work", "Wait");
        wi = items.get(1);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), result, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance2);
    }

    @Test
    public void testThrowIntermediateSignalWithExternalScope() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventExternalScope.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        KogitoWorkItemHandler externalHandler = new KogitoWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                String signal = (String)workItem.getParameter("Signal");
                IntermediateEventTest.this.kruntime.signalEvent(signal, null);
                manager.completeWorkItem(workItem.getStringId(), null, new Policy[0]);
            }

            public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            }
        };
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("External Send Task", externalHandler);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("intermediate-event-scope", params);
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeActive(processInstance.getStringId(), this.kruntime, "Complete work", "Wait");
        List<KogitoWorkItem> items = handler.getWorkItems();
        Assertions.assertThat((int)items.size()).isEqualTo(1);
        KogitoWorkItem wi = items.get(0);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("_output", "sending event");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), result, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testIntermediateCatchEventSignalWithVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithVariable.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        String signalVar = "myVarSignal";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("signalName", signalVar);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent", parameters);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent(signalVar, (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "StartProcess", "UserTask", "EndProcess", "event");
    }

    @Test
    public void testSignalIntermediateThrowWithVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventSignalWithVariable.bpmn2", "BPMN2-IntermediateCatchEventSignalWithVariable.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        String signalVar = "myVarSignal";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("signalName", signalVar);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent", parameters);
        this.assertProcessInstanceActive(processInstance);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        params.put("signalName", signalVar);
        KogitoProcessInstance processInstanceThrow = this.kruntime.startProcess("SignalIntermediateEvent", params);
        Assertions.assertThat((int)processInstanceThrow.getState()).isEqualTo(2);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInvalidDateTimerBoundary() throws Exception {
        try {
            this.createKogitoProcessRuntime("timer/BPMN2-TimerBoundaryEventDateInvalid.bpmn2");
            Assertions.fail((String)"Should fail as timer expression is not valid");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((boolean)e.getMessage().contains("Could not parse date 'abcdef'")).isTrue();
        }
    }

    @Test
    public void testInvalidDurationTimerBoundary() throws Exception {
        try {
            this.createKogitoProcessRuntime("timer/BPMN2-TimerBoundaryEventDurationInvalid.bpmn2");
            Assertions.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)e.getMessage().contains("Could not parse delay 'abcdef'")).isTrue();
        }
    }

    @Test
    public void testInvalidCycleTimerBoundary() throws Exception {
        try {
            this.createKogitoProcessRuntime("timer/BPMN2-TimerBoundaryEventCycleInvalid.bpmn2");
            Assertions.fail((String)"Should fail as timer expression is not valid");
        }
        catch (Exception e) {
            Assertions.assertThat((boolean)e.getMessage().contains("Could not parse delay 'abcdef'")).isTrue();
        }
    }

    @Test
    public void testIntermediateCatchEventConditionSetVariableAfter() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventConditionSetVariableAfter.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        Collection processInstances = this.kruntime.getKieSession().getObjects(object -> object instanceof KogitoProcessInstance);
        Assertions.assertThat((Collection)processInstances).isNotNull();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(1);
        Person person = new Person();
        person.setName("Jack");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstances = this.kruntime.getKieSession().getObjects(object -> object instanceof KogitoProcessInstance);
        Assertions.assertThat((Collection)processInstances).isNotNull();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(0);
    }

    @Test
    public void testIntermediateCatchEventConditionRemovePIAfter() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventCondition.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        Collection processInstances = this.kruntime.getKieSession().getObjects(object -> object instanceof KogitoProcessInstance);
        Assertions.assertThat((Collection)processInstances).isNotNull();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(1);
        Person person = new Person();
        person.setName("Jack");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        processInstances = this.kruntime.getKieSession().getObjects(object -> object instanceof KogitoProcessInstance);
        Assertions.assertThat((Collection)processInstances).isNotNull();
        Assertions.assertThat((int)processInstances.size()).isEqualTo(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10L)
    public void testEventBasedSplitWithCronTimerAndSignal() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        try {
            NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("Request photos of order in use", 1);
            NodeLeftCountDownProcessEventListener countDownListener2 = new NodeLeftCountDownProcessEventListener("Request an online review", 1);
            NodeLeftCountDownProcessEventListener countDownListener3 = new NodeLeftCountDownProcessEventListener("Send a thank you card", 1);
            NodeLeftCountDownProcessEventListener countDownListener4 = new NodeLeftCountDownProcessEventListener("Request an online review", 1);
            this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-CronTimerWithEventBasedGateway.bpmn2");
            TestWorkItemHandler handler = new TestWorkItemHandler();
            this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
            this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
            this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener2);
            this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener3);
            this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener4);
            KogitoProcessInstance processInstance = this.kruntime.startProcess("timerWithEventBasedGateway");
            this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
            countDownListener.waitTillCompleted();
            this.logger.debug("First timer triggered");
            countDownListener2.waitTillCompleted();
            this.logger.debug("Second timer triggered");
            countDownListener3.waitTillCompleted();
            this.logger.debug("Third timer triggered");
            countDownListener4.waitTillCompleted();
            this.logger.debug("Fourth timer triggered");
            List<KogitoWorkItem> wi = handler.getWorkItems();
            Assertions.assertThat(wi).isNotNull();
            Assertions.assertThat((int)wi.size()).isEqualTo(3);
            this.kruntime.abortProcessInstance(processInstance.getStringId());
        }
        finally {
            System.clearProperty("jbpm.enable.multi.con");
        }
    }

    @Test
    public void testEventSubprocessWithEmbeddedSignals() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessErrorSignalEmbedded.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("project2.myerrorprocess");
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("signal1", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.kruntime.signalEvent("signal2", null, processInstance.getStringId());
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.kruntime.signalEvent("signal3", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testEventSubprocessWithExpression() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessSignalExpression.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "signalling");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessSignalExpression", params);
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("signalling", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testConditionalProcessFactInsertedBefore() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventConditionPI.bpmn2", "BPMN2-IntermediateCatchEventSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        Person person0 = new Person("john");
        this.kruntime.getKieSession().insert((Object)person0);
        HashMap<String, String> params0 = new HashMap<String, String>();
        params0.put("name", "john");
        KogitoProcessInstance pi0 = this.kruntime.startProcess("IntermediateCatchEvent", params0);
        this.kruntime.getKieSession().insert((Object)pi0);
        Person person = new Person("Jack");
        this.kruntime.getKieSession().insert((Object)person);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "Poul");
        KogitoProcessInstance pi = this.kruntime.startProcess("IntermediateCatchEventPI", params);
        this.kruntime.getKieSession().insert((Object)pi);
        pi = this.kruntime.getProcessInstance(pi.getStringId());
        Assertions.assertThat((Object)pi).isNotNull();
        Person person2 = new Person("Poul");
        this.kruntime.getKieSession().insert((Object)person2);
        pi = this.kruntime.getProcessInstance(pi.getStringId());
        Assertions.assertThat((Object)pi).isNull();
    }

    @Test
    public void testBoundarySignalEventOnSubprocessWithVariableResolution() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubprocessWithSignalEndEventAndSignalBoundaryEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("document-ref", "signalling");
        params.put("message", "hello");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubprocessWithSignalEndEventAndSignalBoundaryEvent", params);
        this.assertNodeTriggered(processInstance.getStringId(), "sysout from boundary", "end2");
        this.assertNotNodeTriggered(processInstance.getStringId(), "end1");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testSignalEndWithData() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventSignalWithData.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("testThrowingSignalEvent", params);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("mysignal", null, processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testDynamicCatchEventSignal() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/dynamic-signal-parent.bpmn2", "subprocess/dynamic-signal-child.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        final ArrayList instances = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                instances.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("src.father");
        this.assertProcessInstanceActive(processInstance);
        Assertions.assertThat(instances).hasSize(4);
        instances.remove(processInstance.getStringId());
        for (String id : instances) {
            KogitoProcessInstance child = this.kruntime.getProcessInstance(id);
            this.assertProcessInstanceActive(child);
        }
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        for (String id : instances) {
            org.junit.jupiter.api.Assertions.assertNull((Object)this.kruntime.getProcessInstance(id), (String)"Child process instance has not been finished.");
        }
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testDynamicCatchEventSignalWithVariableUpdated() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/dynamic-signal-parent.bpmn2", "subprocess/dynamic-signal-child.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        final ArrayList instances = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                instances.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("src.father");
        this.assertProcessInstanceActive(processInstance);
        Assertions.assertThat(instances).hasSize(4);
        instances.remove(processInstance.getStringId());
        for (String id : instances) {
            KogitoProcessInstance child = this.kruntime.getProcessInstance(id);
            this.assertProcessInstanceActive(child);
        }
        String changeProcessInstanceId = (String)instances.remove(0);
        HashMap<String, Object> updatedVariables = new HashMap<String, Object>();
        updatedVariables.put("fatherId", "999");
        this.kruntime.getKieSession().execute((Command)new KogitoSetProcessInstanceVariablesCommand(changeProcessInstanceId, updatedVariables));
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        for (String id : instances) {
            org.junit.jupiter.api.Assertions.assertNull((Object)this.kruntime.getProcessInstance(id), (String)"Child process instance has not been finished.");
        }
        KogitoProcessInstance updatedChild = this.kruntime.getProcessInstance(changeProcessInstanceId);
        this.assertProcessInstanceActive(updatedChild);
        this.kruntime.signalEvent("stopChild:999", null, changeProcessInstanceId);
        this.assertProcessInstanceFinished(updatedChild, this.kruntime);
    }

    @RequirePersistence
    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testDynamicCatchEventSignalWithVariableUpdatedBroadcastSignal() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/dynamic-signal-parent.bpmn2", "subprocess/dynamic-signal-child.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        final ArrayList instances = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                instances.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("src.father");
        this.assertProcessInstanceActive(processInstance);
        Assertions.assertThat(instances).hasSize(4);
        instances.remove(processInstance.getStringId());
        for (String id : instances) {
            KogitoProcessInstance child = this.kruntime.getProcessInstance(id);
            this.assertProcessInstanceActive(child);
        }
        String changeProcessInstanceId = (String)instances.remove(0);
        HashMap<String, Object> updatedVariables = new HashMap<String, Object>();
        updatedVariables.put("fatherId", "999");
        this.kruntime.getKieSession().execute((Command)new KogitoSetProcessInstanceVariablesCommand(changeProcessInstanceId, updatedVariables));
        KogitoWorkItem workItem = handler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        for (String id : instances) {
            org.junit.jupiter.api.Assertions.assertNull((Object)this.kruntime.getProcessInstance(id), (String)"Child process instance has not been finished.");
        }
        KogitoProcessInstance updatedChild = this.kruntime.getProcessInstance(changeProcessInstanceId);
        this.assertProcessInstanceActive(updatedChild);
        this.kruntime.signalEvent("stopChild:999", null, updatedChild.getStringId());
        this.assertProcessInstanceFinished(updatedChild, this.kruntime);
    }
}

