/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.NotAvailableGoodsReport;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class StartEventTest
extends JbpmBpmn2TestCase {
    @Test
    public void testConditionalStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ConditionalStart.bpmn2");
        final ArrayList startedInstances = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                startedInstances.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Person person = new Person();
        person.setName("jack");
        this.kruntime.getKieSession().insert((Object)person);
        Assertions.assertThat(startedInstances).hasSize(0);
        person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        Assertions.assertThat(startedInstances).hasSize(1);
        this.assertNodeTriggered((String)startedInstances.get(0), "StartProcess", "Hello", "EndProcess");
    }

    @Test
    @Timeout(value=10L)
    public void testTimerStartCycleLegacy() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerStartCycleLegacy.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.logger.debug("About to start ###### " + new Date());
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(2);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerStart.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(5);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerStartDateISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        byte[] content = Files.readAllBytes(Paths.get(this.getClass().getResource("/BPMN2-TimerStartDate.bpmn2").getPath(), new String[0]));
        String processContent = new String(content, "UTF-8");
        OffsetDateTime plusTwoSeconds = OffsetDateTime.now().plusSeconds(2L);
        processContent = processContent.replaceFirst("#\\{date\\}", plusTwoSeconds.toString());
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processContent));
        resource.setSourcePath("/BPMN2-TimerStartDate.bpmn2");
        resource.setTargetPath("/BPMN2-TimerStartDate.bpmn2");
        this.kruntime = this.createKogitoProcessRuntime(resource);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerStartCycleISO() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 6);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerStartISO.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(6);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerStartDuration() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerStartDuration.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
    }

    @Test
    public void testSignalToStartProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalStart.bpmn2", "BPMN2-IntermediateThrowEventSignal.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        final ArrayList startedProcesses = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                startedProcesses.add(event.getProcessInstance().getProcessId());
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SignalIntermediateEvent");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
        Assertions.assertThat((int)this.getNumberOfProcessInstances("SignalIntermediateEvent")).isEqualTo(1);
    }

    @Test
    public void testSignalStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalStart.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("MySignal", (Object)"NewValue");
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
    }

    @Test
    public void testSignalStartDynamic() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalStart.bpmn2");
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        KieContainer kContainer = ks.newKieContainer(kr.getDefaultReleaseId());
        kContainer.getKieBase();
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                StartEventTest.this.logger.info("{}", (Object)((KogitoProcessInstance)event.getProcessInstance()).getStringId());
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("MySignal", (Object)"NewValue");
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
        this.kruntime.getKieBase().removeProcess("Minimal");
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.kruntime.signalEvent("MySignal", (Object)"NewValue")).withMessageContaining("Unknown process ID: Minimal");
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
    }

    @Test
    public void testMessageStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MessageStart.bpmn2");
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"NewValue");
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
    }

    @Test
    public void testMultipleStartEventsRegularStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleStartEventProcessLongInterval.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultipleStartEvents");
        this.assertProcessInstanceActive(processInstance);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testMultipleStartEventsStartOnTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleStartEventProcess.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("MultipleStartEvents")).isEqualTo(2);
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("startSignal", null);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        String processInstanceId = ((KogitoWorkItemImpl)workItem).getProcessInstanceStringId();
        KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testMultipleEventBasedStartEventsDifferentPaths() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.startProcess("muliplestartevents");
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        String processInstanceId = workItem.getProcessInstanceStringId();
        KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstanceId, "Start", "Script 1", "User task", "End");
    }

    @Test
    @Timeout(value=10L)
    public void testMultipleEventBasedStartEventsTimerDifferentPaths() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        List<KogitoWorkItem> workItems = workItemHandler.getWorkItems();
        for (KogitoWorkItem workItem : workItems) {
            String processInstanceId = workItem.getProcessInstanceStringId();
            KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
            Assertions.assertThat((Object)workItem).isNotNull();
            Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
            this.assertProcessInstanceFinished(processInstance, this.kruntime);
            this.assertNodeTriggered(processInstanceId, "StartTimer", "Script 2", "User task", "End");
        }
    }

    @Test
    public void testMultipleEventBasedStartEventsSignalDifferentPaths() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleStartEventProcessDifferentPaths.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("startSignal", null);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        String processInstanceId = ((KogitoWorkItemImpl)workItem).getProcessInstanceStringId();
        KogitoProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstanceId, "StartSignal", "Script 3", "User task", "End");
    }

    @Test
    @Timeout(value=10L)
    public void testMultipleEventBasedStartEventsStartOnTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartTimer", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleEventBasedStartEventProcess.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat((int)list.size()).isEqualTo(0);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("MultipleStartEvents")).isEqualTo(2);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerCycle() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 5);
        this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-StartTimerCycle.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        StartCountingListener listener = new StartCountingListener();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)listener.getCount("start.cycle")).isEqualTo(5);
    }

    @Test
    @Timeout(value=10L)
    public void testSignalStartWithTransformation() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 1);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalStartWithTransformation.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add((KogitoProcessInstance)event.getProcessInstance());
            }
        });
        this.kruntime.signalEvent("MySignal", (Object)"NewValue");
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)this.getNumberOfProcessInstances("Minimal")).isEqualTo(1);
        Assertions.assertThat(list).isNotNull();
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        String var = this.getProcessVarValue((KogitoProcessInstance)list.get(0), "x");
        Assertions.assertThat((String)var).isEqualTo("NEWVALUE");
    }

    @Test
    @Timeout(value=10L)
    public void testTimerDelay() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("start", 1);
        this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-StartTimerDuration.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        StartCountingListener listener = new StartCountingListener();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        countDownListener.waitTillCompleted();
        Assertions.assertThat((int)listener.getCount("start.delaying")).isEqualTo(1);
    }

    @Test
    public void testSignalStartWithCustomEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SingalStartWithCustomEvent.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add((KogitoProcessInstance)event.getProcessInstance());
            }
        });
        NotAvailableGoodsReport report = new NotAvailableGoodsReport("test");
        this.kruntime.signalEvent("SignalNotAvailableGoods", (Object)report);
        Assertions.assertThat((int)this.getNumberOfProcessInstances("org.jbpm.example.SignalObjectProcess")).isEqualTo(1);
        Assertions.assertThat((int)list.size()).isEqualTo(1);
        this.assertProcessVarValue((KogitoProcessInstance)list.get(0), "report", "NotAvailableGoodsReport{type:test}");
    }

    @Test
    public void testInvalidDateTimerStart() throws Exception {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.createKogitoProcessRuntime("timer/BPMN2-StartTimerDateInvalid.bpmn2")).withMessageContaining("Could not parse date 'abcdef'");
    }

    @Test
    public void testInvalidDurationTimerStart() throws Exception {
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.createKogitoProcessRuntime("timer/BPMN2-StartTimerDurationInvalid.bpmn2")).withMessageContaining("Could not parse delay 'abcdef'");
    }

    @Test
    public void testInvalidCycleTimerStart() throws Exception {
        Assertions.assertThatExceptionOfType(Exception.class).isThrownBy(() -> this.createKogitoProcessRuntime("timer/BPMN2-StartTimerCycleInvalid.bpmn2")).withMessageContaining("Could not parse delay 'abcdef'");
    }

    @Test
    public void testStartithMultipleOutgoingFlows() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        try {
            this.kruntime = this.createKogitoProcessRuntime("BPMN2-StartEventWithMultipleOutgoingFlows.bpmn2");
            KogitoProcessInstance pi = this.kruntime.startProcess("starteventwithmutlipleflows");
            this.assertProcessInstanceCompleted(pi);
            this.assertNodeTriggered(pi.getStringId(), "Script 1", "Script 2");
        }
        finally {
            System.clearProperty("jbpm.enable.multi.con");
        }
    }

    private static class StartCountingListener
    extends DefaultKogitoProcessEventListener {
        private Map<String, Integer> map = new HashMap<String, Integer>();

        private StartCountingListener() {
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
            String processId = event.getProcessInstance().getProcessId();
            Integer count = this.map.get(processId);
            if (count == null) {
                this.map.put(processId, 1);
            } else {
                this.map.put(processId, count + 1);
            }
        }

        public int getCount(String processId) {
            Integer count = this.map.get(processId);
            return count == null ? 0 : count;
        }
    }
}

