/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.canonical;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.io.ClassPathResource;
import org.drools.util.PortablePath;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.compiler.canonical.ProcessMetaData;
import org.jbpm.compiler.canonical.ProcessToExecModelGenerator;
import org.jbpm.compiler.canonical.UserTaskModelMetaData;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.process.WorkflowProcess;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.Resource;
import org.kie.kogito.Application;
import org.kie.kogito.Config;
import org.kie.kogito.KogitoConfig;
import org.kie.kogito.KogitoEngine;
import org.kie.kogito.StaticApplication;
import org.kie.kogito.StaticConfig;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcesses;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.kie.kogito.process.impl.DefaultProcessEventListenerConfig;
import org.kie.kogito.process.impl.StaticProcessConfig;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.memorycompiler.CompilationResult;
import org.kie.memorycompiler.JavaCompiler;
import org.kie.memorycompiler.JavaCompilerFactory;
import org.kie.memorycompiler.JavaConfiguration;
import org.kie.memorycompiler.resources.ResourceReader;
import org.kie.memorycompiler.resources.ResourceStore;

public class ActivityGenerationModelTest
extends JbpmBpmn2TestCase {
    private static final JavaCompiler JAVA_COMPILER = JavaCompilerFactory.loadCompiler((JavaConfiguration.CompilerType)JavaConfiguration.CompilerType.NATIVE, (String)"1.8");

    @Test
    public void testMinimalProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-MinimalProcess.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("com.sample.MinimalProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        ProcessInstance processInstance = processes.get("Minimal").createInstance();
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testProcessEmptyScript() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ProcessEmptyScript.bpmn2")}).get(0);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get()));
    }

    @Test
    public void testUserTaskProcessWithTaskModels() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        List models = ProcessToExecModelGenerator.INSTANCE.generateUserTaskModel((WorkflowProcess)process.get());
        for (UserTaskModelMetaData metaData : models) {
            String content = metaData.generateInput();
            Assertions.assertThat((String)content).isNotNull();
            this.log(content);
            content = metaData.generateOutput();
            Assertions.assertThat((String)content).isNotNull();
            this.log(content);
        }
    }

    @Test
    public void testUserTaskProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.UserTaskProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("UserTask").createInstance();
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance.completeWorkItem(workItem.getStringId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testUserTaskWithParamProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTaskWithParametrizedInput.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.UserTaskProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("UserTask").createInstance();
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)("Executing task of process instance " + processInstance.id() + " as work item with Hello"), (Object)workItem.getParameter("Description").toString().trim());
        processInstance.completeWorkItem(workItem.getStringId(), null, new Policy[]{SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"))});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testScriptMultilineExprProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-CallActivitySubProcess.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.SubProcessProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        ProcessInstance processInstance = processes.get("SubProcess").createInstance();
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ExclusiveSplit.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        SystemOutWorkItemHandler workItemHandler = new SystemOutWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Email", workItemHandler));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testExclusiveSplitRetriggerAfterError() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ExclusiveSplit.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        SystemOutWorkItemHandler workItemHandler = new SystemOutWorkItemHandler();
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Email", workItemHandler));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First1");
        params.put("y", "Second1");
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)5, (int)processInstance.status());
        Optional errorOptional = processInstance.error();
        Assertions.assertThat((Optional)errorOptional).isPresent();
        ProcessError error = (ProcessError)errorOptional.get();
        Assertions.assertThat((String)error.failedNodeId()).isEqualTo("_2");
        Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"XOR split could not find at least one valid outgoing connection for split Split"});
        params.put("x", "First");
        processInstance.updateVariables((Object)BpmnVariables.create(params));
        error.retrigger();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-InclusiveSplit.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testInclusiveSplitDefaultConnection() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-InclusiveGatewayWithDefault.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.InclusiveGatewayWithDefaultProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "c");
        ProcessInstance processInstance = processes.get("InclusiveGatewayWithDefault").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testParallelGateway() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ParallelSplit.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.emptyMap());
        HashMap params = new HashMap();
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testInclusiveSplitAndJoinNested() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-InclusiveSplitAndJoinNested.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            processInstance.completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            processInstance.completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testInclusiveSplitAndJoinNestedWithBusinessKey() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-InclusiveSplitAndJoinNested.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.TestProcess", content);
        String businessKey = "custom";
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("Human Task", workItemHandler));
        ProcessInstance processInstance = processes.get("com.sample.test").createInstance(businessKey, BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        ProcessInstance loadedProcessInstance = processes.get("com.sample.test").instances().findById(processInstance.id()).orElse(null);
        Assertions.assertThat((Object)loadedProcessInstance).isNotNull();
        Assertions.assertThat((String)loadedProcessInstance.businessKey()).isEqualTo(businessKey);
        loadedProcessInstance.abort();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)processInstance.status());
    }

    @Test
    public void testWorkItemProcessWithVariableMapping() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ServiceProcess.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        HashMap<String, String> classData = new HashMap<String, String>();
        classData.put("org.drools.bpmn2.ServiceProcessProcess", content);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("org.jbpm.bpmn2.objects.HelloService_hello_2_Handler", workItemHandler));
        ProcessInstance processInstance = processes.get("ServiceProcess").createInstance(BpmnVariables.create(params));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("Parameter"));
        processInstance.completeWorkItem(workItem.getStringId(), Collections.singletonMap("Result", "john doe"), new Policy[0]);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
    }

    @Test
    public void testBusinessRuleTaskProcess() throws Exception {
        MockClassLoader classLoader = new MockClassLoader("org.kie.api.runtime.KieRuntimeBuilder");
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-BusinessRuleTask.bpmn2")}).get(0);
        ProcessMetaData metaData = new ProcessToExecModelGenerator((ClassLoader)classLoader).generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
    }

    @Test
    public void testServiceTaskProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-ServiceProcess.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)metaData.getWorkItems()).hasSize(1)).contains((Object[])new String[]{"org.jbpm.bpmn2.objects.HelloService_hello_2_Handler"});
    }

    @Test
    public void testCallActivityProcess() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("PrefixesProcessIdCallActivity.bpmn2")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)metaData.getSubProcesses()).hasSize(1)).containsKey((Object)"SubProcess")).containsValue((Object)"test.SubProcess");
    }

    @Test
    public void testAsyncExecution() throws Exception {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("async/AsyncProcess.bpmn")}).get(0);
        ProcessMetaData metaData = ProcessToExecModelGenerator.INSTANCE.generate((WorkflowProcess)process.get());
        String content = metaData.getGeneratedClassModel().toString();
        Assertions.assertThat((String)content).isNotNull();
        this.log(content);
        Map<String, String> classData = Collections.singletonMap("com.example.AsyncProcessProcess", content);
        final CountDownLatch latch = new CountDownLatch(1);
        String mainThread = Thread.currentThread().getName();
        final AtomicReference workItemThread = new AtomicReference();
        KogitoWorkItemHandler workItemHandler = new KogitoWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                workItemThread.set(Thread.currentThread().getName());
                manager.completeWorkItem(workItem.getStringId(), Collections.singletonMap("response", "hello " + workItem.getParameter("name")), new Policy[0]);
                latch.countDown();
            }

            public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                latch.countDown();
            }
        };
        Map<String, BpmnProcess> processes = this.createProcesses(classData, Collections.singletonMap("org.jbpm.bpmn2.objects.HelloService_hello_3_Handler", workItemHandler));
        ProcessInstance i = (ProcessInstance)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)process.getApplication().unitOfWorkManager(), () -> {
            ProcessInstance processInstance = ((BpmnProcess)processes.get("AsyncProcess")).createInstance(BpmnVariables.create(Collections.singletonMap("name", "Tiago")));
            processInstance.start();
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
            return processInstance;
        });
        latch.await(5L, TimeUnit.SECONDS);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)i.status());
        BpmnVariables variables = (BpmnVariables)i.variables();
        org.junit.jupiter.api.Assertions.assertEquals((Object)variables.get("greeting"), (Object)"hello Tiago");
        org.junit.jupiter.api.Assertions.assertNotEquals((Object)mainThread, workItemThread.get());
    }

    protected void log(String content) {
        this.logger.debug(content);
    }

    protected Map<String, BpmnProcess> createProcesses(Map<String, String> classData, Map<String, KogitoWorkItemHandler> handlers) throws Exception {
        MemoryFileSystem srcMfs = new MemoryFileSystem();
        MemoryFileSystem trgMfs = new MemoryFileSystem();
        String[] sources = new String[classData.size()];
        int index = 0;
        for (Map.Entry<String, String> entry : classData.entrySet()) {
            String fileName = entry.getKey().replaceAll("\\.", "/") + ".java";
            sources[index++] = fileName;
            srcMfs.write(fileName, entry.getValue().getBytes());
        }
        CompilationResult result = JAVA_COMPILER.compile(sources, (ResourceReader)srcMfs, (ResourceStore)trgMfs, this.getClass().getClassLoader());
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object[])result.getErrors()).hasSize(0);
        CachedWorkItemHandlerConfig wiConfig = new CachedWorkItemHandlerConfig();
        for (Map.Entry entry : handlers.entrySet()) {
            wiConfig.register((String)entry.getKey(), (KogitoWorkItemHandler)entry.getValue());
        }
        StaticProcessConfig config = new StaticProcessConfig((WorkItemHandlerConfig)wiConfig, (ProcessEventListenerConfig)new DefaultProcessEventListenerConfig(new ProcessEventListener[0]), (UnitOfWorkManager)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        TestClassLoader testClassLoader = new TestClassLoader(this.getClass().getClassLoader(), trgMfs.getMap());
        HashMap<String, BpmnProcess> processes = new HashMap<String, BpmnProcess>();
        BpmnProcesses bpmnProcesses = new BpmnProcesses();
        StaticApplication application = new StaticApplication((Config)new StaticConfig(null, new KogitoConfig[]{config}), new KogitoEngine[]{bpmnProcesses});
        for (String className : classData.keySet()) {
            Class<?> processClass = Class.forName(className, true, testClassLoader);
            Method processMethod = processClass.getMethod("process", new Class[0]);
            Process process = (Process)processMethod.invoke(null, new Object[0]);
            Assertions.assertThat((Object)process).isNotNull();
            processes.put(process.getId(), new BpmnProcess(process, (ProcessConfig)config, (Application)application));
        }
        return processes;
    }

    private static class MockClassLoader
    extends ClassLoader {
        private final Collection<String> mockedClass = new ArrayList<String>();

        private MockClassLoader(String ... mockedClass) {
            this.mockedClass.addAll(Arrays.asList(mockedClass));
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            if (this.mockedClass.contains(name)) {
                return Object.class;
            }
            return super.loadClass(name);
        }
    }

    private static class TestClassLoader
    extends URLClassLoader {
        private final Map<String, byte[]> extraClassDefs = new HashMap<String, byte[]>();

        public TestClassLoader(ClassLoader parent, Map<PortablePath, byte[]> extraClassDefs) {
            super(new URL[0], parent);
            for (Map.Entry<PortablePath, byte[]> entry : extraClassDefs.entrySet()) {
                this.extraClassDefs.put(entry.getKey().asString().replace('/', '.').replaceFirst("\\.class", ""), entry.getValue());
            }
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classBytes = this.extraClassDefs.remove(name);
            if (classBytes != null) {
                return this.defineClass(name, classBytes, 0, classBytes.length);
            }
            return super.findClass(name);
        }
    }
}

