/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.core.runtime.process.ProcessRuntimeFactoryService;
import org.drools.kiesession.session.ProcessRuntimeFactory;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ErrornousWorkItemHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ProcessRuntimeFactoryServiceImpl;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.process.workitem.Policy;
import org.mockito.Mockito;

public class WorkItemHandlerExceptionHandlingTest
extends JbpmBpmn2TestCase {
    private static Boolean strictVariableSetting = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", Boolean.FALSE.toString()));
    private static Application application = (Application)Mockito.mock(Application.class);

    @BeforeAll
    public static void setup() throws Exception {
        VariableScope.setVariableStrictOption((boolean)false);
    }

    @AfterAll
    public static void clean() throws Exception {
        VariableScope.setVariableStrictOption((boolean)strictVariableSetting);
    }

    @Override
    protected KogitoProcessRuntime createKogitoProcessRuntime(String ... processNames) throws Exception {
        KogitoProcessRuntime kogitoRuntime = (KogitoProcessRuntime)Mockito.spy((Object)super.createKogitoProcessRuntime(processNames));
        Mockito.when((Object)kogitoRuntime.getApplication()).thenReturn((Object)application);
        Mockito.when((Object)((Processes)application.get(Processes.class))).thenReturn((Object)new DummyProcesses(kogitoRuntime));
        return kogitoRuntime;
    }

    @Test
    public void testErrornousHandlerWithStrategyComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        KogitoWorkItem handledWorkItem = (KogitoWorkItem)workItemHandler.getWorkItem();
        Assertions.assertEquals((int)2, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyCompleteWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyAbort() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        KogitoWorkItem handledWorkItem = (KogitoWorkItem)workItemHandler.getWorkItem();
        Assertions.assertEquals((int)3, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyAbortWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyRethrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETHROW);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyRetry() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }

    @Test
    public void testErrornousHandlerWithStrategyRetryWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }

    static {
        ProcessRuntimeFactory.setProcessRuntimeFactoryService((ProcessRuntimeFactoryService)new ProcessRuntimeFactoryServiceImpl(application));
    }

    private static class DummyProcesses
    implements Processes {
        private Map<String, org.kie.kogito.process.Process<? extends Model>> mappedProcesses = new ConcurrentHashMap<String, org.kie.kogito.process.Process<? extends Model>>();
        private KogitoProcessRuntime kruntime;

        public DummyProcesses(KogitoProcessRuntime kogitoRuntime) {
            this.kruntime = kogitoRuntime;
        }

        public org.kie.kogito.process.Process<? extends Model> processById(String processId) {
            return this.mappedProcesses.computeIfAbsent(processId, p -> new DummyProcess(this.kruntime, (String)p));
        }

        public Collection<String> processIds() {
            return this.mappedProcesses.keySet();
        }
    }

    private static class DummyProcessInstance
    extends AbstractProcessInstance<Model> {
        public DummyProcessInstance(AbstractProcess<Model> process, Model variables, ProcessRuntime rt) {
            super(process, variables, rt);
        }

        protected void unbind(Model variables, Map<String, Object> vmap) {
            try {
                super.unbind(variables, vmap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class DummyProcess
    extends AbstractProcess<Model> {
        private Process process;
        private KogitoProcessRuntime kruntime;

        public DummyProcess(KogitoProcessRuntime kruntime, String processId) {
            this.kruntime = kruntime;
            this.process = kruntime.getKieBase().getProcess(processId);
        }

        public ProcessInstance<Model> createInstance(String businessKey, CompositeCorrelation correlation, Model workingMemory) {
            return this.createInstance(businessKey, workingMemory);
        }

        public ProcessInstance<Model> createInstance(Model parameters) {
            return new DummyProcessInstance(this, parameters, (ProcessRuntime)this.kruntime.getProcessEventManager());
        }

        public Model createModel() {
            return new Model(){};
        }

        public ProcessInstance<Model> createInstance(WorkflowProcessInstance wpi) {
            throw new UnsupportedOperationException();
        }

        public ProcessInstance<Model> createReadOnlyInstance(WorkflowProcessInstance wpi) {
            throw new UnsupportedOperationException();
        }

        public Process process() {
            return this.process;
        }
    }
}

