/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.structureref;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.core.datatype.impl.coverter.TypeConverterRegistry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class StructureRefTest
extends JbpmBpmn2TestCase {
    @Test
    public void testStringStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-StringStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "test value");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testBooleanStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BooleanStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "true");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testIntegerStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntegerStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "25");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testFloatStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-FloatStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", "5.5");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testObjectStructureRef() throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Person.class});
        String personAsXml = "<person><id>1</id><name>john</name></person>";
        TypeConverterRegistry.get().register("org.jbpm.bpmn2.objects.Person", s -> {
            try {
                return context.createUnmarshaller().unmarshal((Reader)new StringReader((String)s));
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        });
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ObjectStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", personAsXml);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testDefaultObjectStructureRef() throws Exception {
        String value = "simple text for testing";
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-DefaultObjectStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("testHT", value);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testNotExistingVarBooleanStructureRefOnStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BooleanStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("not existing", "invalid boolean");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.kruntime.startProcess("StructureRef", params));
    }

    @Test
    public void testInvalidBooleanStructureRefOnStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BooleanStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "invalid boolean");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.kruntime.startProcess("StructureRef", params));
    }

    @Test
    public void testInvalidBooleanStructureRefOnWIComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntegerStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        res.put("testHT", true);
        try {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException iae) {
            this.logger.info("Expected IllegalArgumentException caught: " + iae);
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }

    @Test
    public void testInvalidBooleanStructureRefOnStartVerifyErrorMsg() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BooleanStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("test", "invalid boolean");
            this.kruntime.startProcess("StructureRef", params);
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Variable 'test' has incorrect data type expected:java.lang.Boolean actual:java.lang.String", (Object)e.getMessage());
        }
    }

    @Test
    public void testInvalidBooleanStructureRefOnStartWithDisabledCheck() throws Exception {
        VariableScope.setVariableStrictOption((boolean)false);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BooleanStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "invalid boolean");
        this.kruntime.startProcess("StructureRef", params);
        VariableScope.setVariableStrictOption((boolean)true);
    }

    @Test
    public void testNotExistingBooleanStructureRefOnWIComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntegerStructureRef.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("StructureRef");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        String wrongDataOutput = "not existing";
        HashMap<String, Boolean> res = new HashMap<String, Boolean>();
        res.put(wrongDataOutput, true);
        try {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), res, new Policy[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Expected IllegalArgumentException catched: " + iae);
            Assertions.assertEquals((Object)("Data output '" + wrongDataOutput + "' is not defined in process 'StructureRef' for task 'User Task'"), (Object)iae.getMessage());
        }
        catch (Exception e) {
            Assertions.fail();
        }
    }
}

