/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.StandaloneBPMNProcessTest;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.bpmn2.objects.ExceptionOnPurposeHandler;
import org.jbpm.bpmn2.objects.MyError;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.event.listeners.RuleAwareProcessEventListener;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

public class ErrorEventTest
extends JbpmBpmn2TestCase {
    @Test
    public void testEventSubprocessError() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "end", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertThat(executednodes).hasSize(1);
    }

    @Test
    public void testEventSubprocessErrorThrowOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubprocessError.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script Task 1")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                throw new MyError();
            }

            @Override
            public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                manager.abortWorkItem(workItem.getStringId(), new Policy[0]);
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-EventSubprocessError");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "User Task 1", "Sub Process 1", "start-sub", "Script Task 1", "end-sub");
        Assertions.assertThat(executednodes).hasSize(1);
    }

    @Test
    public void testEventSubprocessErrorWithErrorCode() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/EventSubprocessErrorHandlingWithErrorCode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script2")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("order-fulfillment-bpm.ccc");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "Script1", "starterror", "Script2", "end2", "eventsubprocess");
        this.assertProcessVarValue(processInstance, "CapturedException", "java.lang.RuntimeException: XXX");
        Assertions.assertThat(executednodes).hasSize(1);
    }

    @Test
    public void testEventSubprocessErrorWithOutErrorCode() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("subprocess/EventSubprocessErrorHandlingWithOutErrorCode.bpmn2");
        final ArrayList executednodes = new ArrayList();
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("Script2")) {
                    executednodes.add(((KogitoNodeInstance)event.getNodeInstance()).getStringId());
                }
            }
        };
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("order-fulfillment-bpm.ccc");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "Script1", "starterror", "Script2", "end2", "eventsubprocess");
        this.assertProcessVarValue(processInstance, "CapturedException", "java.lang.RuntimeException: XXX");
        Assertions.assertThat(executednodes).hasSize(1);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testErrorBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).hasSize(2);
        KogitoWorkItem workItem = workItems.get(0);
        if (!"john".equalsIgnoreCase((String)workItem.getParameter("ActorId"))) {
            workItem = workItems.get(1);
        }
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertProcessInstanceAborted(processInstance);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "split", "User Task", "User task error attached", "error end event");
        this.assertNotNodeTriggered(processInstance.getStringId(), "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorBoundaryEventOnServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventOnServiceTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "test");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ErrorBoundaryEventOnServiceTask", params);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        Assertions.assertThat(workItems).hasSize(1);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(0).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "split", "User Task", "Service task error attached", "end0", "Script Task", "error2");
        this.assertNotNodeTriggered(processInstance.getStringId(), "end");
    }

    @Test
    public void testErrorBoundaryEventOnBusinessRuleTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventOnBusinessRuleTask.bpmn2", "BPMN2-ErrorBoundaryEventOnBusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ErrorBoundaryEventOnBusinessRuleTask");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "business rule task error attached", "error1");
    }

    @Test
    public void testMultiErrorBoundaryEventsOnBusinessRuleTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.bpmn2", "BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        HashMap<String, Person> params = new HashMap<String, Person>();
        params.put("person", new Person());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-MultiErrorBoundaryEventeOnBusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "business rule task error attached", "NPE Script Task", "error1");
        this.kruntime.getKieSession().dispose();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.bpmn2", "BPMN2-MultiErrorBoundaryEventsOnBusinessRuleTask.drl");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new RuleAwareProcessEventListener());
        params = new HashMap();
        params.put("person", new Person("unsupported"));
        KogitoProcessInstance processInstance2 = this.kruntime.startProcess("BPMN2-MultiErrorBoundaryEventeOnBusinessRuleTask", params);
        this.assertProcessInstanceFinished(processInstance2, this.kruntime);
        this.assertNodeTriggered(processInstance2.getStringId(), "start", "business rule task error attached", "UOE Script Task", "error2");
    }

    @Test
    public void testCatchErrorBoundaryEventOnTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventOnTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new TestWorkItemHandler(){

            @Override
            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                if (workItem.getParameter("ActorId").equals("mary")) {
                    throw new MyError();
                }
            }

            @Override
            public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                manager.abortWorkItem(workItem.getStringId(), new Policy[0]);
            }
        });
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-ErrorBoundaryEventOnTask");
        this.assertProcessInstanceActive(processInstance);
        this.assertNodeTriggered(processInstance.getStringId(), "start", "split", "User Task", "User task error attached", "Script Task", "error1", "error2");
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask(this.kruntime);
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.kruntime);
    }

    @Test
    public void testEventSubProcessErrorWithScript() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventSubProcessErrorWithScript.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Request Handler", (KogitoWorkItemHandler)new SignallingTaskHandlerDecorator(ExceptionOnPurposeHandler.class, "Error-90277"));
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Error Handler", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.process");
        this.assertProcessInstanceAborted(processInstance);
        Assertions.assertThat((String)((WorkflowProcessInstance)processInstance).getOutcome()).isEqualTo("90277");
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testErrorBoundaryEventOnEntry() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventCatchingOnEntryException.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundaryErrorEventOnEntry");
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        Assertions.assertThat(handler.getWorkItems()).hasSize(1);
    }

    @Test
    @Disabled(value="On Exit not supported, see https://issues.redhat.com/browse/KOGITO-2067")
    public void testErrorBoundaryEventOnExit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventCatchingOnExitException.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BoundaryErrorEventOnExit");
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        KogitoWorkItem workItem = handler.getWorkItem();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        Assertions.assertThat(handler.getWorkItems()).hasSize(1);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventDefaultHandlerWithErrorCodeWithStructureRef.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithWorkItemExecutionError() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventDefaultHandlerByErrorCode.bpmn2");
        WorkItemExecutionErrorWorkItemHandler handler = new WorkItemExecutionErrorWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithErrorCodeWithoutStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventDefaultHandlerWithErrorCodeWithoutStructureRef.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(5);
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventDefaultHandlerWithoutErrorCodeWithStructureRef.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getStringId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    @Test
    public void testBoundaryErrorEventDefaultHandlerWithoutErrorCodeWithoutStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventDefaultHandlerWithoutErrorCodeWithoutStructureRef.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getStringId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    @Test
    public void testBoundaryErrorEventSubProcessExceptionMapping() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventSubProcessExceptionMapping.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        Assertions.assertThat((String)this.getProcessVarValue(processInstance, "var1")).isEqualTo("java.lang.RuntimeException");
    }

    @Test
    public void testBoundaryErrorEventStructureRef() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-BoundaryErrorEventStructureRef.bpmn2");
        ExceptionWorkItemHandler handler = new ExceptionWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.bpmn.hello");
        this.assertNodeTriggered(processInstance.getStringId(), "Start", "User Task", "MyBoundaryErrorEvent");
    }

    @Test
    public void testEndErrorWithSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("error/EndErrorWithEventSubprocess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EndErrorWithEventSubprocess");
        this.assertNodeTriggered(processInstance.getStringId(), "start", "task", "subprocess-task");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEndError() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("error/EndError.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("EndError");
        this.assertNodeTriggered(processInstance.getStringId(), "start", "task");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(3);
    }

    @Test
    public void testErrorVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("error/ErrorVariable.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new WorkItemExecutionErrorWorkItemHandler("MY_ERROR"));
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ErrorVariable");
        Object theException = processInstance.getVariables().get("theException");
        Assertions.assertThat(theException).isInstanceOf(WorkItemExecutionException.class);
    }

    class WorkItemExecutionErrorWorkItemHandler
    implements KogitoWorkItemHandler {
        private final String errorCode;

        public WorkItemExecutionErrorWorkItemHandler() {
            this("500");
        }

        public WorkItemExecutionErrorWorkItemHandler(String errorCode) {
            this.errorCode = errorCode;
        }

        public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            throw new WorkItemExecutionException(this.errorCode);
        }

        public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        }
    }

    class ExceptionWorkItemHandler
    implements KogitoWorkItemHandler {
        ExceptionWorkItemHandler() {
        }

        public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
            throw new RuntimeException();
        }

        public void abortWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
        }
    }
}

