/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ReceiveTaskHandler;
import org.jbpm.bpmn2.handler.SendTaskHandler;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.jbpm.bpmn2.handler.SignallingTaskHandlerDecorator;
import org.jbpm.bpmn2.objects.ExceptionService;
import org.jbpm.bpmn2.objects.Person;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.jbpm.test.util.ProcessCompletedCountDownProcessEventListener;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.Resource;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.Policy;
import org.w3c.dom.Document;

public class StandaloneBPMNProcessTest
extends JbpmBpmn2TestCase {
    @Test
    public void testMinimalProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMinimalProcessWithGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessWithGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMinimalProcessWithDIGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MinimalProcessWithDIGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Minimal");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testCompositeProcessWithDIGraphical() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CompositeProcessWithDIGraphical.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Composite");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testScriptTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ScriptTask.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ScriptTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testDataObject() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-DataObject.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EvaluationProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("RegisterRequest", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EvaluationProcess2.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "UserId-12345");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEvaluationProcess3() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EvaluationProcess3.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("RegisterRequest", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("employee", "john2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Evaluation", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testUserTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String varId = "s";
        String varValue = "initialValue";
        params.put(varId, varValue);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testLane() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-Lane.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        HashMap results = new HashMap();
        ((HumanTaskWorkItemImpl)workItem).setActualOwner("mary");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), results, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("SwimlaneActorId")).isEqualTo((Object)"mary");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitDefault.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplit.bpmn2");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitDefault.bpmn2");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    @Disabled
    public void testExclusiveSplitXPath() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitXPath.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<myDocument><chapter1>BlaBla</chapter1><chapter2>MoreBlaBla</chapter2></myDocument>".getBytes()));
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("x", document);
        params.put("y", "SomeString");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testEventBasedSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testEventBasedSplitBefore() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
    }

    @Test
    public void testEventBasedSplitAfter() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.signalEvent("No", (Object)"NoValue", processInstance.getStringId());
    }

    @Test
    @Timeout(value=10L)
    public void testEventBasedSplit2() throws Exception {
        ProcessCompletedCountDownProcessEventListener countDownListener = new ProcessCompletedCountDownProcessEventListener(2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit2.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Disabled(value="process does not complete")
    public void testEventBasedSplit3() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit3.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        Person jack = new Person();
        jack.setName("Jack");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("Yes", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKieSession().insert((Object)jack);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testEventBasedSplit4() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit4.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.signalEvent("Message-YesMessage", (Object)"YesValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        processInstance = this.kruntime.startProcess("com.sample.test");
        this.kruntime.signalEvent("Message-NoMessage", (Object)"NoValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testEventBasedSplit5() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-EventBasedSplit5.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email1", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        receiveTaskHandler.setKnowledgeRuntime(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        processInstance = this.kruntime.startProcess("com.sample.test");
        receiveTaskHandler.messageReceived("NoMessage", (Object)"NoValue");
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        receiveTaskHandler.messageReceived("YesMessage", (Object)"YesValue");
    }

    @Test
    public void testCallActivity() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-CallActivity.bpmn2", "BPMN2-CallActivitySubProcess.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "oldValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ParentProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
        Assertions.assertThat((Object)((KogitoWorkflowProcessInstance)processInstance).getVariable("y")).isEqualTo((Object)"new value");
    }

    @Test
    public void testSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SubProcess.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testErrorBoundaryEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorBoundaryEventInterrupting.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ErrorBoundaryEvent");
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEvent() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ProcessCompletedCountDownProcessEventListener processEventListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventDuration.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)processEventListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        processEventListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testTimerBoundaryEventInterrupting() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("TimerEvent", 1);
        ProcessCompletedCountDownProcessEventListener processEventListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerBoundaryEventInterrupting.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)processEventListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("MyTask", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("TimerBoundaryEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        processEventListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Disabled(value="Process does not complete.")
    public void testAdHocSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-AdHocSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("AdHocSubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNull();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKieSession().fireAllRules();
        this.kruntime.signalEvent("Hello2", null, processInstance.getStringId());
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Disabled(value="Process does not complete.")
    public void testAdHocSubProcessAutoComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-AdHocSubProcessAutoComplete.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("AdHocSubProcess");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNull();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKieSession().fireAllRules();
        workItem = workItemHandler.getWorkItem();
        ((ObjectAssert)Assertions.assertThat((Object)workItem).withFailMessage("KogitoWorkItem should not be null.", new Object[0])).isNotNull();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventSignal() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignal.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.signalEvent("MyMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testIntermediateCatchEventMessage() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventMessage.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"SomeValue", processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Timeout(value=10L)
    public void testIntermediateCatchEventTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        ProcessCompletedCountDownProcessEventListener processEventListener = new ProcessCompletedCountDownProcessEventListener();
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventTimerDuration.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)processEventListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        countDownListener.waitTillCompleted();
        processEventListener.waitTillCompleted();
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Disabled(value="process does not complete")
    public void testIntermediateCatchEventCondition() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventCondition.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        Person person = new Person();
        person.setName("Jack");
        this.kruntime.getKieSession().insert((Object)person);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testErrorEndEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ErrorEndEvent.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("ErrorEndEvent");
        this.assertProcessInstanceAborted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ServiceProcess.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new ServiceTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ServiceProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        Assertions.assertThat((Object)processInstance.getVariable("s")).isEqualTo((Object)"Hello john!");
    }

    @Test
    public void testSendTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SendTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("s", "john");
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("SendTask", params);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    public void testReceiveTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ReceiveTask.bpmn2");
        ReceiveTaskHandler receiveTaskHandler = new ReceiveTaskHandler(this.kruntime);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)receiveTaskHandler);
        KogitoWorkflowProcessInstance processInstance = (KogitoWorkflowProcessInstance)this.kruntime.startProcess("ReceiveTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        receiveTaskHandler.messageReceived("HelloMessage", (Object)"Hello john!");
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }

    @Test
    @Disabled(value="bpmn does not compile")
    public void testConditionalStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ConditionalStart.bpmn2");
        Person person = new Person();
        person.setName("jack");
        this.kruntime.getKieSession().insert((Object)person);
        this.kruntime.getKieSession().fireAllRules();
        person = new Person();
        person.setName("john");
        this.kruntime.getKieSession().insert((Object)person);
        this.kruntime.getKieSession().fireAllRules();
    }

    @Test
    @Timeout(value=1000L)
    public void testTimerStart() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("StartProcess", 5);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-TimerStart.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        Assertions.assertThat(list).isEmpty();
        countDownListener.waitTillCompleted();
        Assertions.assertThat(list).hasSize(5);
    }

    @Test
    public void testSignalStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalStart.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("MySignal", (Object)"NewValue");
        Assertions.assertThat(list).hasSize(1);
    }

    @Test
    public void testSignalEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-SignalEndEvent.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        this.kruntime.startProcess("SignalEndEvent", params);
    }

    @Test
    public void testMessageStart() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MessageStart.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        this.kruntime.signalEvent("Message-HelloMessage", (Object)"NewValue");
        Assertions.assertThat(list).hasSize(1);
    }

    @Test
    public void testMessageEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MessageEndEvent.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageEndEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testMessageIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventMessage.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new SendTaskHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MessageIntermediateEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testSignalIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventSignal.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "MyValue");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("SignalIntermediateEvent", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testNoneIntermediateThrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateThrowEventNone.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("NoneIntermediateEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testErrorSignallingExceptionServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionServiceProcess-ErrorSignalling.bpmn2");
        StandaloneBPMNProcessTest.runTestErrorSignallingExceptionServiceTask(this.kruntime);
    }

    public static void runTestErrorSignallingExceptionServiceTask(KogitoProcessRuntime kruntime) throws Exception {
        String eventType = "Error-code";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        KogitoProcessInstance processInstance = kruntime.startProcess("ServiceProcess", params);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        ((AbstractBooleanAssert)Assertions.assertThat((caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof KogitoWorkItem ? 1 : 0) != 0).withFailMessage("Event was not passed to Event Subprocess.", new Object[0])).isTrue();
        workItem = (KogitoWorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        ((ObjectAssert)Assertions.assertThat((Object)throwObj).withFailMessage("KogitoWorkItem doesn't contain Throwable.", new Object[0])).isInstanceOf(Throwable.class);
        ((AbstractStringAssert)Assertions.assertThat((String)((Throwable)throwObj).getMessage()).withFailMessage("Exception message does not match service input.", new Object[0])).endsWith((CharSequence)input);
        processInstance = kruntime.getProcessInstance(processInstance.getStringId());
        ((AbstractBooleanAssert)Assertions.assertThat((processInstance == null || processInstance.getState() == 3 ? 1 : 0) != 0).withFailMessage("Process instance has not been aborted.", new Object[0])).isTrue();
    }

    @Test
    public void testSignallingExceptionServiceTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionServiceProcess-Signalling.bpmn2");
        StandaloneBPMNProcessTest.runTestSignallingExceptionServiceTask(this.kruntime);
    }

    @Test
    public void testXXEProcessVulnerability() throws Exception {
        Resource processResource = ResourceFactory.newClassPathResource((String)"xxe-protection/BPMN2-XXE-Process.bpmn2");
        File dtdFile = new File("src/test/resources/xxe-protection/external.dtd");
        Assertions.assertThat((File)dtdFile).exists();
        String dtdContent = new String(Files.readAllBytes(dtdFile.toPath()));
        dtdContent = dtdContent.replaceAll("@@PATH@@", dtdFile.getParentFile().getAbsolutePath());
        Files.write(dtdFile.toPath(), dtdContent.getBytes("UTF-8"), new OpenOption[0]);
        byte[] data = Files.readAllBytes(Paths.get(this.getClass().getResource("/xxe-protection/BPMN2-XXE-Process.bpmn2").getPath(), new String[0]));
        String processAsString = new String(data, "UTF-8");
        File testFiles = new File("src/test/resources/xxe-protection");
        Assertions.assertThat((File)testFiles).exists();
        String path = testFiles.getAbsolutePath();
        processAsString = processAsString.replaceAll("@@PATH@@", path);
        Resource resource = ResourceFactory.newReaderResource((Reader)new StringReader(processAsString));
        resource.setSourcePath(processResource.getSourcePath());
        resource.setTargetPath(processResource.getTargetPath());
        this.kruntime = this.createKogitoProcessRuntime(resource);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("async-examples.bp1");
        String var1 = this.getProcessVarValue(processInstance, "testScript1");
        String var2 = this.getProcessVarValue(processInstance, "testScript2");
        Assertions.assertThat((String)var1).isNull();
        Assertions.assertThat((String)var2).isNull();
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
    }

    @Test
    public void testVariableRefInIntermediateThrowEvent() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-WorkingMessageModel.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Send Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("messageContent", "some text");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("workingMessageModel", parameters);
        Assertions.assertThat((Object)processInstance).isNotNull();
    }

    public static void runTestSignallingExceptionServiceTask(KogitoProcessRuntime kruntime) throws Exception {
        String eventType = "exception-signal";
        SignallingTaskHandlerDecorator signallingTaskWrapper = new SignallingTaskHandlerDecorator(ServiceTaskHandler.class, eventType);
        signallingTaskWrapper.setWorkItemExceptionParameterName(ExceptionService.exceptionParameterName);
        kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)signallingTaskWrapper);
        Object[] caughtEventObjectHolder = new Object[]{null};
        ExceptionService.setCaughtEventObjectHolder(caughtEventObjectHolder);
        HashMap<String, String> params = new HashMap<String, String>();
        String input = "this is my service input";
        params.put("serviceInputItem", input);
        KogitoProcessInstance processInstance = kruntime.startProcess("ServiceProcess", params);
        ((AbstractBooleanAssert)Assertions.assertThat((caughtEventObjectHolder[0] != null && caughtEventObjectHolder[0] instanceof KogitoWorkItem ? 1 : 0) != 0).withFailMessage("Event was not passed to Event Subprocess.", new Object[0])).isTrue();
        KogitoWorkItem workItem = (KogitoWorkItem)caughtEventObjectHolder[0];
        Object throwObj = workItem.getParameter(ExceptionService.exceptionParameterName);
        ((ObjectAssert)Assertions.assertThat((Object)throwObj).withFailMessage("KogitoWorkItem doesn't contain Throwable.", new Object[0])).isInstanceOf(Throwable.class);
        ((AbstractStringAssert)Assertions.assertThat((String)((Throwable)throwObj).getMessage()).withFailMessage("Exception message does not match service input.", new Object[0])).endsWith((CharSequence)input);
        ((AbstractIntegerAssert)Assertions.assertThat((int)processInstance.getState()).withFailMessage("Process instance is not active.", new Object[0])).isEqualTo(1);
        kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        processInstance = kruntime.getProcessInstance(processInstance.getStringId());
        if (processInstance != null) {
            ((AbstractIntegerAssert)Assertions.assertThat((int)processInstance.getState()).withFailMessage("Process instance is not completed.", new Object[0])).isEqualTo(2);
        }
    }
}

