/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.drools.io.ClassPathResource;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.Resource;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;

public class VariableTagsTest
extends JbpmBpmn2TestCase {
    @Test
    public void testProcessWithMissingRequiredVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("variable-tags/approval-with-required-variable-tags.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.kruntime.startProcess("approvals"));
    }

    @Test
    public void testProcessWithRequiredVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("variable-tags/approval-with-required-variable-tags.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("approvals", parameters);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testProcessWithReadonlyVariable() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("variable-tags/approval-with-readonly-variable-tags.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("approvals", parameters);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), Collections.singletonMap("ActorId", "john"), new Policy[0]));
        this.kruntime.abortProcessInstance(processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testProcessWithCustomVariableTag() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("variable-tags/approval-with-custom-variable-tags.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeVariableChanged(ProcessVariableChangedEvent event) {
                if (event.hasTag("onlyAdmin")) {
                    throw new VariableViolationException(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), event.getVariableId(), "Variable can only be set by admins");
                }
            }
        });
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("approver", "john");
        Assertions.assertThatExceptionOfType(VariableViolationException.class).isThrownBy(() -> this.kruntime.startProcess("approvals", parameters));
    }

    @Test
    public void testRequiredVariableFiltering() {
        List processes = BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("variable-tags/approval-with-custom-variable-tags.bpmn2")});
        BpmnProcess process = (BpmnProcess)processes.get(0);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("approver", "john");
        ProcessInstance instance = process.createInstance(BpmnVariables.create(params));
        instance.start();
        Assertions.assertThat((int)instance.status()).isEqualTo(1);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap()).hasSize(1);
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.OUTPUTS_ONLY)).isEmpty();
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INPUTS_ONLY)).isEmpty();
        Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(BpmnVariables.INTERNAL_ONLY)).isEmpty();
        ((MapAssert)Assertions.assertThat((Map)((BpmnVariables)instance.variables()).toMap(v -> v.hasTag("onlyAdmin"))).hasSize(1)).containsEntry((Object)"approver", (Object)"john");
        instance.abort();
        Assertions.assertThat((int)instance.status()).isEqualTo(3);
    }
}

