/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.bpmn2.core.IntermediateLink;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.MalformedNodeException;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.impl.DataAssociation;
import org.jbpm.workflow.core.impl.IOSpecification;
import org.jbpm.workflow.core.impl.NodeImpl;
import org.jbpm.workflow.core.node.CatchLinkNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.StateNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediateCatchEventHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new EventNode();
    }

    public Class<EventNode> generateNodeFor() {
        return EventNode.class;
    }

    @Override
    protected Node handleNode(Node newNode, Element element, String uri, String localName, Parser parser) throws SAXException {
        NodeImpl node = (NodeImpl)newNode;
        IOSpecification ioSpecification = this.readCatchSpecification(parser, element);
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("signalEventDefinition".equals(nodeName)) {
                this.setCatchVariable(ioSpecification, (Node)node);
                this.handleSignalNode((Node)node, element, uri, localName, parser);
                node.setMetaData("EventType", (Object)"signal");
                break;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                this.setCatchVariable(ioSpecification, (Node)node);
                this.handleMessageNode((Node)node, element, uri, localName, parser);
                node.setMetaData("EventType", (Object)"message");
                break;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                TimerNode timerNode = new TimerNode();
                timerNode.setId(node.getId());
                timerNode.setName(node.getName());
                timerNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = timerNode;
                this.setCatchVariable(ioSpecification, (Node)node);
                node.setMetaData("EventType", (Object)"Timer");
                this.handleTimerNode((Node)node, element, uri, localName, parser);
                break;
            }
            if ("conditionalEventDefinition".equals(nodeName)) {
                StateNode stateNode = new StateNode();
                stateNode.setId(node.getId());
                stateNode.setName(node.getName());
                stateNode.setMetaData("UniqueId", node.getMetaData().get("UniqueId"));
                node = stateNode;
                this.setCatchVariable(ioSpecification, (Node)node);
                node.setMetaData("EventType", (Object)"conditional");
                this.handleStateNode((Node)node, element, uri, localName, parser);
                break;
            }
            if (!"linkEventDefinition".equals(nodeName)) continue;
            CatchLinkNode linkNode = new CatchLinkNode();
            linkNode.setId(node.getId());
            node = linkNode;
            this.setCatchVariable(ioSpecification, (Node)node);
            node.setMetaData("EventType", (Object)"link");
            this.handleLinkNode(element, (Node)node, xmlNode, parser);
            break;
        }
        return node;
    }

    protected void handleLinkNode(Element element, Node node, org.w3c.dom.Node xmlLinkNode, Parser parser) {
        List<IntermediateLink> links;
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        node.setName(element.getAttribute("name"));
        NamedNodeMap linkAttr = xmlLinkNode.getAttributes();
        String name = linkAttr.getNamedItem("name").getNodeValue();
        String id = element.getAttribute("id");
        node.setMetaData("UniqueId", (Object)id);
        node.setMetaData("LinkName", (Object)name);
        IntermediateLink aLink = new IntermediateLink();
        aLink.setName(name);
        aLink.setUniqueId(id);
        for (org.w3c.dom.Node xmlNode = xmlLinkNode.getFirstChild(); null != xmlNode; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("target".equals(nodeName)) {
                String target = xmlNode.getTextContent();
                node.setMetaData("target", (Object)target);
                aLink.setTarget(target);
            }
            if (!"source".equals(nodeName)) continue;
            String source = xmlNode.getTextContent();
            node.setMetaData("source", (Object)source);
            aLink.addSource(source);
        }
        if (nodeContainer instanceof RuleFlowProcess) {
            RuleFlowProcess process = (RuleFlowProcess)nodeContainer;
            links = (ArrayList<IntermediateLink>)process.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList<IntermediateLink>();
            }
            links.add(aLink);
            process.setMetaData("BPMN.ThrowLinks", links);
        } else if (nodeContainer instanceof CompositeNode) {
            CompositeNode subprocess = (CompositeNode)nodeContainer;
            links = (List)subprocess.getMetaData().get("BPMN.ThrowLinks");
            if (null == links) {
                links = new ArrayList();
            }
            links.add(aLink);
            subprocess.setMetaData("BPMN.ThrowLinks", links);
        }
    }

    protected void handleSignalNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            List inputs;
            String nodeName = xmlNode.getNodeName();
            if (!"signalEventDefinition".equals(nodeName)) continue;
            String type = ((Element)xmlNode).getAttribute("signalRef");
            if (type != null && type.trim().length() > 0) {
                type = this.checkSignalAndConvertToRealSignalNam(parser, type);
                ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
                EventTypeFilter eventFilter = new EventTypeFilter();
                eventFilter.setType(type);
                eventFilters.add(eventFilter);
                eventNode.setEventFilters(eventFilters);
            }
            if ((inputs = eventNode.getIoSpecification().getDataInputAssociation()).isEmpty()) continue;
            String signalType = ((DataAssociation)inputs.get(0)).getTarget().getType();
            eventNode.setMetaData("SignalType", (Object)signalType);
        }
    }

    protected void handleMessageNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        EventNode eventNode = (EventNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            String id = ((Element)xmlNode).getAttribute("id");
            String name = ((Element)xmlNode).getAttribute("name");
            if (!"messageEventDefinition".equals(nodeName)) continue;
            String messageRef = ((Element)xmlNode).getAttribute("messageRef");
            Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
            if (messages == null) {
                throw new ProcessParsingValidationException("No messages found");
            }
            Message message = (Message)messages.get(messageRef);
            if (message == null) {
                throw new MalformedNodeException(id, name, MessageFormat.format("Could not find message \"{0}\"", messageRef));
            }
            eventNode.setMetaData("MessageType", (Object)message.getType());
            eventNode.setMetaData("TriggerType", (Object)"ConsumeMessage");
            eventNode.setMetaData("TriggerRef", (Object)message.getName());
            ArrayList<EventTypeFilter> eventFilters = new ArrayList<EventTypeFilter>();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setCorrelationManager(((RuleFlowProcess)parser.getMetaData().get("CurrentProcessDefinition")).getCorrelationManager());
            eventFilter.setType("Message-" + message.getName());
            eventFilter.setMessageRef(message.getId());
            eventFilters.add(eventFilter);
            eventNode.setEventFilters(eventFilters);
        }
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        TimerNode timerNode = (TimerNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            Timer timer = new Timer();
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String delay;
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    int index = delay.indexOf("###");
                    if (index != -1) {
                        String period = delay.substring(index + 3);
                        delay = delay.substring(0, index);
                        timer.setPeriod(period);
                    }
                    timer.setTimeType(2);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDuration".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    timer.setTimeType(1);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    String date = subNode.getTextContent();
                    timer.setTimeType(3);
                    timer.setDate(date);
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            timerNode.setTimer(timer);
        }
    }

    protected void handleStateNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StateNode stateNode = (StateNode)node;
        block0: for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"conditionalEventDefinition".equals(nodeName)) continue;
            for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                String subnodeName = subNode.getNodeName();
                if (!"condition".equals(subnodeName)) continue;
                stateNode.setMetaData("Condition", (Object)xmlNode.getTextContent());
                continue block0;
            }
        }
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        throw new IllegalArgumentException("Writing out should be handled by specific handlers");
    }
}

