/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jbpm.bpmn2.core.Error;
import org.jbpm.bpmn2.core.Escalation;
import org.jbpm.bpmn2.core.Message;
import org.jbpm.bpmn2.core.Signal;
import org.jbpm.bpmn2.xml.AbstractNodeHandler;
import org.jbpm.bpmn2.xml.ProcessParsingValidationException;
import org.jbpm.bpmn2.xml.XmlBPMNProcessDumper;
import org.jbpm.compiler.canonical.TriggerMetaData;
import org.jbpm.compiler.xml.Parser;
import org.jbpm.compiler.xml.ProcessBuildData;
import org.jbpm.compiler.xml.compiler.XmlDumper;
import org.jbpm.process.core.correlation.CorrelationManager;
import org.jbpm.process.core.event.EventFilter;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.event.NonAcceptingEventTypeFilter;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ConstraintTrigger;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.EventTrigger;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.Trigger;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class StartEventHandler
extends AbstractNodeHandler {
    @Override
    protected Node createNode(Attributes attrs) {
        return new StartNode();
    }

    public Class generateNodeFor() {
        return StartNode.class;
    }

    @Override
    protected Node handleNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        startNode.setInterrupting(Boolean.parseBoolean(element.getAttribute("isInterrupting")));
        startNode.setIoSpecification(this.readCatchSpecification(parser, element));
        this.findTargetMappingVar(startNode.getIoSpecification().getDataOutputAssociation()).ifPresent(data -> {
            startNode.getMetaData().put("TriggerMapping", data.getLabel());
            startNode.getMetaData().put("MappingVariable", data.getLabel());
        });
        this.findSourceMappingVar(startNode.getIoSpecification().getDataOutputAssociation()).ifPresent(data -> startNode.getMetaData().put("TriggerMappingInput", data.getLabel()));
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if ("conditionalEventDefinition".equals(nodeName)) {
                String constraint = null;
                for (org.w3c.dom.Node subNode = xmlNode.getFirstChild(); subNode != null; subNode = subNode.getNextSibling()) {
                    String subnodeName = subNode.getNodeName();
                    if (!"condition".equals(subnodeName)) continue;
                    constraint = xmlNode.getTextContent();
                    break;
                }
                ConstraintTrigger trigger = new ConstraintTrigger();
                trigger.setConstraint(constraint);
                startNode.addTrigger((Trigger)trigger);
                break;
            }
            if ("signalEventDefinition".equals(nodeName)) {
                String type = ((Element)xmlNode).getAttribute("signalRef");
                if ((type = this.checkSignalAndConvertToRealSignalNam(parser, type)) != null && type.trim().length() > 0) {
                    this.addTriggerWithInMappings(startNode, type);
                }
                startNode.setMetaData("MessageType", (Object)type);
                startNode.setMetaData("TriggerType", (Object)TriggerMetaData.TriggerType.Signal.name());
                Signal signal = this.findSignalByName(parser, type);
                if (signal != null) {
                    String eventType = signal.getStructureRef();
                    startNode.setMetaData("TriggerRef", (Object)eventType);
                    continue;
                }
                startNode.setMetaData("TriggerRef", (Object)type);
                continue;
            }
            if ("messageEventDefinition".equals(nodeName)) {
                String messageRef = ((Element)xmlNode).getAttribute("messageRef");
                Map messages = (Map)((ProcessBuildData)parser.getData()).getMetaData("Messages");
                if (messages == null) {
                    throw new ProcessParsingValidationException("No messages found");
                }
                Message message = (Message)messages.get(messageRef);
                if (message == null) {
                    throw new ProcessParsingValidationException("Could not find message " + messageRef);
                }
                startNode.setMetaData("EventType", (Object)"message");
                startNode.setMetaData("MessageType", (Object)message.getType());
                startNode.setMetaData("TriggerType", (Object)TriggerMetaData.TriggerType.ConsumeMessage.name());
                startNode.setMetaData("TriggerRef", (Object)message.getName());
                this.addTriggerWithInMappings(startNode, "Message-" + message.getName(), message.getId(), ((RuleFlowProcess)parser.getMetaData().get("CurrentProcessDefinition")).getCorrelationManager());
                continue;
            }
            if ("timerEventDefinition".equals(nodeName)) {
                this.handleTimerNode((Node)startNode, element, uri, localName, parser);
                continue;
            }
            if ("errorEventDefinition".equals(nodeName)) {
                startNode.setInterrupting(true);
                String errorRef = ((Element)xmlNode).getAttribute("errorRef");
                if (errorRef == null || errorRef.trim().length() <= 0) continue;
                List errors = (List)((ProcessBuildData)parser.getData()).getMetaData("Errors");
                if (errors == null) {
                    throw new ProcessParsingValidationException("No errors found");
                }
                Error error = null;
                for (Error listError : errors) {
                    if (!errorRef.equals(listError.getId())) continue;
                    error = listError;
                }
                if (error == null) {
                    throw new ProcessParsingValidationException("Could not find error " + errorRef);
                }
                startNode.setMetaData("FaultCode", (Object)error.getErrorCode());
                startNode.setMetaData("MessageType", (Object)error.getErrorCode());
                startNode.setMetaData("TriggerRef", (Object)error.getErrorCode());
                startNode.setMetaData("TriggerType", (Object)TriggerMetaData.TriggerType.Signal.name());
                this.addTriggerWithInMappings(startNode, "Error-" + error.getErrorCode());
                continue;
            }
            if ("escalationEventDefinition".equals(nodeName)) {
                String escalationRef = ((Element)xmlNode).getAttribute("escalationRef");
                if (escalationRef == null || escalationRef.trim().length() <= 0) continue;
                Map escalations = (Map)((ProcessBuildData)parser.getData()).getMetaData("BPMN.Escalations");
                if (escalations == null) {
                    throw new ProcessParsingValidationException("No escalations found");
                }
                Escalation escalation = (Escalation)escalations.get(escalationRef);
                if (escalation == null) {
                    throw new ProcessParsingValidationException("Could not find escalation " + escalationRef);
                }
                this.addTriggerWithInMappings(startNode, "Escalation-" + escalation.getEscalationCode());
                continue;
            }
            if (!"compensateEventDefinition".equals(nodeName)) continue;
            this.handleCompensationNode(startNode, xmlNode);
        }
        if (startNode.getName() == null) {
            startNode.setName("Start");
        }
        return startNode;
    }

    private void addTriggerWithInMappings(StartNode startNode, String triggerEventType) {
        this.addTriggerWithInMappings(startNode, triggerEventType, null, null);
    }

    private void addTriggerWithInMappings(StartNode startNode, String triggerEventType, String messageRef, CorrelationManager manager) {
        EventTrigger trigger = new EventTrigger();
        EventTypeFilter eventFilter = new EventTypeFilter();
        eventFilter.setCorrelationManager(manager);
        eventFilter.setType(triggerEventType);
        eventFilter.setMessageRef(messageRef);
        trigger.addEventFilter((EventFilter)eventFilter);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            startNode.getIoSpecification().getDataOutputAssociation().forEach(da -> trigger.addInAssociation(da));
        }
        startNode.addTrigger((Trigger)trigger);
    }

    @Override
    public void writeNode(Node node, StringBuilder xmlDump, int metaDataType) {
        StartNode startNode = (StartNode)node;
        this.writeNode("startEvent", (Node)startNode, xmlDump, metaDataType);
        xmlDump.append(" isInterrupting=\"");
        if (startNode.isInterrupting()) {
            xmlDump.append("true");
        } else {
            xmlDump.append("false");
        }
        xmlDump.append("\">" + EOL);
        this.writeExtensionElements((Node)startNode, xmlDump);
        List triggers = startNode.getTriggers();
        if (triggers != null) {
            if (triggers.size() > 1) {
                throw new ProcessParsingValidationException("Multiple start triggers not supported");
            }
            Trigger trigger = (Trigger)triggers.get(0);
            if (trigger instanceof ConstraintTrigger) {
                ConstraintTrigger constraintTrigger = (ConstraintTrigger)trigger;
                if (constraintTrigger.getHeader() == null) {
                    xmlDump.append("      <conditionalEventDefinition>" + EOL);
                    xmlDump.append("        <condition xsi:type=\"tFormalExpression\" language=\"http://www.jboss.org/drools/rule\">" + constraintTrigger.getConstraint() + "</condition>" + EOL);
                    xmlDump.append("      </conditionalEventDefinition>" + EOL);
                }
            } else if (trigger instanceof EventTrigger) {
                String type;
                EventTrigger eventTrigger = (EventTrigger)trigger;
                String mapping = null;
                String nameMapping = "event";
                if (!trigger.getInMappings().isEmpty()) {
                    mapping = (String)eventTrigger.getInMappings().keySet().iterator().next();
                    nameMapping = (String)eventTrigger.getInMappings().values().iterator().next();
                } else {
                    mapping = (String)startNode.getMetaData("TriggerMapping");
                }
                if (mapping != null) {
                    xmlDump.append("      <dataOutput id=\"_" + startNode.getId() + "_Output\" name=\"" + nameMapping + "\" />" + EOL + "      <dataOutputAssociation>" + EOL + "        <sourceRef>_" + startNode.getId() + "_Output</sourceRef>" + EOL + "        <targetRef>" + mapping + "</targetRef>" + EOL + "      </dataOutputAssociation>" + EOL);
                }
                if ((type = ((EventTypeFilter)eventTrigger.getEventFilters().get(0)).getType()).startsWith("Message-")) {
                    type = type.substring(8);
                    xmlDump.append("      <messageEventDefinition messageRef=\"" + type + "\"/>" + EOL);
                } else if (type.startsWith("Error-")) {
                    type = type.substring(6);
                    String errorId = this.getErrorIdForErrorCode(type, (Node)startNode);
                    xmlDump.append("      <errorEventDefinition errorRef=\"" + XmlBPMNProcessDumper.replaceIllegalCharsAttribute(errorId) + "\"/>" + EOL);
                } else if (type.startsWith("Escalation-")) {
                    type = type.substring(11);
                    xmlDump.append("      <escalationEventDefinition escalationRef=\"" + type + "\"/>" + EOL);
                } else if (type.equals("Compensation")) {
                    xmlDump.append("      <compensateEventDefinition/>" + EOL);
                } else {
                    xmlDump.append("      <signalEventDefinition signalRef=\"" + type + "\" />" + EOL);
                }
            } else {
                throw new ProcessParsingValidationException("Unsupported trigger type " + trigger);
            }
            if (startNode.getTimer() != null) {
                Timer timer = startNode.getTimer();
                xmlDump.append("      <timerEventDefinition>" + EOL);
                if (timer != null && (timer.getDelay() != null || timer.getDate() != null)) {
                    if (timer.getTimeType() == 3) {
                        xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDate()) + "</timeDate>" + EOL);
                    } else if (timer.getTimeType() == 1) {
                        xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDuration>" + EOL);
                    } else if (timer.getTimeType() == 2) {
                        if (timer.getPeriod() != null) {
                            xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "###" + XmlDumper.replaceIllegalChars((String)timer.getPeriod()) + "</timeCycle>" + EOL);
                        } else {
                            xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeCycle>" + EOL);
                        }
                    }
                }
                xmlDump.append("      </timerEventDefinition>" + EOL);
            }
        } else if (startNode.getTimer() != null) {
            Timer timer = startNode.getTimer();
            xmlDump.append("      <timerEventDefinition>" + EOL);
            if (timer != null && (timer.getDelay() != null || timer.getDate() != null)) {
                if (timer.getTimeType() == 3) {
                    xmlDump.append("        <timeDate xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDate()) + "</timeDate>" + EOL);
                } else if (timer.getTimeType() == 1) {
                    xmlDump.append("        <timeDuration xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeDuration>" + EOL);
                } else if (timer.getTimeType() == 2) {
                    if (timer.getPeriod() != null) {
                        xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "###" + XmlDumper.replaceIllegalChars((String)timer.getPeriod()) + "</timeCycle>" + EOL);
                    } else {
                        xmlDump.append("        <timeCycle xsi:type=\"tFormalExpression\">" + XmlDumper.replaceIllegalChars((String)timer.getDelay()) + "</timeCycle>" + EOL);
                    }
                }
            }
            xmlDump.append("      </timerEventDefinition>" + EOL);
        }
        this.endNode("startEvent", xmlDump);
    }

    protected void handleTimerNode(Node node, Element element, String uri, String localName, Parser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        StartNode startNode = (StartNode)node;
        for (org.w3c.dom.Node xmlNode = element.getFirstChild(); xmlNode != null; xmlNode = xmlNode.getNextSibling()) {
            String nodeName = xmlNode.getNodeName();
            if (!"timerEventDefinition".equals(nodeName)) continue;
            Timer timer = new Timer();
            org.w3c.dom.Node subNode = xmlNode.getFirstChild();
            while (subNode instanceof Element) {
                String delay;
                String subNodeName = subNode.getNodeName();
                if ("timeCycle".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    int index = delay.indexOf("###");
                    if (index != -1) {
                        String period = delay.substring(index + 3);
                        delay = delay.substring(0, index);
                        timer.setPeriod(period);
                    } else {
                        timer.setPeriod(delay);
                    }
                    timer.setTimeType(2);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDuration".equals(subNodeName)) {
                    delay = subNode.getTextContent();
                    timer.setTimeType(1);
                    timer.setDelay(delay);
                    break;
                }
                if ("timeDate".equals(subNodeName)) {
                    String date = subNode.getTextContent();
                    timer.setTimeType(3);
                    timer.setDate(date);
                    break;
                }
                subNode = subNode.getNextSibling();
            }
            startNode.setTimer(timer);
            if (!(parser.getParent() instanceof EventSubProcessNode)) continue;
            EventTrigger trigger = new EventTrigger();
            EventTypeFilter eventFilter = new EventTypeFilter();
            eventFilter.setType("Timer-" + ((EventSubProcessNode)parser.getParent()).getId());
            trigger.addEventFilter((EventFilter)eventFilter);
            String mapping = (String)startNode.getMetaData("TriggerMapping");
            if (mapping != null) {
                trigger.addInMapping("event", mapping);
            }
            startNode.addTrigger((Trigger)trigger);
            ((EventSubProcessNode)parser.getParent()).addTimer(timer, (DroolsAction)new DroolsConsequenceAction("java", ""));
        }
    }

    protected void handleCompensationNode(StartNode startNode, org.w3c.dom.Node xmlNode) {
        if (startNode.isInterrupting()) {
            logger.warn("Compensation Event Sub-Processes [" + startNode.getMetaData("UniqueId") + "] may not be specified as interrupting: overriding attribute and setting to not-interrupting.");
        }
        startNode.setInterrupting(false);
        String activityRef = ((Element)xmlNode).getAttribute("activityRef");
        if (activityRef != null && activityRef.length() > 0) {
            logger.warn("activityRef value [" + activityRef + "] on Start Event '" + startNode.getMetaData("UniqueId") + "' ignored per the BPMN2 specification.");
        }
        EventTrigger startTrigger = new EventTrigger();
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        startTrigger.addEventFilter((EventFilter)eventFilter);
        ArrayList<EventTrigger> startTriggers = new ArrayList<EventTrigger>();
        startTriggers.add(startTrigger);
        startNode.setTriggers(startTriggers);
        String mapping = (String)startNode.getMetaData("TriggerMapping");
        if (mapping != null) {
            startNode.getIoSpecification().getDataOutputAssociation().forEach(da -> startTrigger.addInAssociation(da));
        }
    }
}

