/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.Message;
import org.jbpm.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;

public class CollaborationTest
extends JbpmBpmn2TestCase {
    @Test
    public void testBoundaryMessageCollaboration() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("collaboration/Collaboration-BoundaryMessage.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new DoNothingWorkItemHandler());
        KogitoProcessInstance pid = this.kruntime.startProcess("collaboration.BoundaryMessage", Collections.singletonMap("MessageId", "2"));
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("1", "example"), pid.getStringId());
        this.assertProcessInstanceActive(pid);
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("2", "example"), pid.getStringId());
        this.assertProcessInstanceCompleted(pid);
    }

    @Test
    public void testStartMessageCollaboration() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("collaboration/Collaboration-StartMessage.bpmn2");
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("1", "example"));
        Assertions.assertThat((int)this.getNumberOfProcessInstances("collaboration.StartMessage")).isEqualTo(1);
    }

    @Test
    public void testStartMessageCollaborationNoMatch() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("collaboration/Collaboration-StartMessage.bpmn2");
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("2", "example"));
        Assertions.assertThat((int)this.getNumberOfProcessInstances("collaboration.StartMessage")).isZero();
    }

    @Test
    public void testIntermediateMessageCollaboration() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("collaboration/Collaboration-IntermediateMessage.bpmn2");
        KogitoProcessInstance pid = this.kruntime.startProcess("collaboration.IntermediateMessage", Collections.singletonMap("MessageId", "2"));
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("1", "example"), pid.getStringId());
        this.assertProcessInstanceActive(pid);
        this.kruntime.signalEvent("Message-collaboration", (Object)new Message("2", "example"), pid.getStringId());
        this.assertProcessInstanceCompleted(pid);
    }

    @Test
    public void testInvalidIntermediateMessageCollaboration() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("collaboration/Collaboration-IntermediateMessage.bpmn2");
        KogitoProcessInstance pid = this.kruntime.startProcess("collaboration.IntermediateMessage", Collections.singletonMap("MessageId", "2"));
        Assertions.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> this.kruntime.signalEvent("Message-collaboration", (Object)new Message(null, "example"), pid.getStringId()));
        this.assertProcessInstanceActive(pid);
    }
}

