/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.drools.io.InputStreamResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.internal.builder.CompositeKnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderConfiguration;
import org.kie.internal.builder.KnowledgeBuilderError;
import org.kie.internal.builder.KnowledgeBuilderErrors;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.KnowledgeBuilderResults;
import org.kie.internal.builder.ResultSeverity;

public class DroolsDeclaredTypeSequenceFlowExpressionTest {
    @Test
    public void testDeclaredTypesInSequenceFlowDroolsExpression() {
        String drl = "package org.drools.test;declare TestFact \nvalue: Integer\nend\n";
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration());
        CompositeKnowledgeBuilder ckbuilder = kbuilder.batch();
        InputStreamResource drlResource = new InputStreamResource((InputStream)new ByteArrayInputStream(drl.getBytes(StandardCharsets.UTF_8)));
        ClassPathResource bpmn2Resource = new ClassPathResource("BPMN2-DroolsDeclaredTypeSequenceFlowExpressionTest.bpmn2");
        ckbuilder.add((Resource)drlResource, ResourceType.DRL);
        ckbuilder.add((Resource)bpmn2Resource, ResourceType.BPMN2);
        ckbuilder.build();
        if (kbuilder.hasErrors()) {
            KnowledgeBuilderErrors kbErrors = kbuilder.getErrors();
            for (KnowledgeBuilderError nextError : kbErrors) {
                Assertions.fail((String)nextError.getMessage());
            }
        }
        if (kbuilder.hasResults(new ResultSeverity[]{ResultSeverity.WARNING})) {
            KnowledgeBuilderResults kbResults = kbuilder.getResults(new ResultSeverity[]{ResultSeverity.WARNING});
            for (KnowledgeBuilderResult nextResult : kbResults) {
                Assertions.fail((String)nextResult.getMessage());
            }
        }
    }
}

