/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.Test;

public class FEELTest
extends JbpmBpmn2TestCase {
    @Test
    public void testGatewayFEEL() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-GatewayFEEL.bpmn2");
        HashMap<String, Boolean> params1 = new HashMap<String, Boolean>();
        params1.put("VA", Boolean.TRUE);
        params1.put("VB", Boolean.FALSE);
        WorkflowProcessInstance procInstance1 = (WorkflowProcessInstance)this.kruntime.startProcess("BPMN2-GatewayFEEL", params1);
        Assertions.assertThat((Object)procInstance1.getVariable("Task1")).isEqualTo((Object)"ok");
        Assertions.assertThat((Object)procInstance1.getVariable("Task2")).isEqualTo((Object)"ok");
        Assertions.assertThat((Object)procInstance1.getVariable("Task3")).isNull();
        this.assertNodeTriggered(procInstance1.getStringId(), "Task2", "VA and not(VB)");
        HashMap<String, Boolean> params2 = new HashMap<String, Boolean>();
        params2.put("VA", Boolean.FALSE);
        params2.put("VB", Boolean.TRUE);
        WorkflowProcessInstance procInstance2 = (WorkflowProcessInstance)this.kruntime.startProcess("BPMN2-GatewayFEEL", params2);
        Assertions.assertThat((Object)procInstance2.getVariable("Task1")).isEqualTo((Object)"ok");
        Assertions.assertThat((Object)procInstance2.getVariable("Task2")).isNull();
        Assertions.assertThat((Object)procInstance2.getVariable("Task3")).isEqualTo((Object)"ok");
        this.assertNodeTriggered(procInstance2.getStringId(), "Task3", "VB or not(VA)");
    }

    @Test
    public void testGatewayFEELWrong() {
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> this.createKogitoProcessRuntime("BPMN2-GatewayFEEL-wrong.bpmn2")).withMessageContaining("Invalid FEEL expression: 'VA and Not(VB)'").withMessageContaining("Invalid FEEL expression: 'VB or nOt(VA)'");
    }
}

