/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.kiesession.audit.LogEvent;
import org.drools.kiesession.audit.RuleFlowLogEvent;
import org.drools.kiesession.audit.RuleFlowNodeLogEvent;
import org.drools.mvel.MVELSafeHelper;
import org.jbpm.bpmn2.audit.KogitoWorkingMemoryInMemoryLogger;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.Message;
import org.kie.api.conf.Option;
import org.kie.api.definition.process.Node;
import org.kie.api.event.KieRuntimeEventManager;
import org.kie.api.io.Resource;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;
import org.kie.internal.runtime.conf.ForceEagerActivationOption;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstanceContainer;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Timeout(value=3000L, unit=TimeUnit.SECONDS)
public abstract class JbpmBpmn2TestCase {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected KogitoProcessRuntime kruntime;
    protected KogitoWorkingMemoryInMemoryLogger workingMemoryLogger;

    @AfterEach
    public void disposeKogitoProcessRuntime() {
        if (this.kruntime != null && this.kruntime.getKieSession() != null) {
            this.kruntime.getKieSession().dispose();
            this.kruntime = null;
        }
    }

    @BeforeEach
    protected void logTestStartAndSetup(TestInfo testInfo) {
        this.logger.info(" >>> {} <<<", (Object)testInfo.getDisplayName());
        System.setProperty("org.jbpm.signals.defaultscope", "default");
    }

    @AfterEach
    protected void logTestEndAndSetup(TestInfo testInfo) {
        this.logger.info("Finished {}", (Object)testInfo.getDisplayName());
        System.clearProperty("org.jbpm.signals.defaultscope");
    }

    @AfterEach
    public void clear() {
        this.clearHistory();
    }

    protected KogitoProcessRuntime createKogitoProcessRuntime(String ... process) throws Exception {
        return InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.createKnowledgeSession(process));
    }

    protected KogitoProcessRuntime createKogitoProcessRuntime(Resource ... process) throws Exception {
        return InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)this.createKnowledgeSession(this.createKnowledgeBaseFromResources(process)));
    }

    private KieBase createKnowledgeBaseWithoutDumper(String ... process) throws Exception {
        Resource[] resources = new Resource[process.length];
        for (int i = 0; i < process.length; ++i) {
            String p = process[i];
            resources[i] = ResourceFactory.newClassPathResource((String)p);
        }
        return this.createKnowledgeBaseFromResources(resources);
    }

    private KieBase createKnowledgeBaseFromResources(Resource ... process) throws Exception {
        KieServices ks = KieServices.Factory.get();
        KieRepository kr = ks.getRepository();
        if (process.length > 0) {
            KieFileSystem kfs = ks.newKieFileSystem();
            for (Resource p : process) {
                kfs.write(p);
            }
            KieBuilder kb = ks.newKieBuilder(kfs);
            kb.buildAll();
            if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
                throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
            }
        }
        return ks.newKieContainer(kr.getDefaultReleaseId()).getKieBase();
    }

    private StatefulKnowledgeSession createKnowledgeSession(KieBase kbase) throws Exception {
        Environment env = EnvironmentFactory.newEnvironment();
        Properties defaultProps = new Properties();
        defaultProps.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        defaultProps.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        KieSessionConfiguration conf = KieServices.get().newKieSessionConfiguration(defaultProps);
        conf.setOption((Option)ForceEagerActivationOption.YES);
        StatefulKnowledgeSession result = (StatefulKnowledgeSession)kbase.newKieSession(conf, env);
        this.workingMemoryLogger = new KogitoWorkingMemoryInMemoryLogger((KieRuntimeEventManager)result);
        return result;
    }

    private StatefulKnowledgeSession createKnowledgeSession(String ... process) throws Exception {
        KieBase kbase = this.createKnowledgeBaseWithoutDumper(process);
        return this.createKnowledgeSession(kbase);
    }

    public void assertProcessInstanceCompleted(KogitoProcessInstance processInstance) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.assertProcessInstanceState(2, processInstance)).as("Process instance has not been completed.", new Object[0])).isTrue();
    }

    public void assertProcessInstanceAborted(KogitoProcessInstance processInstance) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.assertProcessInstanceState(3, processInstance)).as("Process instance has not been aborted.", new Object[0])).isTrue();
    }

    public void assertProcessInstanceActive(KogitoProcessInstance processInstance) {
        ((AbstractBooleanAssert)Assertions.assertThat((this.assertProcessInstanceState(1, processInstance) || this.assertProcessInstanceState(0, processInstance) ? 1 : 0) != 0).as("Process instance is not active.", new Object[0])).isTrue();
    }

    public void assertProcessInstanceFinished(KogitoProcessInstance processInstance, KogitoProcessRuntime kruntime) {
        ((ObjectAssert)Assertions.assertThat((Object)kruntime.getProcessInstance(processInstance.getStringId())).as("Process instance has not been finished.", new Object[0])).isNull();
    }

    public void assertNodeActive(String processInstanceId, KogitoProcessRuntime kruntime, String ... name) {
        ArrayList<String> names = new ArrayList<String>();
        for (String n : name) {
            names.add(n);
        }
        KogitoProcessInstance processInstance = kruntime.getProcessInstance(processInstanceId);
        if (processInstance instanceof KogitoWorkflowProcessInstance) {
            this.assertNodeActive((KogitoNodeInstanceContainer)((KogitoWorkflowProcessInstance)processInstance), names);
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) not active: " + (String)s));
        }
    }

    private void assertNodeActive(KogitoNodeInstanceContainer container, List<String> names) {
        for (KogitoNodeInstance nodeInstance : container.getKogitoNodeInstances()) {
            String nodeName = nodeInstance.getNodeName();
            if (names.contains(nodeName)) {
                names.remove(nodeName);
            }
            if (!(nodeInstance instanceof KogitoNodeInstanceContainer)) continue;
            this.assertNodeActive((KogitoNodeInstanceContainer)nodeInstance, names);
        }
    }

    public void assertNodeTriggered(String processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(nodeNames);
        if (!names.isEmpty()) {
            Object s = names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + names.get(i);
            }
            Assertions.fail((String)("Node(s) not executed: " + (String)s));
        }
    }

    public void assertNotNodeTriggered(String processInstanceId, String ... nodeNames) {
        List<String> names = this.getNotTriggeredNodes(nodeNames);
        Assertions.assertThat(names).containsExactly((Object[])nodeNames);
    }

    public int getNumberOfProcessInstances(String processId) {
        LogEvent[] events;
        int counter = 0;
        for (LogEvent event : events = this.workingMemoryLogger.getLogEvents().toArray(new LogEvent[0])) {
            if (event.getType() != 8 || !((RuleFlowLogEvent)event).getProcessId().equals(processId)) continue;
            ++counter;
        }
        return counter;
    }

    protected boolean assertProcessInstanceState(int state, KogitoProcessInstance processInstance) {
        return processInstance.getState() == state;
    }

    private List<String> getNotTriggeredNodes(String ... nodeNames) {
        Set triggeredNodes = this.workingMemoryLogger.getLogEvents().stream().filter(e -> e instanceof RuleFlowNodeLogEvent).map(e -> ((RuleFlowNodeLogEvent)e).getNodeName()).collect(Collectors.toSet());
        return Arrays.stream(nodeNames).filter(n -> !triggeredNodes.contains(n)).collect(Collectors.toList());
    }

    protected void clearHistory() {
        if (this.workingMemoryLogger != null) {
            this.workingMemoryLogger.clear();
        }
    }

    public void assertProcessVarExists(KogitoProcessInstance process, String ... processVarNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String nodeName : processVarNames) {
            names.add(nodeName);
        }
        for (String pvar : instance.getVariables().keySet()) {
            if (!names.contains(pvar)) continue;
            names.remove(pvar);
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Process Variable(s) do not exist: " + (String)s));
        }
    }

    public String getProcessVarValue(KogitoProcessInstance processInstance, String varName) {
        String actualValue = null;
        Object value = ((WorkflowProcessInstanceImpl)processInstance).getVariable(varName);
        if (value != null) {
            actualValue = value.toString();
        }
        return actualValue;
    }

    public void assertProcessVarValue(KogitoProcessInstance processInstance, String varName, Object varValue) {
        String actualValue = this.getProcessVarValue(processInstance, varName);
        ((AbstractStringAssert)Assertions.assertThat((String)actualValue).as("Variable " + varName + " value misatch!", new Object[0])).isEqualTo(varValue);
    }

    public void assertNodeExists(KogitoProcessInstance process, String ... nodeNames) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        ArrayList<String> names = new ArrayList<String>();
        for (String string : nodeNames) {
            names.add(string);
        }
        for (String string : instance.getNodeContainer().getNodes()) {
            if (!names.contains(string.getName())) continue;
            names.remove(string.getName());
        }
        if (!names.isEmpty()) {
            Object s = (String)names.get(0);
            for (int i = 1; i < names.size(); ++i) {
                s = (String)s + ", " + (String)names.get(i);
            }
            Assertions.fail((String)("Node(s) do not exist: " + (String)s));
        }
    }

    public void assertNumOfIncommingConnections(KogitoProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getIncomingConnections().size() == num) break;
            Assertions.fail((String)("Expected incomming connections: " + num + " - found " + node.getIncomingConnections().size()));
        }
    }

    public void assertNumOfOutgoingConnections(KogitoProcessInstance process, String nodeName, int num) {
        this.assertNodeExists(process, nodeName);
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        for (Node node : instance.getNodeContainer().getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            if (node.getOutgoingConnections().size() == num) break;
            Assertions.fail((String)("Expected outgoing connections: " + num + " - found " + node.getOutgoingConnections().size()));
        }
    }

    public void assertVersionEquals(KogitoProcessInstance process, String version) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getVersion().equals(version)) {
            Assertions.fail((String)("Expected version: " + version + " - found " + instance.getWorkflowProcess().getVersion()));
        }
    }

    public void assertProcessNameEquals(KogitoProcessInstance process, String name) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getName().equals(name)) {
            Assertions.fail((String)("Expected name: " + name + " - found " + instance.getWorkflowProcess().getName()));
        }
    }

    public void assertPackageNameEquals(KogitoProcessInstance process, String packageName) {
        WorkflowProcessInstanceImpl instance = (WorkflowProcessInstanceImpl)process;
        if (!instance.getWorkflowProcess().getPackageName().equals(packageName)) {
            Assertions.fail((String)("Expected package name: " + packageName + " - found " + instance.getWorkflowProcess().getPackageName()));
        }
    }

    public Object eval(Reader reader, Map vars) {
        try {
            return this.eval(this.toString(reader), vars);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception Thrown", e);
        }
    }

    private String toString(Reader reader) throws IOException {
        int charValue;
        StringBuilder sb = new StringBuilder(1024);
        while ((charValue = reader.read()) != -1) {
            sb.append((char)charValue);
        }
        return sb.toString();
    }

    public Object eval(String str, Map vars) {
        ParserContext context = new ParserContext();
        context.addPackageImport("org.jbpm.task");
        context.addPackageImport("org.jbpm.task.service");
        context.addPackageImport("org.jbpm.task.query");
        context.addPackageImport("java.util");
        vars.put("now", new Date());
        return MVELSafeHelper.getEvaluator().executeExpression((Object)MVEL.compileExpression((String)str, (ParserContext)context), vars);
    }

    protected void assertProcessInstanceCompleted(String processInstanceId, KogitoProcessRuntime kruntime) {
        KogitoProcessInstance processInstance = kruntime.getProcessInstance(processInstanceId);
        ((ObjectAssert)Assertions.assertThat((Object)processInstance).as("Process instance has not completed.", new Object[0])).isNull();
    }

    protected void assertProcessInstanceAborted(String processInstanceId, KogitoProcessRuntime kruntime) {
        Assertions.assertThat((Object)kruntime.getProcessInstance(processInstanceId)).isNull();
    }

    protected void assertProcessInstanceActive(String processInstanceId, KogitoProcessRuntime kruntime) {
        Assertions.assertThat((Object)kruntime.getProcessInstance(processInstanceId)).isNotNull();
    }
}

