/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.NodeInstance;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.Policy;

public class SLAComplianceTest
extends JbpmBpmn2TestCase {
    @Test
    public void testSLAonProcessViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA was not violated while it is expected", new Object[0])).isTrue();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonProcessMet() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(2);
    }

    @Test
    public void testSLAonUserTaskViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA was not violated while it is expected", new Object[0])).isTrue();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertThat((Collection)active).hasSize(1);
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonUserTaskMet() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertThat((Collection)active).hasSize(1);
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertThat((int)slaCompliance).isEqualTo(2);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertThat((int)slaCompliance).isEqualTo(2);
    }

    @Test
    public void testSLAonProcessViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA should not violated by timer", new Object[0])).isFalse();
        this.kruntime.signalEvent("slaViolation", null, processInstance.getStringId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA was not violated while it is expected", new Object[0])).isTrue();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonUserTaskViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA should not violated by timer", new Object[0])).isFalse();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertThat((Collection)active).hasSize(1);
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("slaViolation:" + userTaskNode.getStringId(), null, processInstance.getStringId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA was not violated while it is expected", new Object[0])).isTrue();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonProcessViolatedWithExpression() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAExpr.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "3s");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask", parameters);
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA was not violated while it is expected", new Object[0])).isTrue();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonProcessViolatedNoTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Object)workItem.getParameter("ActorId")).isEqualTo((Object)"john");
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA should not violated by timer", new Object[0])).isFalse();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(1);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonCatchEventViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA should be violated by timer", new Object[0])).isTrue();
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertThat((Collection)active).hasSize(1);
        KogitoNodeInstance eventNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("MyMessage", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 0);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 1);
        Assertions.assertThat((int)slaCompliance).isEqualTo(3);
    }

    @Test
    public void testSLAonCatchEventNotViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(1);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertThat((Collection)active).hasSize(1);
        KogitoNodeInstance eventNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("MyMessage", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertThat((int)slaCompliance).isEqualTo(0);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 1);
        Assertions.assertThat((int)slaCompliance).isEqualTo(2);
        boolean slaViolated = latch.await(3L, TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)slaViolated).as("SLA should not violated by timer", new Object[0])).isFalse();
    }

    private int getSLAComplianceForProcessInstance(KogitoProcessInstance processInstance) {
        int slaCompliance = ((ProcessInstance)processInstance).getSlaCompliance();
        return slaCompliance;
    }

    private int getSLAComplianceForNodeInstance(String processInstanceId, NodeInstance nodeInstance, int logType) {
        int slaCompliance = nodeInstance.getSlaCompliance();
        return slaCompliance;
    }
}

