/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.concurrency;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.objects.Status;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled(value="This test costs time and resources, please only run locally for the time being.")
public class MultipleProcessesPerThreadTest {
    private static final int LOOPS = 1000;
    private static final Logger logger = LoggerFactory.getLogger(MultipleProcessesPerThreadTest.class);

    @Test
    public void doMultipleProcessesInMultipleThreads() {
        HelloWorldProcessThread hello = new HelloWorldProcessThread();
        UserTaskProcessThread user = new UserTaskProcessThread();
        hello.start();
        user.start();
        try {
            hello.join();
            user.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Object)hello.status)).as("Hello World process thread did not complete successfully", new Object[0])).isSameAs((Object)Status.SUCCESS);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Object)user.status)).as("User Task process thread did not complete successfully", new Object[0])).isSameAs((Object)Status.SUCCESS);
    }

    private static class CompleteProcessListener
    implements ProcessEventListener {
        private volatile CountDownLatch guard;

        public CompleteProcessListener(CountDownLatch guard) {
            this.guard = guard;
        }

        public void beforeProcessStarted(ProcessStartedEvent event) {
        }

        public void afterProcessStarted(ProcessStartedEvent event) {
        }

        public void beforeProcessCompleted(ProcessCompletedEvent event) {
        }

        public void afterProcessCompleted(ProcessCompletedEvent event) {
            this.guard.countDown();
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
        }

        public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        }

        public void afterVariableChanged(ProcessVariableChangedEvent event) {
        }
    }

    private static class UserTaskProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private UserTaskProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            this.status = Status.SUCCESS;
            KogitoProcessRuntime kruntime = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Task.bpmn", this.getClass()), ResourceType.BPMN2);
                kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbuilder.newKieBase().newKieSession());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
            kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting user task process, loop {}/{}", (Object)i, (Object)1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
                try {
                    kruntime.startProcess("user-task");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List<KogitoWorkItem> items = workItemHandler.getWorkItems();
                for (KogitoWorkItem item : items) {
                    try {
                        kruntime.getKogitoWorkItemManager().completeWorkItem(item.getStringId(), null, new Policy[0]);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                try {
                    this.latch.await(1L, TimeUnit.MINUTES);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }

    private static class HelloWorldProcessThread
    implements Runnable {
        private Thread thread;
        volatile Status status;
        private volatile CountDownLatch latch;

        private HelloWorldProcessThread() {
        }

        public void start() {
            this.thread = new Thread(this);
            this.thread.start();
        }

        @Override
        public void run() {
            this.status = Status.SUCCESS;
            KogitoProcessRuntime kruntime = null;
            try {
                KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
                kbuilder.add(ResourceFactory.newClassPathResource((String)"BPMN2-MultiThreadServiceProcess-Timer.bpmn", this.getClass()), ResourceType.BPMN2);
                kruntime = InternalProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)kbuilder.newKieBase().newKieSession());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Unable to set up knowlede base or session.", (Throwable)e);
                this.status = Status.FAIL;
            }
            for (int i = 1; i <= 1000; ++i) {
                logger.debug("Starting hello world process, loop {}/{}", (Object)i, (Object)1000);
                this.latch = new CountDownLatch(1);
                CompleteProcessListener listener = new CompleteProcessListener(this.latch);
                kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
                try {
                    kruntime.startProcess("hello-world");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    this.latch.await(1L, TimeUnit.MINUTES);
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }

        public synchronized void join() throws InterruptedException {
            this.thread.join();
        }
    }
}

