/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.ArrayList;
import java.util.HashMap;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.LoggingTaskHandlerDecorator;
import org.jbpm.bpmn2.handler.ServiceTaskHandler;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;

public class LoggingTaskHandlerWrapperTest
extends JbpmBpmn2TestCase {
    @Test
    public void testLimitExceptionInfoList() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        LoggingTaskHandlerDecorator loggingTaskHandlerWrapper = new LoggingTaskHandlerDecorator(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.kruntime.startProcess("ServiceProcess", params);
        this.kruntime.startProcess("ServiceProcess", params);
        this.kruntime.startProcess("ServiceProcess", params);
        int size = loggingTaskHandlerWrapper.getWorkItemExceptionInfoList().size();
        ((AbstractIntegerAssert)Assertions.assertThat((int)size).as("WorkItemExceptionInfoList is too large: " + size, new Object[0])).isEqualTo(2);
    }

    @Test
    public void testFormatLoggingError() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExceptionThrowingServiceProcess.bpmn2");
        LoggingTaskHandlerDecorator loggingTaskHandlerWrapper = new LoggingTaskHandlerDecorator(ServiceTaskHandler.class, 2);
        loggingTaskHandlerWrapper.setLoggedMessageFormat("{0} - {1} - {2} - {3}");
        ArrayList<LoggingTaskHandlerDecorator.InputParameter> inputParameters = new ArrayList<LoggingTaskHandlerDecorator.InputParameter>();
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.EXCEPTION_CLASS);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.WORK_ITEM_ID);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.WORK_ITEM_NAME);
        inputParameters.add(LoggingTaskHandlerDecorator.InputParameter.PROCESS_INSTANCE_ID);
        loggingTaskHandlerWrapper.setLoggedMessageInput(inputParameters);
        loggingTaskHandlerWrapper.setPrintStackTrace(false);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Service Task", (KogitoWorkItemHandler)loggingTaskHandlerWrapper);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serviceInputItem", "exception message");
        this.kruntime.startProcess("ServiceProcess", params);
        this.kruntime.startProcess("ServiceProcess", params);
        this.kruntime.startProcess("ServiceProcess", params);
    }
}

