/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.rule;

import java.util.ArrayList;
import org.drools.commands.runtime.rule.FireAllRulesCommand;
import org.drools.core.event.DebugProcessEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.command.Command;
import org.kie.api.definition.type.FactType;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.DebugAgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.command.CommandFactory;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class AgendaFilterTest
extends AbstractBaseTest {
    @Test
    public void testActivationCancelled() {
        String drl = "package org.jboss.qa.brms.agendafilter\ndeclare CancelFact\n   cancel : boolean = true\nend\nrule NoCancel\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact ( cancel == false )\n   then\n       System.out.println(\"No cancel...\");\n       modify ($fact) {\n           setCancel(true);\n       }\nend\nrule PresenceOfBothFacts\n   ruleflow-group \"rfg\"\n   salience -1\n   when\n       $fact1 : CancelFact( cancel == false )\n       $fact2 : CancelFact( cancel == true )\n   then\n       System.out.println(\"Both facts!\");\nend\nrule PresenceOfFact\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact( )\n   then\n       System.out.println(\"We have a \" + ($fact.isCancel() ? \"\" : \"non-\") + \"cancelling fact!\");\nend\nrule Cancel\n   ruleflow-group \"rfg\"\n   when\n       $fact : CancelFact ( cancel == true )\n   then\n       System.out.println(\"Cancel!\");\nend";
        String rf = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> \n<process xmlns=\"http://drools.org/drools-5.0/process\"\n         xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n         type=\"RuleFlow\" name=\"flow\" id=\"bz761715\" package-name=\"org.jboss.qa.brms.agendafilter\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" x=\"16\" y=\"16\" width=\"48\" height=\"48\" />\n    <ruleSet id=\"2\" name=\"Rule\" x=\"208\" y=\"16\" width=\"80\" height=\"48\" ruleFlowGroup=\"rfg\" />\n    <actionNode id=\"3\" name=\"Script\" x=\"320\" y=\"16\" width=\"80\" height=\"48\" >\n        <action type=\"expression\" dialect=\"java\" >System.out.println(\"Finishing process...\");</action>\n    </actionNode>\n    <end id=\"4\" name=\"End\" x=\"432\" y=\"16\" width=\"48\" height=\"48\" />\n    <actionNode id=\"5\" name=\"Script\" x=\"96\" y=\"16\" width=\"80\" height=\"48\" >\n        <action type=\"expression\" dialect=\"java\" >System.out.println(\"Starting process...\");</action>\n    </actionNode>\n  </nodes>\n  <connections>\n    <connection from=\"5\" to=\"2\" />\n    <connection from=\"2\" to=\"3\" />\n    <connection from=\"3\" to=\"4\" />\n    <connection from=\"1\" to=\"5\" />\n  </connections>\n</process>";
        this.builder.add(ResourceFactory.newByteArrayResource((byte[])drl.getBytes()), ResourceType.DRL);
        this.builder.add(ResourceFactory.newByteArrayResource((byte[])rf.getBytes()), ResourceType.DRF);
        if (this.builder.hasErrors()) {
            Assertions.fail((String)this.builder.getErrors().toString());
        }
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieSession().addEventListener((AgendaEventListener)new DebugAgendaEventListener());
        kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DebugProcessEventListener());
        ArrayList<Object> commands = new ArrayList<Object>();
        commands.add(CommandFactory.newInsert((Object)this.newCancelFact(kruntime, false)));
        commands.add(CommandFactory.newInsert((Object)this.newCancelFact(kruntime, true)));
        commands.add(CommandFactory.newStartProcess((String)"bz761715"));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        commands.add(new FireAllRulesCommand((AgendaFilter)new CancelAgendaFilter()));
        kruntime.getKieSession().execute((Command)CommandFactory.newBatchExecution(commands));
    }

    private Object newCancelFact(KogitoProcessRuntime kruntime, boolean cancel) {
        FactType type = kruntime.getKieSession().getKieBase().getFactType("org.jboss.qa.brms.agendafilter", "CancelFact");
        Object instance = null;
        try {
            instance = type.newInstance();
            type.set(instance, "cancel", (Object)cancel);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            ex.printStackTrace();
        }
        return instance;
    }

    public static class CancelAgendaFilter
    implements AgendaFilter {
        public boolean accept(Match activation) {
            return !"Cancel".equals(activation.getRule().getName());
        }
    }

    public static class Message {
        private String message;
        private int status;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }
    }
}

