/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.rule;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.event.DefaultAgendaEventListener;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessFlowControlTest
extends AbstractBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ProcessFlowControlTest.class);

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testRuleFlowConstraintDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ConstraintDialects.rfm")));
        logger.error(this.builder.getErrors().toString());
        Assertions.assertThat((Object[])this.builder.getErrors().getErrors()).isEmpty();
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList<Integer> inList = new ArrayList<Integer>();
        ArrayList outList = new ArrayList();
        kruntime.getKieSession().setGlobal("inList", inList);
        kruntime.getKieSession().setGlobal("outList", outList);
        inList.add(1);
        inList.add(3);
        inList.add(6);
        inList.add(25);
        FactHandle handle = kruntime.getKieSession().insert(inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertThat(outList).hasSize(4);
        Assertions.assertThat((String)((String)outList.get(0))).isEqualTo("MVELCodeConstraint was here");
        Assertions.assertThat((String)((String)outList.get(1))).isEqualTo("JavaCodeConstraint was here");
        Assertions.assertThat((String)((String)outList.get(2))).isEqualTo("MVELRuleConstraint was here");
        Assertions.assertThat((String)((String)outList.get(3))).isEqualTo("JavaRuleConstraint was here");
        outList.clear();
        inList.remove((Object)1);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertThat(outList).hasSize(3);
        Assertions.assertThat((String)((String)outList.get(0))).isEqualTo("JavaCodeConstraint was here");
        Assertions.assertThat((String)((String)outList.get(1))).isEqualTo("MVELRuleConstraint was here");
        Assertions.assertThat((String)((String)outList.get(2))).isEqualTo("JavaRuleConstraint was here");
        outList.clear();
        inList.remove((Object)6);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertThat(outList).hasSize(2);
        Assertions.assertThat((String)((String)outList.get(0))).isEqualTo("JavaCodeConstraint was here");
        Assertions.assertThat((String)((String)outList.get(1))).isEqualTo("JavaRuleConstraint was here");
        outList.clear();
        inList.remove((Object)3);
        kruntime.getKieSession().update(handle, inList);
        kruntime.startProcess("ConstraintDialects");
        Assertions.assertThat(outList).hasSize(1);
        Assertions.assertThat((String)((String)outList.get(0))).isEqualTo("JavaRuleConstraint was here");
        outList.clear();
        inList.remove((Object)25);
        kruntime.getKieSession().update(handle, inList);
        KogitoProcessInstance processInstance = kruntime.startProcess("ConstraintDialects");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(5);
    }

    @Test
    public void testRuleFlow() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertThat(list).isEmpty();
        KogitoProcessInstance processInstance = kruntime.startProcess("0");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
        Assertions.assertThat(list).hasSize(4);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("Rule1");
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assertions.assertThat((String)((String)list.get(3))).isEqualTo("Rule4");
    }

    @Test
    public void testRuleFlowClear() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/test_ruleflowClear.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/test_ruleflowClear.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        final ArrayList activations = new ArrayList();
        DefaultAgendaEventListener listener = new DefaultAgendaEventListener(){

            public void matchCancelled(MatchCancelledEvent event) {
                activations.add(event.getMatch());
            }
        };
        kruntime.getKieSession().addEventListener((AgendaEventListener)listener);
        InternalAgenda agenda = (InternalAgenda)kruntime.getKieSession().getAgenda();
        kruntime.getKieSession().fireAllRules();
        agenda.evaluateEagerList();
        Assertions.assertThat((int)agenda.sizeOfRuleFlowGroup("flowgroup-1")).isEqualTo(4);
        Assertions.assertThat((int)((InternalAgendaGroup)agenda.getAgendaGroup("MAIN")).size()).isZero();
        Assertions.assertThat(activations).isEmpty();
        ((InternalAgenda)kruntime.getKieSession().getAgenda()).clearAndCancelRuleFlowGroup("flowgroup-1");
        Assertions.assertThat((int)((InternalAgendaGroup)agenda.getAgendaGroup("MAIN")).size()).isZero();
        Assertions.assertThat((int)agenda.sizeOfRuleFlowGroup("flowgroup-1")).isZero();
        Assertions.assertThat(activations).hasSize(4);
    }

    @Test
    public void testRuleFlowInPackage() throws Exception {
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.drl")));
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertThat(list).isEmpty();
        KogitoProcessInstance processInstance = kruntime.startProcess("0");
        Assertions.assertThat((int)processInstance.getState()).isEqualTo(2);
        Assertions.assertThat(list).hasSize(4);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("Rule1");
        list.subList(1, 2).contains("Rule2");
        list.subList(1, 2).contains("Rule3");
        Assertions.assertThat((String)((String)list.get(3))).isEqualTo("Rule4");
    }

    @Test
    public void testLoadingRuleFlowInPackage1() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.rfm")));
        this.builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.drl")));
        Assertions.assertThat((Object[])this.builder.getPackages()).isNotEmpty();
    }

    @Test
    public void testLoadingRuleFlowInPackage2() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/ruleflow.rfm")));
        Assertions.assertThat((Object[])this.builder.getPackages()).isNotEmpty();
    }

    @Test
    public void testLoadingRuleFlowInPackage3() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/empty_ruleflow.rfm")));
        Assertions.assertThat((Object[])this.builder.getPackages()).isNotEmpty();
    }

    @Test
    @Disabled(value="MVEL not supported in ScriptTask")
    public void testRuleFlowActionDialects() throws Exception {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/test_ActionDialects.rfm")));
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        kruntime.startProcess("ActionDialects");
        Assertions.assertThat(list).hasSize(2);
        Assertions.assertThat((String)((String)list.get(0))).isEqualTo("mvel was here");
        Assertions.assertThat((String)((String)list.get(1))).isEqualTo("java was here");
    }

    @Test
    public void testLoadingRuleFlowNoPackageName() {
        this.builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("/ruleflow/error_ruleflow.rfm")));
        Assertions.assertThat((Object[])this.builder.getErrors().getErrors()).hasSize(3);
    }
}

