/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.rule;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.integrationtests.test.Person;
import org.jbpm.test.util.AbstractBaseTest;
import org.junit.jupiter.api.Test;
import org.kie.api.io.ResourceType;
import org.kie.internal.io.ResourceFactory;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;

public class ProcessMarshallingTest
extends AbstractBaseTest {
    @Test
    public void testMarshallingProcessInstancesAndGlobals() {
        Object rule = "package org.test;\n";
        rule = (String)rule + "import org.jbpm.integrationtests.test.Person\n";
        rule = (String)rule + "global java.util.List list\n";
        rule = (String)rule + "rule \"Rule 1\"\n";
        rule = (String)rule + "  ruleflow-group \"hello\"\n";
        rule = (String)rule + "when\n";
        rule = (String)rule + "    $p : Person( ) \n";
        rule = (String)rule + "then\n";
        rule = (String)rule + "    list.add( $p );\n";
        rule = (String)rule + "end";
        String process = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<process xmlns=\"http://drools.org/drools-5.0/process\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xs:schemaLocation=\"http://drools.org/drools-5.0/process drools-processes-5.0.xsd\"\n    type=\"RuleFlow\" name=\"ruleflow\" id=\"org.test.ruleflow\" package-name=\"org.test\" >\n  <header>\n  </header>\n  <nodes>\n    <start id=\"1\" name=\"Start\" />\n    <ruleSet id=\"2\" name=\"Hello\" ruleFlowGroup=\"hello\" />\n    <end id=\"3\" name=\"End\" />\n  </nodes>\n  <connections>\n    <connection from=\"1\" to=\"2\"/>\n    <connection from=\"2\" to=\"3\"/>\n  </connections>\n</process>";
        this.builder.add(ResourceFactory.newReaderResource((Reader)new StringReader((String)rule)), ResourceType.DRL);
        this.builder.add(ResourceFactory.newReaderResource((Reader)new StringReader(process)), ResourceType.DRF);
        KogitoProcessRuntime kruntime = this.createKogitoProcessRuntime();
        kruntime.getKieRuntime().getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        ArrayList list = new ArrayList();
        kruntime.getKieSession().setGlobal("list", list);
        Person p = new Person("bobba fet", 32);
        kruntime.getKieSession().insert((Object)p);
        kruntime.startProcess("org.test.ruleflow");
        Assertions.assertThat((Collection)kruntime.getKieSession().getProcessInstances()).hasSize(1);
        kruntime.getKieSession().fireAllRules();
        Assertions.assertThat((List)((List)kruntime.getKieSession().getGlobal("list"))).hasSize(1);
        Assertions.assertThat(((List)kruntime.getKieSession().getGlobal("list")).get(0)).isEqualTo((Object)p);
        Assertions.assertThat((Collection)kruntime.getKieSession().getProcessInstances()).isEmpty();
    }
}

