/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.event.KogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class CompensationTest
extends JbpmBpmn2TestCase {
    private KogitoProcessEventListener LOGGING_EVENT_LISTENER = new DefaultKogitoProcessEventListener(){

        public void afterNodeLeft(ProcessNodeLeftEvent event) {
            CompensationTest.this.logger.info("After node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
            CompensationTest.this.logger.info("After node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeLeft(ProcessNodeLeftEvent event) {
            CompensationTest.this.logger.info("Before node left {}", (Object)event.getNodeInstance().getNodeName());
        }

        public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
            CompensationTest.this.logger.info("Before node triggered {}", (Object)event.getNodeInstance().getNodeName());
        }
    };

    @BeforeEach
    public void prepare() {
        this.clearHistory();
    }

    @Test
    public void compensationViaIntermediateThrowEventProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensateIntermediateThrowEvent", params);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationTwiceViaSignal() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        String processId = "CompensateIntermediateThrowEvent";
        KogitoProcessInstance processInstance = this.kruntime.startProcess(processId, params);
        this.kruntime.signalEvent("Compensation", (Object)("implicit:" + processId), processInstance.getStringId());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", "2");
    }

    @Test
    public void compensationViaEventSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-EventSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensationEventSubProcess", params);
        this.assertProcessInstanceActive(processInstance.getStringId(), this.kruntime);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationOnlyAfterAssociatedActivityHasCompleted() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-UserTaskBeforeAssociatedActivity.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)this.LOGGING_EVENT_LISTENER);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensateIntermediateThrowEvent", params);
        this.kruntime.signalEvent("Compensation", (Object)"_3", processInstance.getStringId());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void orderedCompensation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-ParallelOrderedCompensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensateParallelOrdered", params);
        List<KogitoWorkItem> workItems = workItemHandler.getWorkItems();
        ArrayList<String> workItemIds = new ArrayList<String>();
        for (KogitoWorkItem workItem : workItems) {
            if (!"Thr".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getStringId());
        }
        for (KogitoWorkItem workItem : workItems) {
            if (!"Two".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getStringId());
        }
        for (KogitoWorkItem workItem : workItems) {
            if (!"One".equals(workItem.getParameter("NodeName"))) continue;
            workItemIds.add(workItem.getStringId());
        }
        for (String id : workItemIds) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(id, null, new Policy[0]);
        }
        String xVal = this.getProcessVarValue(processInstance, "x");
        Assertions.assertThat((String)xVal).isEqualTo("_171:_131:_141:_151:");
    }

    @Test
    public void compensationInSubSubProcesses() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-InSubSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensateSubSubSub", params);
        this.kruntime.signalEvent("Compensation", (Object)"_C-2", processInstance.getStringId());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", "2");
    }

    @Test
    public void specificCompensationOfASubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-ThrowSpecificForSubProcess.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensationSpecificSubProcess", params);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", null);
    }

    @Test
    @Disabled
    public void compensationViaCancellation() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Compensation-IntermediateThrowEvent.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "0");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("CompensateIntermediateThrowEvent", params);
        this.kruntime.signalEvent("Cancel", null, processInstance.getStringId());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItemHandler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "x", "1");
    }

    @Test
    public void compensationInvokingSubProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-UserTaskCompensation.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("compensation", "True");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTaskCompensation", params);
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
        this.assertProcessVarValue(processInstance, "compensation", "compensation");
    }

    @Test
    public void compensationWithReusableSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("compensation/BPMN2-Booking.bpmn2", "compensation/BPMN2-BookResource.bpmn2", "compensation/BPMN2-CancelResource.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Booking");
        this.assertProcessInstanceCompleted(processInstance.getStringId(), this.kruntime);
    }
}

