/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.process.instance.impl.humantask.HumanTaskWorkItemImpl;
import org.jbpm.test.util.NodeLeftCountDownProcessEventListener;
import org.jbpm.workflow.instance.impl.NodeInstanceImpl;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.CompositeContextNodeInstance;
import org.jbpm.workflow.instance.node.ForEachNodeInstance;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.command.RegistryContext;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessRuntime;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemManager;
import org.kie.kogito.process.workitem.Policy;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FlowTest
extends JbpmBpmn2TestCase {
    @BeforeAll
    public static void setup() throws Exception {
        VariableScope.setVariableStrictOption((boolean)true);
    }

    @AfterEach
    public void clearProperties() {
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testExclusiveSplitWithNoConditions() throws Exception {
        try {
            this.createKogitoProcessRuntime("BPMN2-ExclusiveGatewayWithNoConditionsDefined.bpmn2");
            org.junit.jupiter.api.Assertions.fail((String)"Should fail as XOR gateway does not have conditions defined");
        }
        catch (RuntimeException e) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)e.getMessage().contains("does not have a constraint for Connection"));
        }
    }

    @Test
    public void testExclusiveSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplit.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitXPath-advanced.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvanced2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitXPath-advanced-vars-not-signaled.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitXPathAdvancedWithVars() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitXPath-advanced-with-vars.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, Object> params = new HashMap<String, Object>();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element hi = doc.createElement("hi");
        Element ho = doc.createElement("ho");
        hi.appendChild(ho);
        Attr attr = doc.createAttribute("value");
        ho.setAttributeNode(attr);
        attr.setValue("a");
        params.put("x", hi);
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitPriority() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitPriority.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "First");
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveSplitDefault() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitDefault.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Email", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x", "NotFirst");
        params.put("y", "Second");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testExclusiveXORGateway() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-gatewayTest.bpmn2");
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<instanceMetadata><user approved=\"false\" /></instanceMetadata>".getBytes()));
        HashMap<String, Node> params = new HashMap<String, Node>();
        params.put("instanceMetadata", document);
        params.put("startMessage", DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream("<task subject='foobar2'/>".getBytes())).getFirstChild());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("process", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplit() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplit.bpmn2");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitDefaultConnection() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveGatewayWithDefault.bpmn2");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("test", "c");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("InclusiveGatewayWithDefault", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitAndJoin() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoin.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinLoop.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinLoop2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinLoop2.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 21);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinNested() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinNested.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinEmbedded() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinEmbedded.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinWithParallel() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinWithParallel.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)activeWorkItems.size());
        for (KogitoWorkItem wi : activeWorkItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinWithEnd() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinWithEnd.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)activeWorkItems.size());
        for (int i = 0; i < 2; ++i) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(i).getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(2).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    @Timeout(value=10000L)
    public void testInclusiveSplitAndJoinWithTimer() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 2);
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinWithTimer.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 15);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)activeWorkItems.size());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(0).getStringId(), null, new Policy[0]);
        countDownListener.waitTillCompleted();
        this.assertProcessInstanceActive(processInstance);
        activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)activeWorkItems.size());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(0).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(1).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitAndJoinExtraPath() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitAndJoinExtraPath.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 25);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.kruntime.signalEvent("signal", null);
        List<KogitoWorkItem> activeWorkItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)activeWorkItems.size());
        for (int i = 0; i < 3; ++i) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(i).getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(activeWorkItems.get(3).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveSplitDefault() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveSplitDefault.bpmn2");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -5);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveParallelExclusiveSplitNoLoop() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getStringId(), results, new Policy[0]);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                FlowTest.this.logger.info(event.getNodeInstance().getNodeName());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = 0;
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testInclusiveParallelExclusiveSplitLoop() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getStringId(), results, new Policy[0]);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = 0;
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("testWI3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("testWI2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testInclusiveParallelExclusiveSplitNoLoopAsync() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getStringId(), results, new Policy[0]);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", 0);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem KogitoWorkItem2 : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        for (KogitoWorkItem KogitoWorkItem2 : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testInclusiveParallelExclusiveSplitLoopAsync() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveNestedInParallelNestedInExclusive.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)new SystemOutWorkItemHandler(){

            public void executeWorkItem(KogitoWorkItem workItem, KogitoWorkItemManager manager) {
                Integer x;
                Integer n = x = (Integer)workItem.getParameter("input1");
                Integer n2 = x = Integer.valueOf(x + 1);
                HashMap<String, Integer> results = new HashMap<String, Integer>();
                results.put("output1", x);
                manager.completeWorkItem(workItem.getStringId(), results, new Policy[0]);
            }
        });
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = 0;
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem KogitoWorkItem2 : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem KogitoWorkItem2 : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)workItems.size());
        for (KogitoWorkItem KogitoWorkItem2 : workItems) {
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)12, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("testWI3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("testWI2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((Integer)nodeInstanceExecutionCounter.get("ORGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XORGateway-diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)((Integer)nodeInstanceExecutionCounter.get("ANDGateway-converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("testWI6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testInclusiveSplitNested() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveGatewayNested.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)handler2);
        HashMap params = new HashMap();
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler2.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testInclusiveSplitWithLoopInside() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveGatewayWithLoopInside.bpmn2");
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                FlowTest.this.logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = new Integer(0);
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)handler2);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler2.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler2.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)10, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("OR diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((Integer)nodeInstanceExecutionCounter.get("OR converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XOR diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XOR converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testInclusiveSplitWithLoopInsideSubprocess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveGatewayWithLoopInsideSubprocess.bpmn2");
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                FlowTest.this.logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = 0;
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI", (KogitoWorkItemHandler)handler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("testWI2", (KogitoWorkItemHandler)handler2);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("x", -1);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Process_1", params);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        for (KogitoWorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler2.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler2.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Sub Process 1")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("sb-start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("sb-end")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("OR diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)((Integer)nodeInstanceExecutionCounter.get("OR converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("tareaWorkflow6")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("Script")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XOR diverging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((Integer)nodeInstanceExecutionCounter.get("XOR converging")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("End")));
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithORGateway() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcessWithORgateway.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap params = new HashMap();
        ArrayList<Integer> myList = new ArrayList<Integer>();
        myList.add(12);
        myList.add(15);
        params.put("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        List<KogitoWorkItem> workItems = workItemHandler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)workItems.size());
        Collection nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nodeInstances.size());
        NodeInstance nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        Collection nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)nodeInstancesChild.size());
        for (NodeInstance child : nodeInstancesChild) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)(child instanceof CompositeContextNodeInstance));
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)((CompositeContextNodeInstance)child).getNodeInstances().size());
        }
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(0).getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(1).getStringId(), null, new Policy[0]);
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        nodeInstances = ((WorkflowProcessInstanceImpl)processInstance).getNodeInstances();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)nodeInstances.size());
        nodeInstance = (NodeInstance)nodeInstances.iterator().next();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(nodeInstance instanceof ForEachNodeInstance));
        nodeInstancesChild = ((ForEachNodeInstance)nodeInstance).getNodeInstances();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)nodeInstancesChild.size());
        Iterator childIterator = nodeInstancesChild.iterator();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(childIterator.next() instanceof CompositeContextNodeInstance));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)(childIterator.next() instanceof ForEachNodeInstance.ForEachJoinNodeInstance));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(2).getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(3).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testInclusiveJoinWithLoopAndHumanTasks() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-InclusiveGatewayWithHumanTasksProcess.bpmn2");
        final HashMap nodeInstanceExecutionCounter = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                FlowTest.this.logger.info("{} {}", (Object)event.getNodeInstance().getNodeName(), (Object)((NodeInstanceImpl)event.getNodeInstance()).getLevel());
                Integer value = (Integer)nodeInstanceExecutionCounter.get(event.getNodeInstance().getNodeName());
                if (value == null) {
                    value = 0;
                }
                Integer n = value;
                Integer n2 = value = Integer.valueOf(value + 1);
                nodeInstanceExecutionCounter.put(event.getNodeInstance().getNodeName(), value);
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("firstXor", true);
        params.put("secondXor", true);
        params.put("thirdXor", true);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("InclusiveWithAdvancedLoop", params);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        KogitoWorkItem remainingWork = null;
        for (KogitoWorkItem wi : workItems) {
            this.assertProcessInstanceActive(processInstance);
            if (wi.getParameter("NodeName").equals("HT Form2")) {
                this.kruntime.getKogitoWorkItemManager().completeWorkItem(wi.getStringId(), null, new Policy[0]);
                continue;
            }
            remainingWork = wi;
        }
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(remainingWork.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)13, (int)nodeInstanceExecutionCounter.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Start")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("HT Form1")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("and1")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("HT Form2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("xor1")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("xor2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("HT Form3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Koniec")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("xor 3")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("HT Form4")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("xor4")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("Koniec2")));
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)((Integer)nodeInstanceExecutionCounter.get("or1")));
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcess.bpmn2");
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcess", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopNumberTest() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoop-Numbering.bpmn2");
        HashMap params = new HashMap();
        final HashMap nodeIdNodeNameMap = new HashMap();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                String nodeName;
                NodeInstance nodeInstance = event.getNodeInstance();
                String uniqId = ((NodeInstanceImpl)nodeInstance).getUniqueId();
                String prevNodeName = nodeIdNodeNameMap.put(uniqId, nodeName = nodeInstance.getNode().getName());
                if (prevNodeName != null) {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)(uniqId + " is used for more than one node instance: "), (Object)prevNodeName, (String)nodeName);
                }
            }
        });
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("Test.MultipleInstancesBug", params);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        this.logger.debug("COMPLETING TASKS.");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.remove(0).getStringId(), null, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.remove(0).getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcess2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceProcessWithOutputOnTask.bpmn2");
        TestWorkItemHandler handler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)handler);
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        List myOutList = null;
        myList.add("John");
        myList.add("Mary");
        params.put("miinput", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("miprocess", params);
        List<KogitoWorkItem> workItems = handler.getWorkItems();
        org.junit.jupiter.api.Assertions.assertNotNull(workItems);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)workItems.size());
        myOutList = (List)this.kruntime.getKieSession().execute((Command)new GetProcessVariableCommand(processInstance.getStringId(), "mioutput"));
        org.junit.jupiter.api.Assertions.assertNull((Object)myOutList);
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("reply", "Hello John");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(0).getStringId(), results, new Policy[0]);
        myOutList = (List)this.kruntime.getKieSession().execute((Command)new GetProcessVariableCommand(processInstance.getStringId(), "mioutput"));
        org.junit.jupiter.api.Assertions.assertNull((Object)myOutList);
        results = new HashMap();
        results.put("reply", "Hello Mary");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItems.get(1).getStringId(), results, new Policy[0]);
        myOutList = (List)this.kruntime.getKieSession().execute((Command)new GetProcessVariableCommand(processInstance.getStringId(), "mioutput"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)myOutList);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)myOutList.size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)myOutList.contains("Hello John"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)myOutList.contains("Hello Mary"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(handler.getWorkItem().getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutput() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutput.bpmn2");
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutputCompletionCondition() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutputCmpCond.bpmn2");
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsProcessWithOutputAndScripts() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsProcessWithOutputAndScripts.bpmn2");
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        ArrayList scriptList = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        params.put("scriptList", scriptList);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsProcessWithOutput", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)myListOut.size());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)scriptList.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutput() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutput.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutputCompletionCondition() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutputCmpCond.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        params.put("listOut", myListOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTaskWithOutputCompletionCondition2() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsTaskWithOutputCmpCond2.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        ArrayList myListOut = new ArrayList();
        myList.add("approved");
        myList.add("rejected");
        myList.add("approved");
        myList.add("approved");
        myList.add("rejected");
        params.put("list", myList);
        params.put("listOut", myListOut);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)myListOut.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)myListOut.size());
    }

    @Test
    public void testMultiInstanceLoopCharacteristicsTask() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiInstanceLoopCharacteristicsTask.bpmn2");
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        HashMap params = new HashMap();
        ArrayList<String> myList = new ArrayList<String>();
        myList.add("First Item");
        myList.add("Second Item");
        params.put("list", myList);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultiInstanceLoopCharacteristicsTask", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testMultipleInOutgoingSequenceFlows() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        System.setProperty("jbpm.enable.multi.con", "true");
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                list.add(((KogitoProcessInstance)event.getProcessInstance()).getStringId());
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)list.size());
        countDownListener.waitTillCompleted();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleIncomingFlowToEndNode() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleFlowEndNode.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("MultipleFlowEndNode");
        this.assertProcessInstanceCompleted(processInstance);
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleEnabledOnSingleConditionalSequenceFlow() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultiConnEnabled.bpmn2");
        final ArrayList list = new ArrayList();
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if ("Task2".equals(event.getNodeInstance().getNodeName())) {
                    list.add(event.getNodeInstance().getNodeId());
                }
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)list.size());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("BPMN2-MultiConnEnabled");
        this.assertProcessInstanceActive(processInstance);
        this.kruntime.signalEvent("signal", null, processInstance.getStringId());
        this.assertProcessInstanceCompleted(processInstance);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)list.size());
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testMultipleInOutgoingSequenceFlowsDisable() throws Exception {
        try {
            this.createKogitoProcessRuntime("BPMN2-MultipleInOutgoingSequenceFlows.bpmn2");
            org.junit.jupiter.api.Assertions.fail((String)"Should fail as multiple outgoing and incoming connections are disabled by default");
        }
        catch (Exception e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"This type of node [ScriptTask_1, Script Task] cannot have more than one outgoing connection!"});
        }
    }

    @Test
    public void testConditionalFlow() throws Exception {
        System.setProperty("jbpm.enable.multi.con", "true");
        String processId = "designer.conditional-flow";
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ConditionalFlowWithoutGateway.bpmn2");
        KogitoProcessInstance wpi = this.kruntime.startProcess(processId);
        this.assertProcessInstanceFinished(wpi, this.kruntime);
        this.assertNodeTriggered(wpi.getStringId(), "start", "script", "end1");
        System.clearProperty("jbpm.enable.multi.con");
    }

    @Test
    public void testLane() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-Lane.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.getState());
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoWorkItem KogitoWorkItem2 = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)KogitoWorkItem2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", (Object)KogitoWorkItem2.getParameter("ActorId"));
        HashMap results = new HashMap();
        ((HumanTaskWorkItemImpl)KogitoWorkItem2).setActualOwner("mary");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), results, new Policy[0]);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoWorkItem2 = workItemHandler.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)KogitoWorkItem2);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"mary", (Object)KogitoWorkItem2.getParameter("SwimlaneActorId"));
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(KogitoWorkItem2.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testExclusiveSplitDefaultNoCondition() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-ExclusiveSplitDefaultNoCondition.bpmn2");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.test");
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
    }

    @Test
    public void testMultipleGatewaysProcess() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-MultipleGatewaysProcess.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)new DefaultKogitoProcessEventListener(){
            KogitoProcessInstance pi;

            public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
                if (event.getNodeInstance().getNodeName().equals("CreateAgent")) {
                    this.pi.signalEvent("Signal_1", null);
                }
            }

            public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
                FlowTest.this.logger.info("Before Node triggered event received for node: {}", (Object)event.getNodeInstance().getNodeName());
            }

            public void beforeProcessStarted(ProcessStartedEvent event) {
                this.pi = (KogitoProcessInstance)event.getProcessInstance();
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "CreateAgent");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("multiplegateways", params);
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testTimerAndGateway() throws Exception {
        NodeLeftCountDownProcessEventListener countDownListener = new NodeLeftCountDownProcessEventListener("timer", 1);
        this.kruntime = this.createKogitoProcessRuntime("timer/BPMN2-ParallelSplitWithTimerProcess.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        TestWorkItemHandler handler1 = new TestWorkItemHandler();
        TestWorkItemHandler handler2 = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task1", (KogitoWorkItemHandler)handler1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task2", (KogitoWorkItemHandler)handler2);
        KogitoProcessInstance instance = this.kruntime.createProcessInstance("timer-process", new HashMap());
        this.kruntime.startProcessInstance(instance.getStringId());
        KogitoWorkItem workItem1 = handler1.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem1);
        org.junit.jupiter.api.Assertions.assertNull((Object)handler1.getWorkItem());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem1.getStringId(), null, new Policy[0]);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)countDownListener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task1", (KogitoWorkItemHandler)handler1);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("task2", (KogitoWorkItemHandler)handler2);
        countDownListener.waitTillCompleted();
        KogitoWorkItem workItem2 = handler2.getWorkItem();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)workItem2);
        org.junit.jupiter.api.Assertions.assertNull((Object)handler2.getWorkItem());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem2.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceCompleted(instance);
    }

    private static class GetProcessVariableCommand
    implements ExecutableCommand<Object> {
        private String processInstanceId;
        private String variableName;

        public GetProcessVariableCommand(String processInstanceId, String variableName) {
            this.processInstanceId = processInstanceId;
            this.variableName = variableName;
        }

        public Object execute(Context context) {
            KogitoProcessRuntime kruntime = KogitoProcessRuntime.asKogitoProcessRuntime((ProcessRuntime)((ProcessRuntime)((RegistryContext)context).lookup(KieSession.class)));
            ProcessInstance processInstance = (ProcessInstance)kruntime.getProcessInstance(this.processInstanceId);
            VariableScopeInstance variableScope = (VariableScopeInstance)processInstance.getContextInstance("VariableScope");
            Object variable = variableScope.getVariable(this.variableName);
            return variable;
        }
    }
}

