/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2;

import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.instance.ProcessInstance;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.workflow.instance.NodeInstance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.kogito.internal.process.event.DefaultKogitoProcessEventListener;
import org.kie.kogito.internal.process.runtime.KogitoNodeInstance;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;
import org.kie.kogito.process.workitem.Policy;

public class SLAComplianceTest
extends JbpmBpmn2TestCase {
    @Test
    public void testSLAonProcessViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonProcessMet() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)2, (int)slaCompliance);
    }

    @Test
    public void testSLAonUserTaskViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonUserTaskMet() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)2, (int)slaCompliance);
    }

    @Test
    public void testSLAonProcessViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        this.kruntime.signalEvent("slaViolation", null, processInstance.getStringId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonUserTaskViolatedExternalTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAOnTask.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        KogitoNodeInstance userTaskNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("slaViolation:" + userTaskNode.getStringId(), null, processInstance.getStringId());
        slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)userTaskNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonProcessViolatedWithExpression() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLAExpr.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("s", "3s");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask", parameters);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(10L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA was not violated while it is expected");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonProcessViolatedNoTracking() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-UserTaskWithSLA.bpmn2");
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKieRuntime().getEnvironment().set("SLATimerMode", (Object)"false");
        KogitoProcessInstance processInstance = this.kruntime.startProcess("UserTask");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem workItem = workItemHandler.getWorkItem();
        Assertions.assertNotNull((Object)workItem);
        Assertions.assertEquals((Object)"john", (Object)workItem.getParameter("ActorId"));
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)1, (int)slaCompliance);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(workItem.getStringId(), null, new Policy[0]);
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonCatchEventViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        boolean slaViolated = latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)slaViolated, (String)"SLA should be violated by timer");
        processInstance = this.kruntime.getProcessInstance(processInstance.getStringId());
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        KogitoNodeInstance eventNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("MyMessage", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 0);
        Assertions.assertEquals((int)3, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 1);
        Assertions.assertEquals((int)3, (int)slaCompliance);
    }

    @Test
    public void testSLAonCatchEventNotViolated() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        DefaultKogitoProcessEventListener listener = new DefaultKogitoProcessEventListener(){

            public void afterSLAViolated(SLAViolatedEvent event) {
                latch.countDown();
            }
        };
        this.kruntime = this.createKogitoProcessRuntime("BPMN2-IntermediateCatchEventSignalWithSLAOnEvent.bpmn2");
        this.kruntime.getProcessEventManager().addEventListener((ProcessEventListener)listener);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)new SystemOutWorkItemHandler());
        KogitoProcessInstance processInstance = this.kruntime.startProcess("IntermediateCatchEvent");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Collection active = ((KogitoWorkflowProcessInstance)processInstance).getKogitoNodeInstances();
        Assertions.assertEquals((int)1, (int)active.size());
        KogitoNodeInstance eventNode = (KogitoNodeInstance)active.iterator().next();
        this.kruntime.signalEvent("MyMessage", null, processInstance.getStringId());
        this.assertProcessInstanceFinished(processInstance, this.kruntime);
        int slaCompliance = this.getSLAComplianceForProcessInstance(processInstance);
        Assertions.assertEquals((int)0, (int)slaCompliance);
        slaCompliance = this.getSLAComplianceForNodeInstance(processInstance.getStringId(), (NodeInstance)eventNode, 1);
        Assertions.assertEquals((int)2, (int)slaCompliance);
        boolean slaViolated = latch.await(3L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)slaViolated, (String)"SLA should not violated by timer");
    }

    private int getSLAComplianceForProcessInstance(KogitoProcessInstance processInstance) {
        int slaCompliance = ((ProcessInstance)processInstance).getSlaCompliance();
        return slaCompliance;
    }

    private int getSLAComplianceForNodeInstance(String processInstanceId, NodeInstance nodeInstance, int logType) {
        int slaCompliance = nodeInstance.getSlaCompliance();
        return slaCompliance;
    }
}

