/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.handler;

import java.util.HashMap;
import org.jbpm.bpmn2.JbpmBpmn2TestCase;
import org.jbpm.bpmn2.handler.ErrornousWorkItemHandler;
import org.jbpm.bpmn2.objects.TestWorkItemHandler;
import org.jbpm.process.core.context.variable.VariableScope;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.runtime.process.ProcessWorkItemHandlerException;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.workitem.Policy;

public class WorkItemHandlerExceptionHandlingTest
extends JbpmBpmn2TestCase {
    private static Boolean strictVariableSetting = Boolean.parseBoolean(System.getProperty("org.jbpm.variable.strict", Boolean.FALSE.toString()));

    @BeforeAll
    public static void setup() throws Exception {
        VariableScope.setVariableStrictOption((boolean)false);
    }

    @AfterAll
    public static void clean() throws Exception {
        VariableScope.setVariableStrictOption((boolean)strictVariableSetting);
    }

    @Test
    public void testErrornousHandlerWithStrategyComplete() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        KogitoWorkItem handledWorkItem = (KogitoWorkItem)workItemHandler.getWorkItem();
        Assertions.assertEquals((int)2, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyCompleteWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.COMPLETE);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean");
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyAbort() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        KogitoWorkItem handledWorkItem = (KogitoWorkItem)workItemHandler.getWorkItem();
        Assertions.assertEquals((int)3, (int)handledWorkItem.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyAbortWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.ABORT);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "false");
        this.assertProcessInstanceCompleted(processInstance);
    }

    @Test
    public void testErrornousHandlerWithStrategyRethrow() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETHROW);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)5, (int)processInstance.getState());
    }

    @Test
    public void testErrornousHandlerWithStrategyRetry() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ScriptTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ScriptTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }

    @Test
    public void testErrornousHandlerWithStrategyRetryWaitState() throws Exception {
        this.kruntime = this.createKogitoProcessRuntime("handler/BPMN2-UserTaskWithBooleanOutput.bpmn2", "handler/BPMN2-ReceiveTask.bpmn2");
        ErrornousWorkItemHandler workItemHandler = new ErrornousWorkItemHandler("ReceiveTask", ProcessWorkItemHandlerException.HandlingStrategy.RETRY);
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Human Task", (KogitoWorkItemHandler)workItemHandler);
        TestWorkItemHandler testHandler = new TestWorkItemHandler();
        this.kruntime.getKogitoWorkItemManager().registerWorkItemHandler("Receive Task", (KogitoWorkItemHandler)testHandler);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isChecked", false);
        KogitoProcessInstance processInstance = this.kruntime.startProcess("com.sample.boolean", params);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        KogitoWorkItem receiveWorkItem = testHandler.getWorkItem();
        HashMap<String, Boolean> results = new HashMap<String, Boolean>();
        results.put("Message", true);
        this.kruntime.getKogitoWorkItemManager().completeWorkItem(receiveWorkItem.getStringId(), results, new Policy[0]);
        this.assertProcessVarValue(processInstance, "isChecked", "true");
    }
}

