/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProcessMarshaller;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.process.instance.WorkItemManager;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.marshalling.impl.JBPMMessages;
import org.jbpm.marshalling.impl.ProcessMarshallerRegistry;
import org.jbpm.marshalling.impl.TimerManagerMarshallers;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.services.time.manager.TimerInstance;
import org.kie.services.time.manager.TimerManager;

public class ProtobufProcessMarshaller
implements ProcessMarshaller {
    private static boolean persistWorkItemVars = Boolean.parseBoolean(System.getProperty("org.jbpm.wi.variable.persist", "true"));

    public static void setWorkItemVarsPersistence(boolean turnOn) {
        persistWorkItemVars = turnOn;
    }

    public void writeProcessInstances(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.ProcessData.Builder _pdata = (ProtobufMessages.ProcessData.Builder)context.parameterObject;
        ArrayList processInstances = new ArrayList(context.wm.getProcessInstances());
        Collections.sort(processInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (ProcessInstance processInstance : processInstances) {
            String processType = processInstance.getProcess().getType();
            JBPMMessages.ProcessInstance _instance = (JBPMMessages.ProcessInstance)ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType).writeProcessInstance(context, processInstance);
            _pdata.addExtension(JBPMMessages.processInstance, (Object)_instance);
        }
    }

    public void writeProcessTimers(MarshallerWriteContext outCtx) throws IOException {
        outCtx.writersByClass.put(TimerManager.ProcessJobContext.class, new TimerManagerMarshallers.ProcessTimerOutputMarshaller());
        outCtx.writersByClass.put(TimerManager.StartProcessJobContext.class, new TimerManagerMarshallers.ProcessTimerOutputMarshaller());
        ProtobufMessages.ProcessData.Builder _pdata = (ProtobufMessages.ProcessData.Builder)outCtx.parameterObject;
        TimerManager timerManager = ((InternalProcessRuntime)outCtx.wm.getProcessRuntime()).getTimerManager();
        long timerId = timerManager.internalGetTimerId();
        _pdata.setExtension(JBPMMessages.timerId, (Object)timerId);
    }

    public void writeWorkItems(MarshallerWriteContext context) throws IOException {
        ProtobufMessages.ProcessData.Builder _pdata = (ProtobufMessages.ProcessData.Builder)context.parameterObject;
        ArrayList workItems = new ArrayList(((WorkItemManager)context.wm.getWorkItemManager()).getWorkItems());
        Collections.sort(workItems, new Comparator<org.kie.api.runtime.process.WorkItem>(){

            @Override
            public int compare(org.kie.api.runtime.process.WorkItem o1, org.kie.api.runtime.process.WorkItem o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (org.kie.api.runtime.process.WorkItem workItem : workItems) {
            _pdata.addExtension(JBPMMessages.workItem, (Object)ProtobufProcessMarshaller.writeWorkItem(context, workItem));
        }
    }

    public static JBPMMessages.WorkItem writeWorkItem(MarshallerWriteContext context, org.kie.api.runtime.process.WorkItem workItem) throws IOException {
        return ProtobufProcessMarshaller.writeWorkItem(context, workItem, true);
    }

    public List<ProcessInstance> readProcessInstances(MarshallerReaderContext context) throws IOException {
        ProtobufMessages.ProcessData _pdata = (ProtobufMessages.ProcessData)context.parameterObject;
        ArrayList<ProcessInstance> processInstanceList = new ArrayList<ProcessInstance>();
        for (JBPMMessages.ProcessInstance _instance : (List)_pdata.getExtension(JBPMMessages.processInstance)) {
            context.parameterObject = _instance;
            ProcessInstance processInstance = ProcessMarshallerRegistry.INSTANCE.getMarshaller(_instance.getProcessType()).readProcessInstance(context);
            processInstanceList.add(processInstance);
        }
        return processInstanceList;
    }

    public void readWorkItems(MarshallerReaderContext context) throws IOException {
        ProtobufMessages.ProcessData _pdata = (ProtobufMessages.ProcessData)context.parameterObject;
        InternalWorkingMemory wm = context.wm;
        for (JBPMMessages.WorkItem _workItem : (List)_pdata.getExtension(JBPMMessages.workItem)) {
            org.kie.api.runtime.process.WorkItem workItem = ProtobufProcessMarshaller.readWorkItem(context, _workItem);
            ((WorkItemManager)wm.getWorkItemManager()).internalAddWorkItem((WorkItem)workItem);
        }
    }

    public void readProcessTimers(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
        inCtx.readersByInt.put(4, new TimerManagerMarshallers.ProcessTimerInputMarshaller());
        ProtobufMessages.ProcessData _pdata = (ProtobufMessages.ProcessData)inCtx.parameterObject;
        TimerManager timerManager = ((InternalProcessRuntime)inCtx.wm.getProcessRuntime()).getTimerManager();
        timerManager.internalSetTimerId(((Long)_pdata.getExtension(JBPMMessages.timerId)).longValue());
    }

    public static JBPMMessages.ProcessTimer.TimerInstance writeTimer(MarshallerWriteContext context, TimerInstance timer) {
        JBPMMessages.ProcessTimer.TimerInstance.Builder _timer = JBPMMessages.ProcessTimer.TimerInstance.newBuilder().setId(timer.getId()).setTimerId(timer.getTimerId()).setSessionId(timer.getSessionId()).setDelay(timer.getDelay()).setPeriod(timer.getPeriod()).setProcessInstanceId(timer.getProcessInstanceId()).setActivatedTime(timer.getActivated().getTime()).setRepeatLimit(timer.getRepeatLimit());
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered != null) {
            _timer.setLastTriggered(lastTriggered.getTime());
        }
        return _timer.build();
    }

    public static TimerInstance readTimer(MarshallerReaderContext context, JBPMMessages.ProcessTimer.TimerInstance _timer) {
        TimerInstance timer = new TimerInstance();
        timer.setId(_timer.getId());
        timer.setTimerId(_timer.getTimerId());
        timer.setDelay(_timer.getDelay());
        timer.setPeriod(_timer.getPeriod());
        timer.setProcessInstanceId(_timer.getProcessInstanceId());
        if (_timer.hasDEPRECATEDSessionId()) {
            timer.setSessionId((long)_timer.getDEPRECATEDSessionId());
        } else {
            timer.setSessionId(_timer.getSessionId());
        }
        timer.setActivated(new Date(_timer.getActivatedTime()));
        if (_timer.hasLastTriggered()) {
            timer.setLastTriggered(new Date(_timer.getLastTriggered()));
        }
        timer.setRepeatLimit(_timer.getRepeatLimit());
        return timer;
    }

    public static JBPMMessages.WorkItem writeWorkItem(MarshallerWriteContext context, org.kie.api.runtime.process.WorkItem workItem, boolean includeVariables) throws IOException {
        JBPMMessages.WorkItem.Builder _workItem = JBPMMessages.WorkItem.newBuilder().setId(workItem.getId()).setProcessInstancesId(workItem.getProcessInstanceId()).setName(workItem.getName()).setState(workItem.getState());
        if (workItem instanceof WorkItem) {
            if (((WorkItem)workItem).getDeploymentId() != null) {
                _workItem.setDeploymentId(((WorkItem)workItem).getDeploymentId());
            }
            _workItem.setNodeId(((WorkItem)workItem).getNodeId()).setNodeInstanceId(((WorkItem)workItem).getNodeInstanceId());
        }
        if (includeVariables) {
            Map parameters = workItem.getParameters();
            for (Map.Entry entry : parameters.entrySet()) {
                _workItem.addVariable(ProtobufProcessMarshaller.marshallVariable(context, (String)entry.getKey(), entry.getValue()));
            }
        }
        return _workItem.build();
    }

    public static org.kie.api.runtime.process.WorkItem readWorkItem(MarshallerReaderContext context, JBPMMessages.WorkItem _workItem) throws IOException {
        return ProtobufProcessMarshaller.readWorkItem(context, _workItem, true);
    }

    public static org.kie.api.runtime.process.WorkItem readWorkItem(MarshallerReaderContext context, JBPMMessages.WorkItem _workItem, boolean includeVariables) throws IOException {
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(_workItem.getId());
        workItem.setProcessInstanceId(_workItem.getProcessInstancesId());
        workItem.setName(_workItem.getName());
        workItem.setState(_workItem.getState());
        workItem.setDeploymentId(_workItem.getDeploymentId());
        workItem.setNodeId(_workItem.getNodeId());
        workItem.setNodeInstanceId(_workItem.getNodeInstanceId());
        if (includeVariables) {
            for (JBPMMessages.Variable _variable : _workItem.getVariableList()) {
                try {
                    Object value = ProtobufProcessMarshaller.unmarshallVariableValue(context, _variable);
                    workItem.setParameter(_variable.getName(), value);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload parameter " + _variable.getName() + " for work item " + _workItem);
                }
            }
        }
        return workItem;
    }

    public static JBPMMessages.Variable marshallVariable(MarshallerWriteContext context, String name, Object value) throws IOException {
        JBPMMessages.Variable.Builder builder = JBPMMessages.Variable.newBuilder().setName(name);
        if (value != null) {
            ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(value);
            Integer index = context.getStrategyIndex(strategy);
            builder.setStrategyIndex(index).setValue(ByteString.copyFrom((byte[])strategy.marshal((ObjectMarshallingStrategy.Context)context.strategyContext.get(strategy), (ObjectOutputStream)context, value)));
        }
        return builder.build();
    }

    public static JBPMMessages.Variable marshallVariablesMap(MarshallerWriteContext context, Map<String, Object> variables) throws IOException {
        HashMap<String, JBPMMessages.Variable> marshalledVariables = new HashMap<String, JBPMMessages.Variable>();
        for (String key : variables.keySet()) {
            JBPMMessages.Variable.Builder builder = JBPMMessages.Variable.newBuilder().setName(key);
            if (variables.get(key) != null) {
                ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(variables.get(key));
                Integer index = context.getStrategyIndex(strategy);
                builder.setStrategyIndex(index).setValue(ByteString.copyFrom((byte[])strategy.marshal((ObjectMarshallingStrategy.Context)context.strategyContext.get(strategy), (ObjectOutputStream)context, variables.get(key))));
            }
            marshalledVariables.put(key, builder.build());
        }
        return ProtobufProcessMarshaller.marshallVariable(context, "variablesMap", marshalledVariables);
    }

    public static JBPMMessages.VariableContainer marshallVariablesContainer(MarshallerWriteContext context, Map<String, Object> variables) throws IOException {
        JBPMMessages.VariableContainer.Builder vcbuilder = JBPMMessages.VariableContainer.newBuilder();
        for (String key : variables.keySet()) {
            JBPMMessages.Variable.Builder builder = JBPMMessages.Variable.newBuilder().setName(key);
            if (variables.get(key) != null) {
                ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(variables.get(key));
                Integer index = context.getStrategyIndex(strategy);
                builder.setStrategyIndex(index).setValue(ByteString.copyFrom((byte[])strategy.marshal((ObjectMarshallingStrategy.Context)context.strategyContext.get(strategy), (ObjectOutputStream)context, variables.get(key))));
            }
            vcbuilder.addVariable(builder.build());
        }
        return vcbuilder.build();
    }

    public static Object unmarshallVariableValue(MarshallerReaderContext context, JBPMMessages.Variable _variable) throws IOException, ClassNotFoundException {
        if (_variable.getValue() == null || _variable.getValue().isEmpty()) {
            return null;
        }
        ObjectMarshallingStrategy strategy = (ObjectMarshallingStrategy)context.usedStrategies.get(_variable.getStrategyIndex());
        Object value = strategy.unmarshal((ObjectMarshallingStrategy.Context)context.strategyContexts.get(strategy), (ObjectInputStream)context, _variable.getValue().toByteArray(), context.kBase == null ? null : context.kBase.getRootClassLoader());
        return value;
    }

    public static Map<String, Object> unmarshallVariableContainerValue(MarshallerReaderContext context, JBPMMessages.VariableContainer _variableContiner) throws IOException, ClassNotFoundException {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (_variableContiner.getVariableCount() == 0) {
            return variables;
        }
        for (JBPMMessages.Variable _variable : _variableContiner.getVariableList()) {
            Object value = ProtobufProcessMarshaller.unmarshallVariableValue(context, _variable);
            variables.put(_variable.getName(), value);
        }
        return variables;
    }

    public void init(MarshallerReaderContext context) {
        ExtensionRegistry registry = (ExtensionRegistry)context.parameterObject;
        registry.add(JBPMMessages.processInstance);
        registry.add(JBPMMessages.processTimer);
        registry.add(JBPMMessages.procTimer);
        registry.add(JBPMMessages.workItem);
        registry.add(JBPMMessages.timerId);
    }

    public void writeWorkItem(MarshallerWriteContext context, WorkItem workItem) {
        try {
            JBPMMessages.WorkItem _workItem = ProtobufProcessMarshaller.writeWorkItem(context, (org.kie.api.runtime.process.WorkItem)workItem, persistWorkItemVars);
            PersisterHelper.writeToStreamWithHeader((MarshallerWriteContext)context, (Message)_workItem);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while storing work item instance " + workItem.getId() + ": " + e.getMessage(), e);
        }
    }

    public WorkItem readWorkItem(MarshallerReaderContext context) {
        try {
            ExtensionRegistry registry = PersisterHelper.buildRegistry((MarshallerReaderContext)context, null);
            ProtobufMessages.Header _header = PersisterHelper.readFromStreamWithHeaderPreloaded((MarshallerReaderContext)context, (ExtensionRegistry)registry);
            JBPMMessages.WorkItem _workItem = JBPMMessages.WorkItem.parseFrom(_header.getPayload(), (ExtensionRegistryLite)registry);
            return (WorkItem)ProtobufProcessMarshaller.readWorkItem(context, _workItem, persistWorkItemVars);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException while fetching work item instance : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ClassNotFoundException while fetching work item instance : " + e.getMessage(), e);
        }
    }
}

