/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance;

import java.util.EventListener;
import java.util.Optional;
import org.drools.core.event.ProcessEventSupport;
import org.jbpm.process.instance.LightWorkItemManager;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.process.instance.ProcessRuntimeServiceProvider;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManager;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.kogito.process.ProcessEventListenerConfig;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.signal.SignalManager;
import org.kie.kogito.signal.SignalManagerHub;
import org.kie.services.signal.LightSignalManager;
import org.kie.services.time.TimerService;

public class AbstractProcessRuntimeServiceProvider
implements ProcessRuntimeServiceProvider {
    private final TimerService timerService;
    private final ProcessInstanceManager processInstanceManager = new DefaultProcessInstanceManager();
    private final SignalManager signalManager;
    private final WorkItemManager workItemManager;
    private final ProcessEventSupport eventSupport;

    public AbstractProcessRuntimeServiceProvider(TimerService timerService, WorkItemHandlerConfig workItemHandlerProvider, ProcessEventListenerConfig processEventListenerProvider, SignalManagerHub compositeSignalManager) {
        this.signalManager = new LightSignalManager(id -> Optional.ofNullable(this.processInstanceManager.getProcessInstance(id)), compositeSignalManager);
        this.timerService = timerService;
        this.workItemManager = new LightWorkItemManager(this.processInstanceManager, this.signalManager);
        for (String workItem : workItemHandlerProvider.names()) {
            this.workItemManager.registerWorkItemHandler(workItem, workItemHandlerProvider.forName(workItem));
        }
        this.eventSupport = new ProcessEventSupport();
        for (ProcessEventListener listener : processEventListenerProvider.listeners()) {
            this.eventSupport.addEventListener((EventListener)listener);
        }
    }

    @Override
    public TimerService getTimerService() {
        return this.timerService;
    }

    @Override
    public ProcessInstanceManager getProcessInstanceManager() {
        return this.processInstanceManager;
    }

    @Override
    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        return this.workItemManager;
    }

    @Override
    public ProcessEventSupport getEventSupport() {
        return this.eventSupport;
    }
}

