/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.process.core.Context;
import org.jbpm.process.core.ContextContainer;
import org.jbpm.process.core.context.exception.CompensationHandler;
import org.jbpm.process.core.context.exception.CompensationScope;
import org.jbpm.process.core.context.exception.ExceptionHandler;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.core.event.EventTypeFilter;
import org.jbpm.process.core.event.NonAcceptingEventTypeFilter;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.test.NodeCreator;
import org.jbpm.process.test.TestWorkItemHandler;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.impl.DroolsConsequenceAction;
import org.jbpm.workflow.core.node.ActionNode;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.EventSubProcessNode;
import org.jbpm.workflow.core.node.StartNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.NodeContainer;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.process.workitem.Policy;
import org.slf4j.LoggerFactory;

public class CompensationTest
extends AbstractBaseTest {
    private KieSession ksession;

    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @AfterEach
    public void cleanUp() {
        if (this.ksession != null) {
            this.ksession.dispose();
            this.ksession = null;
        }
    }

    private void addCompensationScope(org.jbpm.workflow.core.Node node, NodeContainer parentContainer, String compensationHandlerId) {
        ContextContainer contextContainer = (ContextContainer)parentContainer;
        CompensationScope scope = null;
        boolean addScope = false;
        if (contextContainer.getContexts("CompensationScope") == null) {
            addScope = true;
        } else {
            scope = (CompensationScope)contextContainer.getContexts("CompensationScope").get(0);
            if (scope == null) {
                addScope = true;
            }
        }
        if (addScope) {
            scope = new CompensationScope();
            contextContainer.addContext((Context)scope);
            contextContainer.setDefaultContext((Context)scope);
            scope.setContextContainer(contextContainer);
        }
        CompensationHandler handler = new CompensationHandler();
        handler.setNode((Node)node);
        scope.setExceptionHandler(compensationHandlerId, (ExceptionHandler)handler);
        node.setMetaData("isForCompensation", (Object)Boolean.TRUE);
    }

    private org.jbpm.workflow.core.Node findNode(RuleFlowProcess process, String nodeName) {
        org.jbpm.workflow.core.Node found = null;
        LinkedList<Node> nodes = new LinkedList<Node>();
        nodes.addAll(Arrays.asList(process.getNodes()));
        while (!nodes.isEmpty()) {
            Node node = (Node)nodes.poll();
            if (node.getName().equals(nodeName)) {
                found = (org.jbpm.workflow.core.Node)node;
            }
            if (!(node instanceof NodeContainer)) continue;
            nodes.addAll(Arrays.asList(((NodeContainer)node).getNodes()));
        }
        Assertions.assertNotNull((Object)found, (String)("Could not find node (" + nodeName + ")."));
        return found;
    }

    @Test
    public void testCompensationBoundaryEventSpecific() throws Exception {
        String processId = "org.jbpm.process.compensation.boundary";
        String[] workItemNames = new String[]{"Don-Quixote", "Sancho", "Ricote"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createCompensationBoundaryEventProcess(processId, workItemNames, eventList);
        this.ksession = this.createKieSession(new Process[]{process});
        org.jbpm.workflow.core.Node compensatedNode = this.findNode(process, "work1");
        String compensationEvent = (String)compensatedNode.getMetaData().get("UniqueId");
        CompensationTest.runCompensationBoundaryEventSpecificTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    public static void runCompensationBoundaryEventSpecificTest(KieSession ksession, RuleFlowProcess process, String processId, String[] workItemNames, List<String> eventList, String compensationEvent) {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        for (String workItem : workItemNames) {
            ksession.getWorkItemManager().registerWorkItemHandler(workItem, (WorkItemHandler)workItemHandler);
        }
        ProcessInstance processInstance = ksession.startProcess(processId);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)0, (int)eventList.size(), (String)"Compensation should not have fired yet.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)1, (int)eventList.size(), (String)"Compensation should have fired.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testCompensationBoundaryEventGeneral() throws Exception {
        String processId = "org.jbpm.process.compensation.boundary";
        String[] workItemNames = new String[]{"Don-Quixote", "Sancho", "Ricote"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createCompensationBoundaryEventProcess(processId, workItemNames, eventList);
        this.ksession = this.createKieSession(new Process[]{process});
        String compensationEvent = "implicit:" + processId;
        CompensationTest.runCompensationBoundaryEventGeneralTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    public static void runCompensationBoundaryEventGeneralTest(KieSession ksession, RuleFlowProcess process, String processId, String[] workItemNames, List<String> eventList, String compensationEvent) {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        for (String workItem : workItemNames) {
            ksession.getWorkItemManager().registerWorkItemHandler(workItem, (WorkItemHandler)workItemHandler);
        }
        ProcessInstance processInstance = ksession.startProcess(processId);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)0, (int)eventList.size(), (String)"Compensation should not have fired yet.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)1, (int)processInstance.getState());
        Assertions.assertEquals((int)0, (int)eventList.size(), (String)"Compensation should not have fired yet.");
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)2, (int)eventList.size(), (String)"Compensation should have fired.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    private RuleFlowProcess createCompensationBoundaryEventProcess(String processId, String[] workItemNames, List<String> eventList) throws Exception {
        StartNode startNode;
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(processId);
        process.setName("CESP Process");
        process.setMetaData("Compensation", (Object)true);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("java.lang.String");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        NodeCreator<StartNode> startNodeCreator = new NodeCreator<StartNode>((org.jbpm.workflow.core.NodeContainer)process, StartNode.class);
        NodeCreator<EndNode> endNodeCreator = new NodeCreator<EndNode>((org.jbpm.workflow.core.NodeContainer)process, EndNode.class);
        NodeCreator<WorkItemNode> workItemNodeCreator = new NodeCreator<WorkItemNode>((org.jbpm.workflow.core.NodeContainer)process, WorkItemNode.class);
        NodeCreator<BoundaryEventNode> boundaryNodeCreator = new NodeCreator<BoundaryEventNode>((org.jbpm.workflow.core.NodeContainer)process, BoundaryEventNode.class);
        NodeCreator<ActionNode> actionNodeCreator = new NodeCreator<ActionNode>((org.jbpm.workflow.core.NodeContainer)process, ActionNode.class);
        StartNode lastNode = startNode = startNodeCreator.createNode("start");
        WorkItemNode[] workItemNodes = new WorkItemNode[3];
        for (int i = 0; i < 3; ++i) {
            workItemNodes[i] = workItemNodeCreator.createNode("work" + (i + 1));
            workItemNodes[i].getWork().setName(workItemNames[i]);
            NodeCreator.connect((org.jbpm.workflow.core.Node)lastNode, (org.jbpm.workflow.core.Node)workItemNodes[i]);
            lastNode = workItemNodes[i];
        }
        EndNode endNode = endNodeCreator.createNode("end");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNodes[2], (org.jbpm.workflow.core.Node)endNode);
        for (int i = 0; i < 3; ++i) {
            this.createBoundaryEventCompensationHandler((org.jbpm.workflow.core.NodeContainer)process, (org.jbpm.workflow.core.Node)workItemNodes[i], eventList, "" + i + 1);
        }
        return process;
    }

    @Test
    public void testCompensationEventSubProcessSpecific() throws Exception {
        String processId = "org.jbpm.process.compensation.event.subprocess";
        String[] workItemNames = new String[]{"kwik", "kwek", "kwak"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createCompensationEventSubProcessProcess(processId, workItemNames, eventList);
        org.jbpm.workflow.core.Node toCompensateNode = this.findNode(process, "sub0");
        String compensationEvent = (String)toCompensateNode.getMetaData().get("UniqueId");
        this.ksession = this.createKieSession(new Process[]{process});
        CompensationTest.runCompensationEventSubProcessSpecificTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    public static void runCompensationEventSubProcessSpecificTest(KieSession ksession, RuleFlowProcess process, String processId, String[] workItemNames, List<String> eventList, String compensationEvent) {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        for (String workItem : workItemNames) {
            ksession.getWorkItemManager().registerWorkItemHandler(workItem, (WorkItemHandler)workItemHandler);
        }
        ProcessInstance processInstance = ksession.startProcess(processId);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)0, (int)eventList.size(), (String)"Compensation should not have fired yet.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)0, (int)eventList.size(), (String)"Compensation should not have fired yet.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)1, (int)eventList.size(), (String)"Compensation should have fired once.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    @Test
    public void testCompensationEventSubProcessGeneral() throws Exception {
        String processId = "org.jbpm.process.compensation.event.subprocess.general";
        String[] workItemNames = new String[]{"kwik", "kwek", "kwak"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createCompensationEventSubProcessProcess(processId, workItemNames, eventList);
        String compensationEvent = "implicit:" + process.getId();
        this.ksession = this.createKieSession(new Process[]{process});
        CompensationTest.runCompensationEventSubProcessGeneralTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    public static void runCompensationEventSubProcessGeneralTest(KieSession ksession, RuleFlowProcess process, String processId, String[] workItemNames, List<String> eventList, String compensationEvent) {
        TestWorkItemHandler workItemHandler = new TestWorkItemHandler();
        for (String workItem : workItemNames) {
            ksession.getWorkItemManager().registerWorkItemHandler(workItem, (WorkItemHandler)workItemHandler);
        }
        ProcessInstance processInstance = ksession.startProcess(processId);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        ksession.signalEvent("Compensation", (Object)compensationEvent, processInstance.getId());
        Assertions.assertEquals((int)1, (int)eventList.size(), (String)"Compensation should have fired once.");
        ksession.getWorkItemManager().completeWorkItem(workItemHandler.getWorkItems().removeLast().getId(), null, new Policy[0]);
        Assertions.assertEquals((int)2, (int)processInstance.getState());
    }

    private RuleFlowProcess createCompensationEventSubProcessProcess(String processId, String[] workItemNames, final List<String> eventList) throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(processId);
        process.setName("CESP Process");
        process.setMetaData("Compensation", (Object)true);
        NodeCreator<StartNode> startNodeCreator = new NodeCreator<StartNode>((org.jbpm.workflow.core.NodeContainer)process, StartNode.class);
        NodeCreator<WorkItemNode> workItemNodeCreator = new NodeCreator<WorkItemNode>((org.jbpm.workflow.core.NodeContainer)process, WorkItemNode.class);
        NodeCreator<CompositeContextNode> compNodeCreator = new NodeCreator<CompositeContextNode>((org.jbpm.workflow.core.NodeContainer)process, CompositeContextNode.class);
        NodeCreator<EndNode> endNodeCreator = new NodeCreator<EndNode>((org.jbpm.workflow.core.NodeContainer)process, EndNode.class);
        StartNode startNode = startNodeCreator.createNode("start0");
        WorkItemNode workItemNode = workItemNodeCreator.createNode("work0-pre");
        workItemNode.getWork().setName(workItemNames[0]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        CompositeNode compositeNode = (CompositeNode)compNodeCreator.createNode("sub0");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)compositeNode);
        workItemNode = workItemNodeCreator.createNode("work0-post");
        workItemNode.getWork().setName(workItemNames[2]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)compositeNode, (org.jbpm.workflow.core.Node)workItemNode);
        EndNode endNode = endNodeCreator.createNode("end0");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        workItemNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        startNode = startNodeCreator.createNode("start1");
        workItemNode = workItemNodeCreator.createNode("work1");
        workItemNode.getWork().setName(workItemNames[1]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        endNode = endNodeCreator.createNode("end1");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode);
        NodeCreator<EventSubProcessNode> espNodeCreator = new NodeCreator<EventSubProcessNode>((org.jbpm.workflow.core.NodeContainer)compositeNode, EventSubProcessNode.class);
        EventSubProcessNode espNode = espNodeCreator.createNode("eventSub1");
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        espNode.addEvent((EventTypeFilter)eventFilter);
        this.addCompensationScope((org.jbpm.workflow.core.Node)espNode, (NodeContainer)process, (String)compositeNode.getMetaData("UniqueId"));
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)espNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)espNode);
        NodeCreator<ActionNode> actionNodeCreator = new NodeCreator<ActionNode>((org.jbpm.workflow.core.NodeContainer)espNode, ActionNode.class);
        startNode = startNodeCreator.createNode("start1*");
        ActionNode actionNode = actionNodeCreator.createNode("action1*");
        actionNode.setName("Execute");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                eventList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)actionNode);
        endNode = endNodeCreator.createNode("end1*");
        NodeCreator.connect((org.jbpm.workflow.core.Node)actionNode, (org.jbpm.workflow.core.Node)endNode);
        return process;
    }

    @Test
    public void testNestedCompensationEventSubProcessSpecific() throws Exception {
        String processId = "org.jbpm.process.compensation.event.nested.subprocess";
        String[] workItemNames = new String[]{"kwik", "kwek", "kwak"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createNestedCompensationEventSubProcessProcess(processId, workItemNames, eventList);
        org.jbpm.workflow.core.Node toCompensateNode = this.findNode(process, "sub1");
        String compensationEvent = (String)toCompensateNode.getMetaData().get("UniqueId");
        this.ksession = this.createKieSession(new Process[]{process});
        CompensationTest.runCompensationEventSubProcessSpecificTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    @Test
    public void testNestedCompensationEventSubProcessGeneral() throws Exception {
        String processId = "org.jbpm.process.compensation.event.subprocess.general";
        String[] workItemNames = new String[]{"apple", "banana", "orange"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createNestedCompensationEventSubProcessProcess(processId, workItemNames, eventList);
        org.jbpm.workflow.core.Node toCompensateNode = this.findNode(process, "sub0");
        String compensationEvent = "implicit:" + toCompensateNode.getMetaData().get("UniqueId");
        this.ksession = this.createKieSession(new Process[]{process});
        CompensationTest.runCompensationEventSubProcessGeneralTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    private RuleFlowProcess createNestedCompensationEventSubProcessProcess(String processId, String[] workItemNames, final List<String> eventList) throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(processId);
        process.setName("CESP Process");
        process.setMetaData("Compensation", (Object)true);
        NodeCreator<StartNode> startNodeCreator = new NodeCreator<StartNode>((org.jbpm.workflow.core.NodeContainer)process, StartNode.class);
        NodeCreator<WorkItemNode> workItemNodeCreator = new NodeCreator<WorkItemNode>((org.jbpm.workflow.core.NodeContainer)process, WorkItemNode.class);
        NodeCreator<CompositeContextNode> compNodeCreator = new NodeCreator<CompositeContextNode>((org.jbpm.workflow.core.NodeContainer)process, CompositeContextNode.class);
        NodeCreator<EndNode> endNodeCreator = new NodeCreator<EndNode>((org.jbpm.workflow.core.NodeContainer)process, EndNode.class);
        CompositeContextNode compositeNode = compNodeCreator.createNode("sub0");
        StartNode startNode = startNodeCreator.createNode("start0");
        WorkItemNode workItemNode = workItemNodeCreator.createNode("work0-pre");
        workItemNode.getWork().setName(workItemNames[0]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)workItemNode);
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)compositeNode);
        EndNode endNode = endNodeCreator.createNode("end0");
        NodeCreator.connect((org.jbpm.workflow.core.Node)compositeNode, (org.jbpm.workflow.core.Node)endNode);
        CompositeContextNode compensationScopeContainerNode = compositeNode;
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        workItemNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        compNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        StartNode startNode2 = startNodeCreator.createNode("start1");
        CompositeContextNode subCompNode = compNodeCreator.createNode("sub1");
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode2, (org.jbpm.workflow.core.Node)subCompNode);
        WorkItemNode workItemNode2 = workItemNodeCreator.createNode("work1-post");
        workItemNode2.getWork().setName(workItemNames[2]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)subCompNode, (org.jbpm.workflow.core.Node)workItemNode2);
        EndNode endNode2 = endNodeCreator.createNode("end1");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode2, (org.jbpm.workflow.core.Node)endNode2);
        compositeNode = subCompNode;
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        workItemNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        startNode2 = startNodeCreator.createNode("start2");
        WorkItemNode workItemNode3 = workItemNodeCreator.createNode("work2");
        workItemNode3.getWork().setName(workItemNames[1]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode2, (org.jbpm.workflow.core.Node)workItemNode3);
        EndNode endNode3 = endNodeCreator.createNode("end2");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode3, (org.jbpm.workflow.core.Node)endNode3);
        NodeCreator<EventSubProcessNode> espNodeCreator = new NodeCreator<EventSubProcessNode>((org.jbpm.workflow.core.NodeContainer)compositeNode, EventSubProcessNode.class);
        EventSubProcessNode espNode = espNodeCreator.createNode("eventSub2");
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)espNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)espNode);
        NodeCreator<ActionNode> actionNodeCreator = new NodeCreator<ActionNode>((org.jbpm.workflow.core.NodeContainer)espNode, ActionNode.class);
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        espNode.addEvent((EventTypeFilter)eventFilter);
        this.addCompensationScope((org.jbpm.workflow.core.Node)espNode, (NodeContainer)compensationScopeContainerNode, (String)compositeNode.getMetaData("UniqueId"));
        StartNode startNode3 = startNodeCreator.createNode("start3*");
        ActionNode actionNode = actionNodeCreator.createNode("action3*");
        actionNode.setName("Execute");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                eventList.add("Executed action");
            }
        });
        actionNode.setAction((DroolsAction)action);
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode3, (org.jbpm.workflow.core.Node)actionNode);
        EndNode endNode4 = endNodeCreator.createNode("end3*");
        NodeCreator.connect((org.jbpm.workflow.core.Node)actionNode, (org.jbpm.workflow.core.Node)endNode4);
        return process;
    }

    @Test
    public void testNestedCompensationBoundaryEventSpecific() throws Exception {
        String processId = "org.jbpm.process.compensation.boundary.nested";
        String[] workItemNames = new String[]{"Don-Quixote", "Sancho", "Ricote"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createNestedCompensationBoundaryEventProcess(processId, workItemNames, eventList);
        this.ksession = this.createKieSession(new Process[]{process});
        org.jbpm.workflow.core.Node compensatedNode = this.findNode(process, "work-comp-1");
        String compensationEvent = (String)compensatedNode.getMetaData().get("UniqueId");
        CompensationTest.runCompensationBoundaryEventSpecificTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    @Test
    public void testNestedCompensationBoundaryEventGeneral() throws Exception {
        String processId = "org.jbpm.process.compensation.boundary.general.nested";
        String[] workItemNames = new String[]{"Jip", "Janneke", "Takkie"};
        ArrayList<String> eventList = new ArrayList<String>();
        RuleFlowProcess process = this.createNestedCompensationBoundaryEventProcess(processId, workItemNames, eventList);
        this.ksession = this.createKieSession(new Process[]{process});
        org.jbpm.workflow.core.Node toCompensateNode = this.findNode(process, "sub2");
        String compensationEvent = "implicit:" + (String)toCompensateNode.getMetaData().get("UniqueId");
        CompensationTest.runCompensationBoundaryEventGeneralTest(this.ksession, process, processId, workItemNames, eventList, compensationEvent);
    }

    private RuleFlowProcess createNestedCompensationBoundaryEventProcess(String processId, String[] workItemNames, List<String> eventList) throws Exception {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setAutoComplete(true);
        process.setId(processId);
        process.setName("CESP Process");
        process.setMetaData("Compensation", (Object)true);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable = new Variable();
        variable.setName("event");
        ObjectDataType personDataType = new ObjectDataType();
        personDataType.setClassName("java.lang.String");
        variable.setType((DataType)personDataType);
        variables.add(variable);
        process.getVariableScope().setVariables(variables);
        NodeCreator<StartNode> startNodeCreator = new NodeCreator<StartNode>((org.jbpm.workflow.core.NodeContainer)process, StartNode.class);
        NodeCreator<EndNode> endNodeCreator = new NodeCreator<EndNode>((org.jbpm.workflow.core.NodeContainer)process, EndNode.class);
        NodeCreator<CompositeContextNode> compNodeCreator = new NodeCreator<CompositeContextNode>((org.jbpm.workflow.core.NodeContainer)process, CompositeContextNode.class);
        CompositeContextNode compositeNode = compNodeCreator.createNode("sub0");
        StartNode startNode = startNodeCreator.createNode("start0");
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)compositeNode);
        EndNode endNode = endNodeCreator.createNode("end0");
        NodeCreator.connect((org.jbpm.workflow.core.Node)compositeNode, (org.jbpm.workflow.core.Node)endNode);
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        compNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        startNode = startNodeCreator.createNode("start1");
        CompositeContextNode subCompNode = compNodeCreator.createNode("sub1");
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode, (org.jbpm.workflow.core.Node)subCompNode);
        EndNode endNode2 = endNodeCreator.createNode("end1");
        NodeCreator.connect((org.jbpm.workflow.core.Node)subCompNode, (org.jbpm.workflow.core.Node)endNode2);
        compositeNode = subCompNode;
        NodeCreator<WorkItemNode> workItemNodeCreator = new NodeCreator<WorkItemNode>((org.jbpm.workflow.core.NodeContainer)compositeNode, WorkItemNode.class);
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        compNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        StartNode startNode2 = startNodeCreator.createNode("start2");
        CompositeContextNode subCompNode2 = compNodeCreator.createNode("sub2");
        NodeCreator.connect((org.jbpm.workflow.core.Node)startNode2, (org.jbpm.workflow.core.Node)subCompNode2);
        WorkItemNode workItemNode = workItemNodeCreator.createNode("work2");
        workItemNode.getWork().setName(workItemNames[2]);
        NodeCreator.connect((org.jbpm.workflow.core.Node)subCompNode2, (org.jbpm.workflow.core.Node)workItemNode);
        EndNode endNode3 = endNodeCreator.createNode("end2");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNode, (org.jbpm.workflow.core.Node)endNode3);
        this.createBoundaryEventCompensationHandler((org.jbpm.workflow.core.NodeContainer)compositeNode, (org.jbpm.workflow.core.Node)workItemNode, eventList, "2");
        compositeNode = subCompNode2;
        startNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        workItemNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        endNodeCreator.setNodeContainer((org.jbpm.workflow.core.NodeContainer)compositeNode);
        StartNode lastNode = startNode2 = startNodeCreator.createNode("start");
        WorkItemNode[] workItemNodes = new WorkItemNode[3];
        for (int i = 0; i < 2; ++i) {
            workItemNodes[i] = workItemNodeCreator.createNode("work-comp-" + (i + 1));
            workItemNodes[i].getWork().setName(workItemNames[i]);
            NodeCreator.connect((org.jbpm.workflow.core.Node)lastNode, (org.jbpm.workflow.core.Node)workItemNodes[i]);
            lastNode = workItemNodes[i];
        }
        endNode = endNodeCreator.createNode("end");
        NodeCreator.connect((org.jbpm.workflow.core.Node)workItemNodes[1], (org.jbpm.workflow.core.Node)endNode);
        for (int i = 0; i < 2; ++i) {
            this.createBoundaryEventCompensationHandler((org.jbpm.workflow.core.NodeContainer)compositeNode, (org.jbpm.workflow.core.Node)workItemNodes[i], eventList, "" + i + 1);
        }
        return process;
    }

    private void createBoundaryEventCompensationHandler(org.jbpm.workflow.core.NodeContainer nodeContainer, org.jbpm.workflow.core.Node attachedToNode, final List<String> eventList, final String id) throws Exception {
        NodeCreator<BoundaryEventNode> boundaryNodeCreator = new NodeCreator<BoundaryEventNode>(nodeContainer, BoundaryEventNode.class);
        BoundaryEventNode boundaryNode = boundaryNodeCreator.createNode("boundary" + id);
        String attachedTo = (String)attachedToNode.getMetaData().get("UniqueId");
        boundaryNode.setMetaData("AttachedTo", (Object)attachedTo);
        boundaryNode.setAttachedToNodeId(attachedTo);
        NonAcceptingEventTypeFilter eventFilter = new NonAcceptingEventTypeFilter();
        eventFilter.setType("Compensation");
        ArrayList<NonAcceptingEventTypeFilter> eventFilters = new ArrayList<NonAcceptingEventTypeFilter>();
        boundaryNode.setEventFilters(eventFilters);
        eventFilters.add(eventFilter);
        this.addCompensationScope((org.jbpm.workflow.core.Node)boundaryNode, (NodeContainer)nodeContainer, attachedTo);
        NodeCreator<ActionNode> actionNodeCreator = new NodeCreator<ActionNode>(nodeContainer, ActionNode.class);
        ActionNode actionNode = actionNodeCreator.createNode("handlerAction" + id);
        actionNode.setMetaData("isForCompensation", (Object)true);
        actionNode.setName("Execute");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(ProcessContext context) throws Exception {
                eventList.add("action" + id);
            }
        });
        actionNode.setAction((DroolsAction)action);
        NodeCreator.connect((org.jbpm.workflow.core.Node)boundaryNode, (org.jbpm.workflow.core.Node)actionNode);
    }
}

