/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.process.core.datatype.DataType;
import org.jbpm.process.core.datatype.impl.type.BooleanDataType;
import org.jbpm.process.core.datatype.impl.type.ObjectDataType;
import org.jbpm.process.test.Person;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.test.util.AbstractBaseTest;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.impl.ConnectionImpl;
import org.jbpm.workflow.core.node.EndNode;
import org.jbpm.workflow.core.node.RuleSetNode;
import org.jbpm.workflow.core.node.StartNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.dmn.api.core.DMNRuntime;
import org.kie.kogito.dmn.DMNKogito;
import org.kie.kogito.dmn.DmnDecisionModel;
import org.slf4j.LoggerFactory;

public class RuleSetTest
extends AbstractBaseTest {
    @Override
    public void addLogger() {
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Test
    public void testDmn() {
        String namespace = "https://kiegroup.org/dmn/_52CEF9FD-9943-4A89-96D5-6F66810CA4C1";
        String modelName = "PersonDecisions";
        String decisionName = "isAdult";
        RuleFlowProcess process = this.createProcess(namespace, modelName, decisionName);
        KieSession ksession = this.createKieSession(new Process[]{process});
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Person person = new Person("John", 25);
        parameters.put("person", person);
        parameters.put("isAdult", false);
        ProcessInstance pi = ksession.startProcess("org.drools.core.process.process", parameters);
        Assertions.assertEquals((int)2, (int)pi.getState());
        boolean result = (Boolean)pi.getVariables().get("isAdult");
        Assertions.assertEquals((Object)true, (Object)result);
    }

    @Test
    public void testModelNotFound() {
        String namespace = "wrong-namespace";
        String modelName = "wrong-name";
        String decisionName = "isAdult";
        IllegalStateException illegalStateException = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> this.createProcess(namespace, modelName, decisionName));
        Assertions.assertTrue((boolean)illegalStateException.getMessage().contains(namespace));
        Assertions.assertTrue((boolean)illegalStateException.getMessage().contains(modelName));
    }

    private RuleFlowProcess createProcess(String namespace, String modelName, String decisionName) {
        DMNRuntime dmnRuntime = DMNKogito.createGenericDMNRuntime((Reader[])new Reader[]{new InputStreamReader(RuleSetTest.class.getResourceAsStream("/org/jbpm/process/PersonDecisions.dmn"))});
        DmnDecisionModel dmnDecisionModel = new DmnDecisionModel(dmnRuntime, namespace, modelName);
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.core.process.process");
        process.setName("Process");
        ArrayList<Variable> variables = new ArrayList<Variable>();
        Variable variable1 = new Variable();
        variable1.setName("person");
        variable1.setType((DataType)new ObjectDataType(Person.class.getName()));
        variables.add(variable1);
        Variable variable2 = new Variable();
        variable2.setName("isAdult");
        variable2.setType((DataType)new BooleanDataType());
        variables.add(variable2);
        process.getVariableScope().setVariables(variables);
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        RuleSetNode ruleSetNode = new RuleSetNode();
        ruleSetNode.setName("RuleSetNode");
        ruleSetNode.setId(2L);
        ruleSetNode.setRuleType((RuleSetNode.RuleType)RuleSetNode.RuleType.decision((String)namespace, (String)modelName, (String)decisionName));
        ruleSetNode.setLanguage("http://www.jboss.org/drools/dmn");
        ruleSetNode.setDecisionModel(() -> dmnDecisionModel);
        ruleSetNode.addInMapping("Person", "person");
        ruleSetNode.addOutMapping("isAdult", "isAdult");
        EndNode endNode = new EndNode();
        endNode.setName("End");
        endNode.setId(3L);
        this.connect((Node)startNode, (Node)ruleSetNode);
        this.connect((Node)ruleSetNode, (Node)endNode);
        process.addNode((org.kie.api.definition.process.Node)startNode);
        process.addNode((org.kie.api.definition.process.Node)ruleSetNode);
        process.addNode((org.kie.api.definition.process.Node)endNode);
        return process;
    }

    private void connect(Node sourceNode, Node targetNode) {
        new ConnectionImpl((org.kie.api.definition.process.Node)sourceNode, "DROOLS_DEFAULT", (org.kie.api.definition.process.Node)targetNode, "DROOLS_DEFAULT");
    }
}

