/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.ProcessInstance;

class MapProcessInstances<T>
implements MutableProcessInstances<T> {
    private final ConcurrentHashMap<String, ProcessInstance<T>> instances = new ConcurrentHashMap();

    MapProcessInstances() {
    }

    public Optional<? extends ProcessInstance<T>> findById(String id) {
        return Optional.ofNullable(this.instances.get(id));
    }

    public Collection<? extends ProcessInstance<T>> values() {
        return this.instances.values();
    }

    public void update(String id, ProcessInstance<T> instance) {
        if (this.isActive(instance)) {
            this.instances.put(id, instance);
        }
    }

    public void remove(String id) {
        this.instances.remove(id);
    }
}

