/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.ProcessInstanceManager;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.definition.process.Process;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.ProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.kogito.Model;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.uow.UnitOfWork;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.kie.kogito.uow.WorkUnit;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class AbstractProcessInstanceTest {
    private static final String NODE_ID = "my_node_id";
    @Mock
    private ProcessInstanceManager pim;
    @Mock
    private WorkflowProcessInstanceImpl wpi;
    @Mock
    private UnitOfWork unitOfWork;
    private AbstractProcessInstance<TestModel> processInstance;

    @BeforeEach
    private void setup() {
        MockitoAnnotations.initMocks((Object)this);
        AbstractProcess process = (AbstractProcess)Mockito.mock(AbstractProcess.class);
        Mockito.when((Object)process.process()).thenReturn((Object)((Process)Mockito.mock(Process.class)));
        InternalProcessRuntime pr = (InternalProcessRuntime)Mockito.mock(InternalProcessRuntime.class);
        Mockito.when((Object)pr.createProcessInstance((String)ArgumentMatchers.any(), (CorrelationKey)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)this.wpi);
        Mockito.when((Object)pr.getProcessInstanceManager()).thenReturn((Object)this.pim);
        UnitOfWorkManager unitOfWorkManager = (UnitOfWorkManager)Mockito.mock(UnitOfWorkManager.class);
        Mockito.when((Object)pr.getUnitOfWorkManager()).thenReturn((Object)unitOfWorkManager);
        Mockito.when((Object)unitOfWorkManager.currentUnitOfWork()).thenReturn((Object)this.unitOfWork);
        this.processInstance = new TestProcessInstance((AbstractProcess<TestModel>)process, new TestModel(), (ProcessRuntime)pr);
    }

    @Test
    public void testCreateProcessInstance() {
        Assertions.assertThat((int)this.processInstance.status()).isEqualTo(0);
        Assertions.assertThat((String)this.processInstance.id()).isNull();
        Assertions.assertThat((String)this.processInstance.businessKey()).isNull();
        ((ProcessInstanceManager)Mockito.verify((Object)this.pim, (VerificationMode)Mockito.never())).addProcessInstance((ProcessInstance)ArgumentMatchers.any());
    }

    @Test
    public void shouldTriggerNodeWhenStartFrom() {
        NodeInstance nodeInstance = this.givenExistingNode(NODE_ID);
        this.processInstance.startFrom(NODE_ID);
        ((NodeInstance)Mockito.verify((Object)nodeInstance)).trigger(null, "DROOLS_DEFAULT");
        ((UnitOfWork)Mockito.verify((Object)this.unitOfWork)).intercept((WorkUnit)ArgumentMatchers.any());
    }

    @Test
    public void shouldTriggerNodeWhenTrigger() {
        NodeInstance nodeInstance = this.givenExistingNode(NODE_ID);
        this.processInstance.triggerNode(NODE_ID);
        ((NodeInstance)Mockito.verify((Object)nodeInstance)).trigger(null, "DROOLS_DEFAULT");
        ((UnitOfWork)Mockito.verify((Object)this.unitOfWork)).intercept((WorkUnit)ArgumentMatchers.any());
    }

    private NodeInstance givenExistingNode(String nodeId) {
        RuleFlowProcess process = (RuleFlowProcess)Mockito.mock(RuleFlowProcess.class);
        Mockito.when((Object)this.wpi.getProcess()).thenReturn((Object)process);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getMetaData()).thenReturn(Collections.singletonMap("UniqueId", nodeId));
        Mockito.when((Object)process.getNodesRecursively()).thenReturn(Arrays.asList(node));
        NodeInstance nodeInstance = (NodeInstance)Mockito.mock(NodeInstance.class);
        Mockito.when((Object)this.wpi.getNodeInstance(node)).thenReturn((Object)nodeInstance);
        return nodeInstance;
    }

    static class TestModel
    implements Model {
        TestModel() {
        }

        public void update(Map<String, Object> params) {
            this.fromMap(params);
        }

        public Map<String, Object> toMap() {
            return null;
        }

        public void fromMap(Map<String, Object> params) {
        }
    }

    static class TestProcessInstance
    extends AbstractProcessInstance<TestModel> {
        public TestProcessInstance(AbstractProcess<TestModel> process, TestModel variables, ProcessRuntime rt) {
            super(process, (Model)variables, rt);
        }
    }
}

