/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.actions;

import java.io.Serializable;
import org.jbpm.process.core.event.EventTransformerImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.process.workitems.KogitoWorkItem;
import org.kie.kogito.process.workitems.KogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class HandleMessageAction
implements Action,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String messageType;
    private String variableName;
    private Transformation transformation;

    public HandleMessageAction(String messageType, String variableName) {
        this.messageType = messageType;
        this.variableName = variableName;
    }

    public HandleMessageAction(String messageType, String variableName, Transformation transformation) {
        this.messageType = messageType;
        this.variableName = variableName;
        this.transformation = transformation;
    }

    @Override
    public void execute(ProcessContext context) throws Exception {
        Object variable = VariableUtil.resolveVariable(this.variableName, context.getNodeInstance());
        if (this.transformation != null) {
            variable = new EventTransformerImpl(this.transformation).transformEvent(variable);
        }
        KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
        workItem.setName("Send Task");
        workItem.setNodeInstanceId(context.getNodeInstance().getId());
        workItem.setProcessInstanceId(context.getProcessInstance().getId());
        workItem.setNodeId(context.getNodeInstance().getNodeId());
        workItem.setParameter("MessageType", (Object)this.messageType);
        if (variable != null) {
            workItem.setParameter("Message", variable);
        }
        ((KogitoWorkItemManager)context.getKieRuntime().getWorkItemManager()).internalExecuteWorkItem((KogitoWorkItem)workItem);
    }
}

