/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.impl.actions;

import java.io.Serializable;
import java.util.function.Function;
import org.jbpm.process.core.event.EventTransformerImpl;
import org.jbpm.process.instance.impl.Action;
import org.jbpm.process.instance.impl.util.VariableUtil;
import org.jbpm.workflow.core.node.Transformation;
import org.kie.api.runtime.process.ProcessContext;
import org.kie.kogito.process.workitems.KogitoWorkItem;
import org.kie.kogito.process.workitems.KogitoWorkItemManager;
import org.kie.kogito.process.workitems.impl.KogitoWorkItemImpl;

public class SignalProcessInstanceAction
implements Action,
Serializable {
    public static final String DEFAULT_SCOPE = "default";
    public static final String PROCESS_INSTANCE_SCOPE = "processInstance";
    public static final String EXTERNAL_SCOPE = "external";
    public static final String UNSET_SCOPE = System.getProperty("org.jbpm.signals.defaultscope", "processInstance");
    private static final long serialVersionUID = 1L;
    private final String signalName;
    private String variableName;
    private Function<ProcessContext, Object> eventDataSupplier = kcontext -> null;
    private String scope = UNSET_SCOPE;
    private Transformation transformation;

    public SignalProcessInstanceAction(String signalName, String variableName) {
        this.signalName = signalName;
        this.variableName = variableName;
    }

    public SignalProcessInstanceAction(String signalName, String variableName, Transformation transformation) {
        this.signalName = signalName;
        this.variableName = variableName;
        this.transformation = transformation;
    }

    public SignalProcessInstanceAction(String signalName, String variableName, String scope) {
        this.signalName = signalName;
        this.variableName = variableName;
        if (scope != null) {
            this.scope = scope;
        }
    }

    public SignalProcessInstanceAction(String signalName, String variableName, String scope, Transformation transformation) {
        this.signalName = signalName;
        this.variableName = variableName;
        if (scope != null) {
            this.scope = scope;
        }
        this.transformation = transformation;
    }

    public SignalProcessInstanceAction(String signalName, Function<ProcessContext, Object> eventDataSupplier, String scope) {
        this.signalName = signalName;
        this.eventDataSupplier = eventDataSupplier;
        if (scope != null) {
            this.scope = scope;
        }
    }

    @Override
    public void execute(ProcessContext context) throws Exception {
        Object variable;
        String variableName = VariableUtil.resolveVariable(this.variableName, context.getNodeInstance());
        Object object = variable = variableName == null ? this.eventDataSupplier.apply(context) : context.getVariable(variableName);
        if (this.transformation != null) {
            variable = new EventTransformerImpl(this.transformation).transformEvent(context.getProcessInstance().getVariables());
        }
        if (DEFAULT_SCOPE.equals(this.scope)) {
            context.getKieRuntime().signalEvent(VariableUtil.resolveVariable(this.signalName, context.getNodeInstance()), variable);
        } else if (PROCESS_INSTANCE_SCOPE.equals(this.scope)) {
            context.getProcessInstance().signalEvent(VariableUtil.resolveVariable(this.signalName, context.getNodeInstance()), variable);
        } else if (EXTERNAL_SCOPE.equals(this.scope)) {
            KogitoWorkItemImpl workItem = new KogitoWorkItemImpl();
            workItem.setName("External Send Task");
            workItem.setNodeInstanceId(context.getNodeInstance().getId());
            workItem.setProcessInstanceId(context.getProcessInstance().getId());
            workItem.setNodeId(context.getNodeInstance().getNodeId());
            workItem.setParameter("Signal", (Object)VariableUtil.resolveVariable(this.signalName, context.getNodeInstance()));
            workItem.setParameter("SignalProcessInstanceId", context.getVariable("SignalProcessInstanceId"));
            workItem.setParameter("SignalWorkItemId", context.getVariable("SignalWorkItemId"));
            workItem.setParameter("SignalDeploymentId", context.getVariable("SignalDeploymentId"));
            if (variable == null) {
                workItem.setParameter("Data", variable);
            }
            ((KogitoWorkItemManager)context.getKieRuntime().getWorkItemManager()).internalExecuteWorkItem((KogitoWorkItem)workItem);
        }
    }
}

