/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.LifeCyclePhase;
import org.kie.kogito.process.workitem.Policy;

public class JsonSchemaUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static Path jsonDir = Paths.get("META-INF", "jsonSchema");

    private JsonSchemaUtil() {
    }

    public static String getJsonSchemaName(String processId, String taskName) {
        return (processId + "_" + taskName).replace('.', '#').replaceAll("\\s", "_");
    }

    public static Path getJsonDir() {
        return jsonDir;
    }

    public static String getFileName(String key) {
        return key + ".json";
    }

    public static Map<String, Object> load(ClassLoader cl, String processId, String taskName) {
        Map<String, Object> map;
        block9: {
            Path jsonFile = jsonDir.resolve(JsonSchemaUtil.getFileName(JsonSchemaUtil.getJsonSchemaName(processId, taskName)));
            InputStream in = cl.getResourceAsStream(jsonFile.toString());
            try {
                if (in == null) {
                    throw new IllegalArgumentException("Cannot find file " + jsonFile + " in classpath");
                }
                map = JsonSchemaUtil.load(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new IllegalStateException("Error loading schema " + jsonFile, io);
                }
            }
            in.close();
        }
        return map;
    }

    public static Map<String, Object> load(InputStream in) throws IOException {
        return (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static <T> Map<String, Object> addPhases(Process<T> process, Application application, String processInstanceId, String workItemId, Policy<?>[] policies, Map<String, Object> jsonSchema) {
        return process.instances().findById(processInstanceId, ProcessInstanceReadMode.READ_ONLY).map(pi -> {
            jsonSchema.put("phases", JsonSchemaUtil.allowedPhases(((ProcessConfig)application.config().get(ProcessConfig.class)).workItemHandlers().forName("Human Task"), pi.workItem(workItemId, policies)));
            return jsonSchema;
        }).orElseThrow(() -> new ProcessInstanceNotFoundException(processInstanceId));
    }

    public static Set<String> allowedPhases(WorkItemHandler handler, WorkItem workItem) {
        return handler.allowedPhases(workItem.getPhase()).map(LifeCyclePhase::id).collect(Collectors.toSet());
    }
}

