/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.Collection;
import java.util.Date;
import org.jbpm.workflow.core.node.BoundaryEventNode;
import org.jbpm.workflow.instance.NodeInstance;
import org.jbpm.workflow.instance.NodeInstanceContainer;
import org.jbpm.workflow.instance.impl.WorkflowProcessInstanceImpl;
import org.jbpm.workflow.instance.node.EventNodeInstance;

public class BoundaryEventNodeInstance
extends EventNodeInstance {
    private static final long serialVersionUID = -4958054074031174180L;

    @Override
    public void signalEvent(String type, Object event) {
        if (this.triggerTime == null) {
            this.triggerTime = new Date();
        }
        BoundaryEventNode boundaryNode = (BoundaryEventNode)this.getEventNode();
        String attachedTo = boundaryNode.getAttachedToNodeId();
        Collection nodeInstances = this.getProcessInstance().getNodeInstances(true);
        if (type != null && type.startsWith("Compensation")) {
            if (!this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event) && this.isAttachedToNodeCompleted(attachedTo)) {
                super.signalEvent(type, event);
            } else {
                this.cancel();
            }
        } else if (this.isAttachedToNodeActive(nodeInstances, attachedTo, type, event)) {
            super.signalEvent(type, event);
        } else {
            this.cancel();
        }
    }

    private boolean isAttachedToNodeActive(Collection<NodeInstance> nodeInstances, String attachedTo, String type, Object event) {
        if (nodeInstances != null && !nodeInstances.isEmpty()) {
            for (NodeInstance nInstance : nodeInstances) {
                String nodeUniqueId = (String)nInstance.getNode().getMetaData().get("UniqueId");
                boolean isActivating = ((WorkflowProcessInstanceImpl)nInstance.getProcessInstance()).getActivatingNodeIds().contains(nodeUniqueId);
                if (!attachedTo.equals(nodeUniqueId) || isActivating) continue;
                if (type.startsWith("Timer-")) {
                    if (!nInstance.getId().equals(event)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean isAttachedToNodeCompleted(String attachedTo) {
        WorkflowProcessInstanceImpl processInstance = (WorkflowProcessInstanceImpl)this.getProcessInstance();
        return processInstance.getCompletedNodeIds().contains(attachedTo);
    }

    @Override
    public void cancel() {
        this.getProcessInstance().removeEventListener(this.getEventType(), this.getEventListener(), true);
        ((NodeInstanceContainer)this.getNodeInstanceContainer()).removeNodeInstance(this);
    }
}

