/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.event.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.event.impl.JacksonEventConsumer;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataEventConsumer<M extends Model, D>
extends JacksonEventConsumer<M> {
    private static final Logger logger = LoggerFactory.getLogger(DataEventConsumer.class);
    private Function<D, M> function;
    private Class<D> dataEventClass;

    public DataEventConsumer(Function<D, M> function, Class<D> dataEventClass, ObjectMapper mapper) {
        super(mapper);
        this.function = function;
        this.dataEventClass = dataEventClass;
    }

    public void consume(Application application, Process<M> process, String payload, String trigger) {
        try {
            Object eventData = this.mapper.readValue(payload, this.dataEventClass);
            Model model = (Model)this.function.apply(eventData);
            UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)application.unitOfWorkManager(), () -> {
                logger.debug("Received message without reference id, staring new process instance with trigger '{}'", (Object)trigger);
                ProcessInstance pi = process.createInstance((Object)model);
                pi.start(trigger, null);
                return null;
            });
        }
        catch (JsonProcessingException e) {
            logger.error("Error when consuming message for process {}", (Object)process.id(), (Object)e);
        }
    }
}

