/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event.listeners;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcessInstance;

public class RuleAwareProcessEventListener
implements ProcessEventListener {
    private ConcurrentHashMap<String, FactHandle> store = new ConcurrentHashMap();

    public void beforeProcessStarted(ProcessStartedEvent event) {
        FactHandle handle = event.getKieRuntime().insert((Object)event.getProcessInstance());
        this.store.put(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), handle);
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().delete(handle);
        }
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        FactHandle handle = this.getProcessInstanceFactHandle(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), event.getKieRuntime());
        if (handle != null) {
            event.getKieRuntime().update(handle, (Object)event.getProcessInstance());
        } else {
            handle = event.getKieRuntime().insert((Object)event.getProcessInstance());
            this.store.put(((KogitoProcessInstance)event.getProcessInstance()).getStringId(), handle);
        }
    }

    protected FactHandle getProcessInstanceFactHandle(String processInstanceId, KieRuntime kruntime) {
        if (this.store.containsKey(processInstanceId)) {
            return this.store.get(processInstanceId);
        }
        Collection factHandles = kruntime.getFactHandles(object -> WorkflowProcessInstance.class.isAssignableFrom(object.getClass()) && ((KogitoWorkflowProcessInstance)object).getStringId().equals(processInstanceId));
        if (factHandles != null && !factHandles.isEmpty()) {
            FactHandle handle = (FactHandle)factHandles.iterator().next();
            this.store.put(processInstanceId, handle);
            return handle;
        }
        return null;
    }
}

