/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoWorkItemHandler;
import org.kie.kogito.process.WorkItemHandlerConfig;
import org.kie.kogito.process.impl.AbstractProcessConfig;
import org.kie.kogito.process.impl.CachedWorkItemHandlerConfig;
import org.mockito.Mockito;

public class AbstractProcessConfigTest {
    @Test
    void testOneWorkItemHandlerConfig() {
        CachedWorkItemHandlerConfig workItemConfig = new CachedWorkItemHandlerConfig();
        MockProcessConfig config = new MockProcessConfig(List.of(workItemConfig));
        Assertions.assertSame((Object)workItemConfig, (Object)config.workItemHandlers());
    }

    @Test
    void testMultipleWorkItemHandlerConfig() {
        CachedWorkItemHandlerConfig workItemConfig1 = new CachedWorkItemHandlerConfig();
        CachedWorkItemHandlerConfig workItemConfig2 = new CachedWorkItemHandlerConfig();
        String name1 = "Javierito1";
        String name2 = "Javierito2";
        KogitoWorkItemHandler workItem1 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        KogitoWorkItemHandler workItem2 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        workItemConfig1.register("Javierito1", workItem1);
        workItemConfig2.register("Javierito2", workItem2);
        MockProcessConfig config = new MockProcessConfig(List.of(workItemConfig1, workItemConfig2));
        Assertions.assertEquals(Set.of("Javierito1", "Javierito2"), (Object)config.workItemHandlers().names());
        Assertions.assertSame((Object)workItem1, (Object)config.workItemHandlers().forName("Javierito1"));
        Assertions.assertSame((Object)workItem2, (Object)config.workItemHandlers().forName("Javierito2"));
        String name3 = "Javierito3";
        KogitoWorkItemHandler workItem3 = (KogitoWorkItemHandler)Mockito.mock(KogitoWorkItemHandler.class);
        workItemConfig2.register("Javierito3", workItem3);
        Assertions.assertEquals(Set.of("Javierito1", "Javierito2", "Javierito3"), (Object)config.workItemHandlers().names());
        Assertions.assertSame((Object)workItem3, (Object)config.workItemHandlers().forName("Javierito3"));
    }

    private static class MockProcessConfig
    extends AbstractProcessConfig {
        protected MockProcessConfig(Iterable<WorkItemHandlerConfig> workItemHandlerConfig) {
            super(workItemHandlerConfig, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList());
        }
    }
}

