/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.impl;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManager;
import org.junit.jupiter.api.Test;
import org.kie.kogito.internal.process.runtime.KogitoProcessInstance;
import org.mockito.Mockito;

public class DefaultProcessInstanceManagerTest {
    @Test
    public void testCreateProcessInstance() {
        DefaultProcessInstanceManager pim = new DefaultProcessInstanceManager();
        String processId = "processId";
        String instanceId = UUID.randomUUID().toString();
        KogitoProcessInstance kpi = (KogitoProcessInstance)Mockito.mock(KogitoProcessInstance.class);
        Mockito.when((Object)kpi.getProcessId()).thenReturn((Object)"processId");
        Mockito.when((Object)kpi.getStringId()).thenReturn((Object)instanceId);
        pim.setLock(false);
        pim.internalAddProcessInstance(kpi);
        KogitoProcessInstance processInstance = pim.getProcessInstance(instanceId);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("processId");
        pim.removeProcessInstance(kpi);
        pim.setLock(true);
        pim.internalAddProcessInstance(kpi);
        processInstance = pim.getProcessInstance(instanceId, false);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("processId");
        processInstance = pim.getProcessInstance(instanceId, true);
        Assertions.assertThat((String)processInstance.getProcessId()).isEqualTo("processId");
        pim.removeProcessInstance(kpi);
        pim.clearProcessInstances();
    }
}

