/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.instance.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.MarshallerReaderContext;
import org.drools.core.marshalling.MarshallerWriteContext;
import org.drools.core.phreak.PropagationEntry;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.kie.api.runtime.process.EventListener;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.kogito.signal.SignalManager;

public class DefaultSignalManager
implements SignalManager {
    private Map<String, List<EventListener>> processEventListeners = new ConcurrentHashMap<String, List<EventListener>>();
    private InternalKnowledgeRuntime kruntime;

    public DefaultSignalManager(InternalKnowledgeRuntime kruntime) {
        this.kruntime = kruntime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners = this.processEventListeners.get(type);
        if (eventListeners == null) {
            Map<String, List<EventListener>> map = this.processEventListeners;
            synchronized (map) {
                eventListeners = this.processEventListeners.get(type);
                if (eventListeners == null) {
                    eventListeners = new CopyOnWriteArrayList<EventListener>();
                    this.processEventListeners.put(type, eventListeners);
                }
            }
        }
        eventListeners.add(eventListener);
    }

    public void removeEventListener(String type, EventListener eventListener) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            eventListeners.remove(eventListener);
            if (eventListeners.isEmpty()) {
                this.processEventListeners.remove(type);
            }
        }
    }

    public void signalEvent(String type, Object event) {
        ((DefaultSignalManager)((InternalProcessRuntime)this.kruntime.getProcessRuntime()).getSignalManager()).internalSignalEvent(type, event);
    }

    public void internalSignalEvent(String type, Object event) {
        List<EventListener> eventListeners;
        if (this.processEventListeners != null && (eventListeners = this.processEventListeners.get(type)) != null) {
            for (EventListener eventListener : eventListeners) {
                eventListener.signalEvent(type, event);
            }
        }
    }

    public void signalEvent(String processInstanceId, String type, Object event) {
        ProcessInstance processInstance = this.kruntime.getProcessInstance(processInstanceId);
        if (processInstance != null) {
            processInstance.signalEvent(type, event);
        }
    }

    public boolean accept(String type, Object event) {
        return this.processEventListeners.containsKey(type);
    }

    public static class SignalAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String type;
        private Object event;

        public SignalAction(String type, Object event) {
            this.type = type;
            this.event = event;
        }

        public SignalAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        public void execute(ReteEvaluator reteEvaluator) {
            ((DefaultSignalManager)((InternalProcessRuntime)((InternalWorkingMemory)reteEvaluator).getProcessRuntime()).getSignalManager()).internalSignalEvent(this.type, this.event);
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            ((DefaultSignalManager)((InternalProcessRuntime)kruntime.getProcessRuntime()).getSignalManager()).internalSignalEvent(this.type, this.event);
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(7);
            context.writeUTF(this.type);
            context.writeBoolean(this.event != null);
            if (this.event != null) {
                context.writeObject(this.event);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readUTF();
            if (in.readBoolean()) {
                this.event = in.readObject();
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.type);
            out.writeBoolean(this.event != null);
            if (this.event != null) {
                out.writeObject(this.event);
            }
        }
    }

    public static class SignalProcessInstanceAction
    extends PropagationEntry.AbstractPropagationEntry
    implements WorkingMemoryAction {
        private String processInstanceId;
        private String type;
        private Object event;

        public SignalProcessInstanceAction(String processInstanceId, String type, Object event) {
            this.processInstanceId = processInstanceId;
            this.type = type;
            this.event = event;
        }

        public SignalProcessInstanceAction(MarshallerReaderContext context) throws IOException, ClassNotFoundException {
            this.processInstanceId = context.readUTF();
            this.type = context.readUTF();
            if (context.readBoolean()) {
                this.event = context.readObject();
            }
        }

        public void execute(ReteEvaluator reteEvaluator) {
            ProcessInstance processInstance = ((InternalKnowledgeRuntime)reteEvaluator).getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.type, this.event);
            }
        }

        public void execute(InternalKnowledgeRuntime kruntime) {
            ProcessInstance processInstance = kruntime.getProcessInstance(this.processInstanceId);
            if (processInstance != null) {
                processInstance.signalEvent(this.type, this.event);
            }
        }

        public void write(MarshallerWriteContext context) throws IOException {
            context.writeInt(6);
            context.writeUTF(this.processInstanceId);
            context.writeUTF(this.type);
            context.writeBoolean(this.event != null);
            if (this.event != null) {
                context.writeObject(this.event);
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.processInstanceId = in.readUTF();
            this.type = in.readUTF();
            if (in.readBoolean()) {
                this.event = in.readObject();
            }
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.processInstanceId);
            out.writeUTF(this.type);
            out.writeBoolean(this.event != null);
            if (this.event != null) {
                out.writeObject(this.event);
            }
        }
    }
}

